/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.snapshot;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.CannotClearSiddhiAppStateException;
import io.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import io.siddhi.core.exception.NoPersistenceStoreException;
import io.siddhi.core.exception.PersistenceStoreException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.util.ThreadBarrier;
import io.siddhi.core.util.persistence.IncrementalPersistenceStore;
import io.siddhi.core.util.persistence.PersistenceStore;
import io.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;
import io.siddhi.core.util.persistence.util.PersistenceHelper;
import io.siddhi.core.util.snapshot.ByteSerializer;
import io.siddhi.core.util.snapshot.IncrementalSnapshot;
import io.siddhi.core.util.snapshot.SnapshotRequest;
import io.siddhi.core.util.snapshot.state.Snapshot;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateHolder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnapshotService {
    private static final Logger log = LogManager.getLogger(SnapshotService.class);
    private static final ThreadLocal<Boolean> skipStateStorageThreadLocal = new ThreadLocal();
    private final ThreadBarrier threadBarrier;
    private ConcurrentHashMap<String, PartitionIdStateHolder> partitionIdStates;
    private SiddhiAppContext siddhiAppContext;

    public SnapshotService(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.threadBarrier = siddhiAppContext.getThreadBarrier();
        this.partitionIdStates = new ConcurrentHashMap();
    }

    public static ThreadLocal<Boolean> getSkipStateStorageThreadLocal() {
        return skipStateStorageThreadLocal;
    }

    public ConcurrentHashMap<String, PartitionIdStateHolder> getStates() {
        return this.partitionIdStates;
    }

    public Map<String, StateHolder> getStateHolderMap(String partitionId, String queryName) {
        Boolean skipSnapshotable = skipStateStorageThreadLocal.get();
        if (skipSnapshotable == null || !skipSnapshotable.booleanValue()) {
            ElementStateHolder elementStateHolder;
            PartitionIdStateHolder partitionIdStateHolder = this.partitionIdStates.get(partitionId);
            if (partitionIdStateHolder == null) {
                partitionIdStateHolder = new PartitionIdStateHolder(partitionId);
                this.partitionIdStates.put(partitionId, partitionIdStateHolder);
            }
            if ((elementStateHolder = partitionIdStateHolder.getElementState(queryName)) == null) {
                elementStateHolder = new ElementStateHolder(queryName, new HashMap<String, StateHolder>());
                partitionIdStateHolder.addElementState(queryName, elementStateHolder);
            }
            return elementStateHolder.elementHolderMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fullSnapshot() {
        try {
            SnapshotRequest.requestForFullSnapshot(true);
            HashMap<String, Map> fullSnapshot = new HashMap<String, Map>();
            byte[] serializedFullState = null;
            if (log.isDebugEnabled()) {
                log.debug("Taking snapshot ...");
            }
            try {
                this.threadBarrier.lock();
                this.waitForSystemStabilization();
                for (Map.Entry<String, PartitionIdStateHolder> partitionIdState : this.partitionIdStates.entrySet()) {
                    for (Map.Entry queryState : partitionIdState.getValue().queryStateHolderMap.entrySet()) {
                        for (Map.Entry elementState : ((ElementStateHolder)queryState.getValue()).elementHolderMap.entrySet()) {
                            Map partitionKeyStates = ((StateHolder)elementState.getValue()).getAllStates();
                            try {
                                for (Map.Entry partitionKeyState : partitionKeyStates.entrySet()) {
                                    for (Map.Entry groupByKeyState : partitionKeyState.getValue().entrySet()) {
                                        String partitionAndGroupByKey = partitionKeyState.getKey() + "--" + groupByKeyState.getKey();
                                        State state = (State)groupByKeyState.getValue();
                                        Map<String, Object> itemStates = state.snapshot();
                                        if (itemStates == null) continue;
                                        HashMap<String, Object> itemSnapshots = new HashMap<String, Object>();
                                        for (Map.Entry<String, Object> itemState : itemStates.entrySet()) {
                                            if (itemState.getValue() instanceof Snapshot) {
                                                if (((Snapshot)itemState.getValue()).isIncrementalSnapshot()) {
                                                    throw new NoPersistenceStoreException("No incremental persistence store exist to store incremental snapshot of siddhiApp:'" + this.siddhiAppContext.getName() + "' subElement:'" + (String)queryState.getKey() + "' elementId:'" + (String)elementState.getKey() + "' partitionKey:'" + partitionKeyState.getKey() + "' groupByKey:'" + groupByKeyState.getKey() + "' and itemKey:'" + itemState.getKey() + "'");
                                                }
                                                itemSnapshots.put(itemState.getKey(), itemState.getValue());
                                                continue;
                                            }
                                            itemSnapshots.put(itemState.getKey(), itemState.getValue());
                                        }
                                        Map partitionIdSnapshot = fullSnapshot.computeIfAbsent(partitionIdState.getKey(), k -> new HashMap());
                                        Map partitionGroupByKeySnapshot = partitionIdSnapshot.computeIfAbsent(partitionAndGroupByKey, k -> new HashMap());
                                        Map querySnapshot = partitionGroupByKeySnapshot.computeIfAbsent((String)queryState.getKey(), k -> new HashMap());
                                        Map elementSnapshot = (Map)querySnapshot.get(elementState.getKey());
                                        if (elementSnapshot == null) {
                                            querySnapshot.put((String)elementState.getKey(), itemSnapshots);
                                            continue;
                                        }
                                        throw new SiddhiAppRuntimeException("Duplicate state exist for siddhiApp:'" + this.siddhiAppContext.getName() + "' partitionKey:'" + partitionKeyState.getKey() + "' groupByKey:'" + groupByKeyState.getKey() + "' subElement:'" + (String)queryState.getKey() + "' elementId:'" + (String)elementState.getKey() + "'");
                                    }
                                }
                            }
                            finally {
                                ((StateHolder)elementState.getValue()).returnAllStates(partitionKeyStates);
                            }
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Snapshot serialization started ...");
                }
                serializedFullState = ByteSerializer.objectToByte(fullSnapshot, this.siddhiAppContext);
                if (log.isDebugEnabled()) {
                    log.debug("Snapshot serialization finished.");
                }
            }
            finally {
                this.threadBarrier.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug("Snapshot taken for Siddhi app '" + this.siddhiAppContext.getName() + "'");
            }
            Object object = serializedFullState;
            return object;
        }
        finally {
            SnapshotRequest.requestForFullSnapshot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalSnapshot incrementalSnapshot() {
        try {
            SnapshotRequest.requestForFullSnapshot(false);
            HashMap<String, Map<String, byte[]>> incrementalSnapshotMap = new HashMap<String, Map<String, byte[]>>();
            HashMap<String, Map<String, byte[]>> incrementalBaseSnapshotMap = new HashMap<String, Map<String, byte[]>>();
            HashMap<String, Map<String, byte[]>> periodicSnapshotMap = new HashMap<String, Map<String, byte[]>>();
            if (log.isDebugEnabled()) {
                log.debug("Taking snapshot ...");
            }
            try {
                this.threadBarrier.lock();
                this.waitForSystemStabilization();
                for (Map.Entry<String, PartitionIdStateHolder> partitionIdState : this.partitionIdStates.entrySet()) {
                    for (Map.Entry<String, ElementStateHolder> entry : partitionIdState.getValue().queryStateHolderMap.entrySet()) {
                        for (Map.Entry<String, StateHolder> entry2 : ((ElementStateHolder)entry.getValue()).elementHolderMap.entrySet()) {
                            Map partitionKeyStates = ((StateHolder)entry2.getValue()).getAllStates();
                            try {
                                for (Map.Entry<String, Map<String, State>> entry3 : partitionKeyStates.entrySet()) {
                                    for (Map.Entry<String, State> entry4 : entry3.getValue().entrySet()) {
                                        State state = (State)entry4.getValue();
                                        Map<String, Object> itemStates = state.snapshot();
                                        if (itemStates == null) continue;
                                        HashMap<String, Object> itemSnapshotsIncremental = new HashMap<String, Object>();
                                        HashMap<String, Object> itemSnapshotsIncrementalBase = new HashMap<String, Object>();
                                        HashMap<String, Object> itemSnapshotsPeriodic = new HashMap<String, Object>();
                                        for (Map.Entry<String, Object> itemState : itemStates.entrySet()) {
                                            if (itemState.getValue() instanceof Snapshot) {
                                                if (((Snapshot)itemState.getValue()).isIncrementalSnapshot()) {
                                                    itemSnapshotsIncremental.put(itemState.getKey(), itemState.getValue());
                                                    continue;
                                                }
                                                itemSnapshotsIncrementalBase.put(itemState.getKey(), itemState.getValue());
                                                continue;
                                            }
                                            itemSnapshotsPeriodic.put(itemState.getKey(), itemState.getValue());
                                        }
                                        if (!itemSnapshotsIncremental.isEmpty()) {
                                            this.addToSnapshotIncrements(incrementalSnapshotMap, partitionIdState, entry, entry2, entry3, entry4, itemSnapshotsIncremental);
                                        }
                                        if (!itemSnapshotsIncrementalBase.isEmpty()) {
                                            this.addToSnapshotIncrements(incrementalBaseSnapshotMap, partitionIdState, entry, entry2, entry3, entry4, itemSnapshotsIncrementalBase);
                                        }
                                        if (itemSnapshotsPeriodic.isEmpty()) continue;
                                        this.addToSnapshotIncrements(periodicSnapshotMap, partitionIdState, entry, entry2, entry3, entry4, itemSnapshotsPeriodic);
                                    }
                                }
                            }
                            finally {
                                ((StateHolder)entry2.getValue()).returnAllStates(partitionKeyStates);
                            }
                        }
                    }
                }
            }
            finally {
                this.threadBarrier.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug("Snapshot taken for Siddhi app '" + this.siddhiAppContext.getName() + "'");
            }
            IncrementalSnapshot snapshot = new IncrementalSnapshot();
            if (!incrementalSnapshotMap.isEmpty()) {
                snapshot.setIncrementalState(incrementalSnapshotMap);
            }
            if (!incrementalBaseSnapshotMap.isEmpty()) {
                snapshot.setIncrementalStateBase(incrementalBaseSnapshotMap);
            }
            if (!periodicSnapshotMap.isEmpty()) {
                snapshot.setPeriodicState(periodicSnapshotMap);
            }
            IncrementalSnapshot incrementalSnapshot = snapshot;
            return incrementalSnapshot;
        }
        finally {
            SnapshotRequest.requestForFullSnapshot(false);
        }
    }

    private void addToSnapshotIncrements(Map<String, Map<String, byte[]>> incrementalSnapshotMap, Map.Entry<String, PartitionIdStateHolder> partitionIdState, Map.Entry<String, ElementStateHolder> queryState, Map.Entry<String, StateHolder> elementState, Map.Entry<String, Map<String, State>> partitionKeyState, Map.Entry<String, State> groupByKeyState, Map<String, Object> itemSnapshotsIncremental) {
        String id = partitionKeyState.getKey() + "--" + groupByKeyState.getKey() + "__" + queryState.getKey() + "__" + elementState.getKey();
        Map partitionIdSnapshot = incrementalSnapshotMap.computeIfAbsent(partitionIdState.getKey(), k -> new HashMap());
        partitionIdSnapshot.put(id, ByteSerializer.objectToByte(itemSnapshotsIncremental, this.siddhiAppContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryState(String queryName) {
        HashMap<String, Object> queryState = new HashMap<String, Object>();
        try {
            ElementStateHolder elementStateHolder;
            this.threadBarrier.lock();
            this.waitForSystemStabilization();
            PartitionIdStateHolder partitionIdStateHolder = this.partitionIdStates.get("");
            if (partitionIdStateHolder != null && (elementStateHolder = (ElementStateHolder)partitionIdStateHolder.queryStateHolderMap.get(queryName)) != null) {
                for (Map.Entry elementState : elementStateHolder.elementHolderMap.entrySet()) {
                    Map partitionKeyStates = ((StateHolder)elementState.getValue()).getAllStates();
                    try {
                        for (Map.Entry partitionKeyState : partitionKeyStates.entrySet()) {
                            for (Map.Entry groupByKeyState : partitionKeyState.getValue().entrySet()) {
                                String id = partitionKeyState.getKey() + "--" + groupByKeyState.getKey() + "_" + queryName + "_" + (String)elementState.getKey();
                                queryState.put(id, ((State)groupByKeyState.getValue()).snapshot());
                            }
                        }
                    }
                    finally {
                        ((StateHolder)elementState.getValue()).returnAllStates(partitionKeyStates);
                    }
                }
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("Taking snapshot finished.");
        }
        return queryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(byte[] snapshot) throws CannotRestoreSiddhiAppStateException {
        if (snapshot == null) {
            throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " failed due to no snapshot.");
        }
        Map fullSnapshot = (Map)ByteSerializer.byteToObject(snapshot, this.siddhiAppContext);
        if (fullSnapshot == null) {
            throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " failed due to invalid snapshot.");
        }
        try {
            this.threadBarrier.lock();
            this.waitForSystemStabilization();
            try {
                this.cleanGroupByStates();
                for (Map.Entry partitionIdSnapshot : fullSnapshot.entrySet()) {
                    PartitionIdStateHolder partitionStateHolder = this.partitionIdStates.get(partitionIdSnapshot.getKey());
                    if (partitionStateHolder == null) continue;
                    for (Map.Entry partitionGroupByKeySnapshot : ((Map)partitionIdSnapshot.getValue()).entrySet()) {
                        for (Map.Entry querySnapshot : ((Map)partitionGroupByKeySnapshot.getValue()).entrySet()) {
                            ElementStateHolder elementStateHolder = (ElementStateHolder)partitionStateHolder.queryStateHolderMap.get(querySnapshot.getKey());
                            if (elementStateHolder == null) continue;
                            for (Map.Entry elementSnapshot : ((Map)querySnapshot.getValue()).entrySet()) {
                                StateHolder stateHolder = (StateHolder)elementStateHolder.elementHolderMap.get(elementSnapshot.getKey());
                                if (stateHolder == null) continue;
                                try {
                                    String[] keys;
                                    String partitionKey = null;
                                    String groupByKey = null;
                                    if (partitionGroupByKeySnapshot.getKey() != null && (keys = ((String)partitionGroupByKeySnapshot.getKey()).split("--")).length == 2) {
                                        if (!keys[0].equals("null")) {
                                            partitionKey = keys[0];
                                        }
                                        if (!keys[1].equals("null")) {
                                            groupByKey = keys[1];
                                        }
                                    }
                                    SiddhiAppContext.startPartitionFlow(partitionKey);
                                    SiddhiAppContext.startGroupByFlow(groupByKey);
                                    Object state = stateHolder.getState();
                                    try {
                                        if (state == null) continue;
                                        HashMap<String, Object> snapshotRestores = new HashMap<String, Object>();
                                        for (Map.Entry itemSnapshot : ((Map)elementSnapshot.getValue()).entrySet()) {
                                            if (itemSnapshot.getValue() instanceof Snapshot) {
                                                SnapshotStateList snapshotStateList = new SnapshotStateList();
                                                snapshotStateList.putSnapshotState(0L, (Snapshot)itemSnapshot.getValue());
                                                snapshotRestores.put((String)itemSnapshot.getKey(), snapshotStateList);
                                                continue;
                                            }
                                            snapshotRestores.put((String)itemSnapshot.getKey(), itemSnapshot.getValue());
                                        }
                                        ((State)state).restore(snapshotRestores);
                                    }
                                    finally {
                                        stateHolder.returnState(state);
                                    }
                                }
                                finally {
                                    SiddhiAppContext.stopPartitionFlow();
                                    SiddhiAppContext.stopGroupByFlow();
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " not completed properly because content of Siddhi app has changed since last state persistence. Clean persistence store for a fresh deployment.", t);
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(Map<String, Map<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>>> snapshot) throws CannotRestoreSiddhiAppStateException {
        try {
            this.threadBarrier.lock();
            this.waitForSystemStabilization();
            try {
                this.cleanGroupByStates();
                for (Map.Entry<String, Map<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>>> partitionIdSnapshot : snapshot.entrySet()) {
                    PartitionIdStateHolder partitionStateHolder = this.partitionIdStates.get(partitionIdSnapshot.getKey());
                    if (partitionStateHolder == null) continue;
                    Iterator<Map.Entry<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>>> iterator = partitionIdSnapshot.getValue().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>> partitionGroupByKeySnapshot = iterator.next();
                        this.restoreIncrementalSnapshot(partitionStateHolder, partitionGroupByKeySnapshot.getValue());
                        iterator.remove();
                    }
                }
            }
            catch (Throwable t) {
                throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " not completed properly because content of Siddhi app has changed since last state persistence. Clean persistence store for a fresh deployment.", t);
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreIncrementalSnapshot(PartitionIdStateHolder partitionIdStateHolder, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>> incrementalStateByTime) {
        if (incrementalStateByTime != null) {
            String id = null;
            State state = null;
            StateHolder stateHolder = null;
            HashMap<String, Object> deserializedStateMap = null;
            try {
                Iterator<Map.Entry<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>> iterator = incrementalStateByTime.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>> incrementalStateByTimeEntry = iterator.next();
                    iterator.remove();
                    Iterator<Map.Entry<Long, Map<IncrementalSnapshotInfo, byte[]>>> partitionGroupByKeyIterator = incrementalStateByTimeEntry.getValue().entrySet().iterator();
                    while (partitionGroupByKeyIterator.hasNext()) {
                        Map.Entry<Long, Map<IncrementalSnapshotInfo, byte[]>> partitionGroupByKeyStateByTimeEntry = partitionGroupByKeyIterator.next();
                        partitionGroupByKeyIterator.remove();
                        Iterator<Map.Entry<IncrementalSnapshotInfo, byte[]>> iterator1 = partitionGroupByKeyStateByTimeEntry.getValue().entrySet().iterator();
                        while (iterator1.hasNext()) {
                            Map.Entry<IncrementalSnapshotInfo, byte[]> incrementalStateByInfoEntry = iterator1.next();
                            iterator1.remove();
                            IncrementalSnapshotInfo incrementalSnapshotInfo = incrementalStateByInfoEntry.getKey();
                            Map singleIncrementSnapshot = (Map)ByteSerializer.byteToObject(incrementalStateByInfoEntry.getValue(), this.siddhiAppContext);
                            if (singleIncrementSnapshot == null) continue;
                            if (!incrementalSnapshotInfo.getId().equals(id)) {
                                ElementStateHolder elementStateHolder;
                                if (id != null) {
                                    state.restore(deserializedStateMap);
                                    SiddhiAppContext.startPartitionFlow(id);
                                    try {
                                        stateHolder.returnState(state);
                                    }
                                    finally {
                                        SiddhiAppContext.stopPartitionFlow();
                                    }
                                    id = null;
                                    state = null;
                                    stateHolder = null;
                                    deserializedStateMap = null;
                                }
                                if ((elementStateHolder = (ElementStateHolder)partitionIdStateHolder.queryStateHolderMap.get(incrementalSnapshotInfo.getQueryName())) == null || (stateHolder = (StateHolder)elementStateHolder.elementHolderMap.get(incrementalSnapshotInfo.getElementId())) == null) continue;
                                String partitionKey = null;
                                String groupByKey = null;
                                String[] keys = incrementalSnapshotInfo.getPartitionGroupByKey().split("--");
                                if (keys.length == 2) {
                                    if (!keys[0].equals("null")) {
                                        partitionKey = keys[0];
                                    }
                                    if (!keys[1].equals("null")) {
                                        groupByKey = keys[1];
                                    }
                                }
                                SiddhiAppContext.startPartitionFlow(partitionKey);
                                SiddhiAppContext.startGroupByFlow(groupByKey);
                                try {
                                    state = stateHolder.getState();
                                }
                                finally {
                                    SiddhiAppContext.stopGroupByFlow();
                                    SiddhiAppContext.stopPartitionFlow();
                                }
                                if (state != null) {
                                    id = incrementalSnapshotInfo.getId();
                                    deserializedStateMap = new HashMap<String, Object>();
                                }
                            }
                            if (state == null) continue;
                            for (Map.Entry singleIncrementSnapshotEntry : singleIncrementSnapshot.entrySet()) {
                                if (singleIncrementSnapshotEntry.getValue() instanceof Snapshot) {
                                    Snapshot snapshot = (Snapshot)singleIncrementSnapshotEntry.getValue();
                                    SnapshotStateList snapshotStateList = (SnapshotStateList)deserializedStateMap.computeIfAbsent((String)singleIncrementSnapshotEntry.getKey(), k -> new SnapshotStateList());
                                    if (snapshot.isIncrementalSnapshot()) {
                                        snapshotStateList.putSnapshotState(partitionGroupByKeyStateByTimeEntry.getKey(), snapshot);
                                        continue;
                                    }
                                    snapshotStateList.getSnapshotStates().clear();
                                    snapshotStateList.putSnapshotState(partitionGroupByKeyStateByTimeEntry.getKey(), snapshot);
                                    continue;
                                }
                                deserializedStateMap.put((String)singleIncrementSnapshotEntry.getKey(), singleIncrementSnapshotEntry.getValue());
                            }
                        }
                    }
                    if (id == null) continue;
                    state.restore(deserializedStateMap);
                    SiddhiAppContext.startPartitionFlow(id);
                    try {
                        stateHolder.returnState(state);
                    }
                    finally {
                        SiddhiAppContext.stopPartitionFlow();
                    }
                    id = null;
                    state = null;
                    stateHolder = null;
                    deserializedStateMap = null;
                }
            }
            finally {
                if (id != null && stateHolder != null && state != null) {
                    SiddhiAppContext.startPartitionFlow(id);
                    try {
                        stateHolder.returnState(state);
                    }
                    finally {
                        SiddhiAppContext.stopPartitionFlow();
                    }
                    id = null;
                    state = null;
                    stateHolder = null;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreRevision(String revision) throws CannotRestoreSiddhiAppStateException {
        IncrementalSnapshotInfo restoreSnapshotInfo;
        List<IncrementalSnapshotInfo> incrementalSnapshotInfos;
        PersistenceStore persistenceStore = this.siddhiAppContext.getSiddhiContext().getPersistenceStore();
        IncrementalPersistenceStore incrementalPersistenceStore = this.siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore();
        String siddhiAppName = this.siddhiAppContext.getName();
        if (persistenceStore != null) {
            byte[] snapshot;
            if (log.isDebugEnabled()) {
                log.debug("Restoring revision: " + revision + " ...");
            }
            if ((snapshot = persistenceStore.load(this.siddhiAppContext.getName(), revision)) != null) {
                this.restore(snapshot);
                if (!log.isDebugEnabled()) return;
                log.debug("Restored revision: " + revision);
                return;
            }
            if (!log.isDebugEnabled()) throw new PersistenceStoreException("No data found for revision: " + revision);
            log.debug("No data found for revision: " + revision);
            throw new PersistenceStoreException("No data found for revision: " + revision);
        }
        if (incrementalPersistenceStore == null) throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + siddhiAppName);
        if (log.isDebugEnabled()) {
            log.debug("Restoring revision: " + revision + " ...");
        }
        if ((incrementalSnapshotInfos = incrementalPersistenceStore.getListOfRevisionsToLoad((restoreSnapshotInfo = PersistenceHelper.convertRevision(revision)).getTime(), restoreSnapshotInfo.getSiddhiAppId())) == null) {
            if (!log.isDebugEnabled()) throw new PersistenceStoreException("No data found for revision: " + revision);
            log.debug("No data found for revision: " + revision);
            throw new PersistenceStoreException("No data found for revision: " + revision);
        }
        incrementalSnapshotInfos.sort(new Comparator<IncrementalSnapshotInfo>(){

            @Override
            public int compare(IncrementalSnapshotInfo o1, IncrementalSnapshotInfo o2) {
                int results = o1.getId().compareTo(o2.getId());
                if (results == 0 && (results = Long.compare(o2.getTime(), o1.getTime())) == 0) {
                    return o2.getType().compareTo(o1.getType());
                }
                return results;
            }
        });
        String lastId = null;
        boolean baseFound = false;
        boolean perioicFound = false;
        Iterator<IncrementalSnapshotInfo> iterator = incrementalSnapshotInfos.iterator();
        while (iterator.hasNext()) {
            IncrementalSnapshotInfo snapshotInfo;
            block13: {
                block11: {
                    block14: {
                        block12: {
                            snapshotInfo = iterator.next();
                            if (!snapshotInfo.getId().equals(lastId)) break block11;
                            if (!baseFound || snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.BASE && snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.INCREMENT) break block12;
                            iterator.remove();
                            break block13;
                        }
                        if (!perioicFound || snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC) break block14;
                        iterator.remove();
                        break block13;
                    }
                    if (snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.BASE) {
                        baseFound = true;
                        break block13;
                    } else if (snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.PERIODIC) {
                        perioicFound = true;
                    }
                    break block13;
                }
                baseFound = snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.BASE;
                perioicFound = snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.PERIODIC;
            }
            lastId = snapshotInfo.getId();
        }
        HashMap<String, Map<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>>> incrementalState = new HashMap<String, Map<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>>>();
        Iterator<IncrementalSnapshotInfo> iterator2 = incrementalSnapshotInfos.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                this.restore(incrementalState);
                if (!log.isDebugEnabled()) return;
                log.debug("Restored revision: " + revision);
                return;
            }
            IncrementalSnapshotInfo snapshotInfo = iterator2.next();
            Map incrementalStateByPartitionGroupByKey = incrementalState.computeIfAbsent(snapshotInfo.getPartitionId(), k -> new TreeMap());
            Map incrementalStateByTime = incrementalStateByPartitionGroupByKey.computeIfAbsent(snapshotInfo.getPartitionGroupByKey(), k -> new TreeMap());
            Map idByTime = incrementalStateByTime.computeIfAbsent(snapshotInfo.getId(), k -> new TreeMap());
            Map incrementalStateByInfo = idByTime.computeIfAbsent(snapshotInfo.getTime(), k -> new HashMap());
            incrementalStateByInfo.put(snapshotInfo, incrementalPersistenceStore.load(snapshotInfo));
        }
    }

    public String restoreLastRevision() throws CannotRestoreSiddhiAppStateException {
        String revision;
        PersistenceStore persistenceStore = this.siddhiAppContext.getSiddhiContext().getPersistenceStore();
        IncrementalPersistenceStore incrementalPersistenceStore = this.siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore();
        String siddhiAppName = this.siddhiAppContext.getName();
        if (persistenceStore != null) {
            revision = persistenceStore.getLastRevision(siddhiAppName);
        } else if (incrementalPersistenceStore != null) {
            revision = incrementalPersistenceStore.getLastRevision(siddhiAppName);
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + siddhiAppName);
        }
        if (revision != null) {
            this.restoreRevision(revision);
        }
        return revision;
    }

    public void clearAllRevisions() throws CannotClearSiddhiAppStateException {
        PersistenceStore persistenceStore = this.siddhiAppContext.getSiddhiContext().getPersistenceStore();
        IncrementalPersistenceStore incrementalPersistenceStore = this.siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore();
        String siddhiAppName = this.siddhiAppContext.getName();
        if (persistenceStore != null) {
            persistenceStore.clearAllRevisions(siddhiAppName);
        } else if (incrementalPersistenceStore != null) {
            incrementalPersistenceStore.clearAllRevisions(siddhiAppName);
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + siddhiAppName);
        }
    }

    private void cleanGroupByStates() {
        for (Map.Entry<String, PartitionIdStateHolder> partitionIdState : this.partitionIdStates.entrySet()) {
            for (Map.Entry queryState : partitionIdState.getValue().queryStateHolderMap.entrySet()) {
                for (Map.Entry elementState : ((ElementStateHolder)queryState.getValue()).elementHolderMap.entrySet()) {
                    ((StateHolder)elementState.getValue()).cleanGroupByStates();
                }
            }
        }
    }

    private void waitForSystemStabilization() {
        int retryCount;
        int activeThreads = this.siddhiAppContext.getThreadBarrier().getActiveThreads();
        for (retryCount = 100; activeThreads != 0 && retryCount > 0; --retryCount) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new SiddhiAppRuntimeException("Stabilization of Siddhi App " + this.siddhiAppContext.getName() + " for snapshot/restore interrupted. " + e.getMessage(), e);
            }
            activeThreads = this.siddhiAppContext.getThreadBarrier().getActiveThreads();
        }
        if (retryCount == 0) {
            throw new SiddhiAppRuntimeException("Siddhi App " + this.siddhiAppContext.getName() + " not stabilized for snapshot/restore, Active thread count is " + activeThreads);
        }
    }

    class ElementStateHolder {
        private final String elementId;
        private final Map<String, StateHolder> elementHolderMap;

        public ElementStateHolder(String elementId, Map<String, StateHolder> elementHolderMap) {
            this.elementId = elementId;
            this.elementHolderMap = elementHolderMap;
        }
    }

    class PartitionIdStateHolder {
        private final String partitionId;
        private final Map<String, ElementStateHolder> queryStateHolderMap = new HashMap<String, ElementStateHolder>();

        public PartitionIdStateHolder(String partitionId) {
            this.partitionId = partitionId;
        }

        public void addElementState(String queryName, ElementStateHolder elementStateHolder) {
            this.queryStateHolderMap.put(queryName, elementStateHolder);
        }

        public ElementStateHolder getElementState(String queryName) {
            return this.queryStateHolderMap.get(queryName);
        }
    }
}

