/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.single;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.ThreadBarrier;
import java.util.List;

public class EntryValveProcessor
implements Processor,
Schedulable {
    private Processor next;
    private ThreadBarrier threadBarrier;

    public EntryValveProcessor(SiddhiAppContext siddhiAppContext) {
        this.threadBarrier = siddhiAppContext.getThreadBarrier();
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        this.threadBarrier.enter();
        try {
            this.next.process(complexEventChunk);
        }
        finally {
            this.threadBarrier.exit();
        }
    }

    @Override
    public void process(List<ComplexEventChunk> complexEventChunks) {
        ComplexEventChunk complexEventChunk = new ComplexEventChunk();
        for (ComplexEventChunk streamEventChunk : complexEventChunks) {
            complexEventChunk.addAll(streamEventChunk);
        }
        this.process(complexEventChunk);
    }

    @Override
    public Processor getNextProcessor() {
        return this.next;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.next = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.next == null) {
            this.next = processor;
        } else {
            this.next.setToLast(processor);
        }
    }
}

