/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiOnDemandQueryContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.SlidingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.compiler.SiddhiCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Extension(name="expression", namespace="", description="A sliding window that dynamically shrink and grow based on the `expression`, it holds events that satisfies the given `expression`, when they aren't, they are evaluated from the `first` (oldest) to the `last` (latest/current) and expired from the oldest until the `expression` is satisfied.\n**Note**: All the events in window are reevaluated only when the given `expression` is changed.", parameters={@Parameter(name="expression", description="The expression to retain events.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"expression"})}, examples={@Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expression('count()<=20')\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="This will retain last 20 events in a sliding manner."), @Example(syntax="@info(name = 'query1')\nfrom StockEventWindow#window.expression(\n       'sum(price) < 100 and eventTimestamp(last) - eventTimestamp(first) < 3000')\nselect symbol, sum(price) as price\ninsert into OutputStream ;", description="This will retain the latest events having their sum(price) < 100, and the `last` and `first` events are within 3 second difference.")})
public class ExpressionWindowProcessor
extends SlidingFindableWindowProcessor<WindowState> {
    private ExpressionExecutor expressionExecutor;
    private List<VariableExpressionExecutor> variableExpressionExecutors;
    private boolean init = false;
    private ExpressionExecutor expressionStringExecutor = null;
    private String expressionString = null;

    @Override
    protected StateFactory init(MetaStreamEvent metaStreamEvent, AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            this.expressionString = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            this.constructExpression(metaStreamEvent, siddhiQueryContext);
        } else {
            for (Attribute attribute : inputDefinition.getAttributeList()) {
                metaStreamEvent.addData(attribute);
            }
            this.expressionStringExecutor = attributeExpressionExecutors[0];
        }
        return () -> new WindowState();
    }

    @Override
    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        if (this.expressionStringExecutor == null && !this.init) {
            MetaStateEvent metaStateEvent = new MetaStateEvent(new MetaStreamEvent[]{this.metaStreamEvent, this.metaStreamEvent, this.metaStreamEvent});
            QueryParserHelper.updateVariablePosition(metaStateEvent, this.variableExpressionExecutors);
            this.init = true;
        }
        WindowState windowState = state;
        synchronized (windowState) {
            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                String expressionStringNew;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (this.expressionStringExecutor != null && !(expressionStringNew = (String)this.expressionStringExecutor.execute(streamEvent)).equals(this.expressionString)) {
                    this.expressionString = expressionStringNew;
                    this.processAllExpiredEvents(streamEventChunk, state, currentTime);
                }
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                this.processStreamEvent(streamEventChunk, state, currentTime, clonedEvent);
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    private MetaStateEvent constructExpression(MetaStreamEvent metaStreamEvent, SiddhiQueryContext siddhiQueryContext) {
        Expression expression = SiddhiCompiler.parseExpression((String)this.expressionString);
        MetaStreamEventWrapper metaStreamEventFirst = new MetaStreamEventWrapper(metaStreamEvent);
        ((MetaStreamEvent)metaStreamEventFirst).setInputReferenceId("first");
        MetaStreamEventWrapper metaStreamEventLast = new MetaStreamEventWrapper(metaStreamEvent);
        ((MetaStreamEvent)metaStreamEventLast).setInputReferenceId("last");
        MetaStateEvent metaStateEvent = new MetaStateEvent(new MetaStreamEvent[]{metaStreamEvent, metaStreamEventFirst, metaStreamEventLast});
        this.variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
        SiddhiOnDemandQueryContext exprQueryContext = new SiddhiOnDemandQueryContext(siddhiQueryContext.getSiddhiAppContext(), siddhiQueryContext.getName(), this.expressionString);
        this.expressionExecutor = ExpressionParser.parseExpression(expression, metaStateEvent, 0, new HashMap<String, Table>(), this.variableExpressionExecutors, false, 0, ProcessingMode.SLIDE, true, exprQueryContext);
        if (this.expressionExecutor.getReturnType() != Attribute.Type.BOOL) {
            throw new SiddhiAppRuntimeException("Expression ('" + this.expressionString + "') does not return Bool");
        }
        return metaStateEvent;
    }

    private void processAllExpiredEvents(ComplexEventChunk<StreamEvent> streamEventChunk, WindowState state, long currentTime) {
        MetaStateEvent metaStateEvent = this.constructExpression(this.metaStreamEvent, this.siddhiQueryContext);
        QueryParserHelper.updateVariablePosition(metaStateEvent, this.variableExpressionExecutors);
        state.expiredEventQueue.clear();
        for (StreamEvent expiredEvent = state.expiredEventQueue.getFirst(); expiredEvent != null; expiredEvent = expiredEvent.getNext()) {
            StreamEvent aExpiredEvent = expiredEvent;
            aExpiredEvent.setNext(null);
            this.processStreamEvent(streamEventChunk, state, currentTime, aExpiredEvent);
        }
        state.expiredEventQueue.reset();
    }

    private void processStreamEvent(ComplexEventChunk<StreamEvent> streamEventChunk, WindowState state, long currentTime, StreamEvent streamEvent) {
        state.expiredEventQueue.add(streamEvent);
        StateEvent stateEventCurrent = new StateEvent(3, 0);
        stateEventCurrent.setEvent(0, streamEvent);
        stateEventCurrent.setEvent(1, state.expiredEventQueue.getFirst());
        stateEventCurrent.setEvent(2, streamEvent);
        if (!((Boolean)this.expressionExecutor.execute(stateEventCurrent)).booleanValue()) {
            state.expiredEventQueue.reset();
            while (state.expiredEventQueue.hasNext()) {
                StreamEvent expiredEvent = state.expiredEventQueue.next();
                state.expiredEventQueue.remove();
                streamEventChunk.insertBeforeCurrent(expiredEvent);
                StateEvent stateEvent = new StateEvent(3, 0);
                stateEvent.setEvent(0, expiredEvent);
                StreamEvent firstEvent = state.expiredEventQueue.getFirst();
                if (firstEvent == null) {
                    firstEvent = expiredEvent;
                }
                stateEvent.setEvent(1, firstEvent);
                stateEvent.setEvent(2, streamEvent);
                stateEvent.setType(ComplexEvent.Type.EXPIRED);
                expiredEvent.setTimestamp(currentTime);
                if (!((Boolean)this.expressionExecutor.execute(stateEvent)).booleanValue()) continue;
                break;
            }
        }
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.expiredEventQueue, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.expiredEventQueue, streamEventCloner);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    class MetaStreamEventWrapper
    extends MetaStreamEvent {
        private MetaStreamEvent metaStreamEvent;
        private String inputReferenceId;

        public MetaStreamEventWrapper(MetaStreamEvent metaStreamEvent) {
            this.metaStreamEvent = metaStreamEvent;
        }

        @Override
        public List<Attribute> getBeforeWindowData() {
            return this.metaStreamEvent.getBeforeWindowData();
        }

        @Override
        public List<Attribute> getOnAfterWindowData() {
            return this.metaStreamEvent.getOnAfterWindowData();
        }

        @Override
        public List<Attribute> getOutputData() {
            return this.metaStreamEvent.getOutputData();
        }

        @Override
        public void initializeOnAfterWindowData() {
            this.metaStreamEvent.initializeOnAfterWindowData();
        }

        @Override
        public void initializeAfterWindowData() {
            this.metaStreamEvent.initializeAfterWindowData();
        }

        @Override
        public int addData(Attribute attribute) {
            return this.metaStreamEvent.addData(attribute);
        }

        @Override
        public void addOutputData(Attribute attribute) {
            this.metaStreamEvent.addOutputData(attribute);
        }

        @Override
        public void addOutputDataAllowingDuplicate(Attribute attribute) {
            this.metaStreamEvent.addOutputDataAllowingDuplicate(attribute);
        }

        @Override
        public List<AbstractDefinition> getInputDefinitions() {
            return this.metaStreamEvent.getInputDefinitions();
        }

        @Override
        public void addInputDefinition(AbstractDefinition inputDefinition) {
            this.metaStreamEvent.addInputDefinition(inputDefinition);
        }

        @Override
        public String getInputReferenceId() {
            return this.inputReferenceId;
        }

        @Override
        public void setInputReferenceId(String inputReferenceId) {
            this.inputReferenceId = inputReferenceId;
        }

        @Override
        public void setOutputDefinition(StreamDefinition streamDefinition) {
            this.metaStreamEvent.setOutputDefinition(streamDefinition);
        }

        @Override
        public StreamDefinition getOutputStreamDefinition() {
            return this.metaStreamEvent.getOutputStreamDefinition();
        }

        @Override
        public MetaStreamEvent.EventType getEventType() {
            return this.metaStreamEvent.getEventType();
        }

        @Override
        public void setEventType(MetaStreamEvent.EventType eventType) {
            this.metaStreamEvent.setEventType(eventType);
        }

        @Override
        public AbstractDefinition getLastInputDefinition() {
            return this.metaStreamEvent.getLastInputDefinition();
        }

        @Override
        public boolean isMultiValue() {
            return this.metaStreamEvent.isMultiValue();
        }

        @Override
        public void setMultiValue(boolean multiValue) {
            this.metaStreamEvent.setMultiValue(multiValue);
        }

        @Override
        public MetaStreamEvent clone() {
            return this.metaStreamEvent.clone();
        }
    }

    class WindowState
    extends State {
        private SnapshotableStreamEventQueue expiredEventQueue;

        WindowState() {
            this.expiredEventQueue = new SnapshotableStreamEventQueue(ExpressionWindowProcessor.this.streamEventClonerHolder);
        }

        @Override
        public boolean canDestroy() {
            return this.expiredEventQueue.getFirst() == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.expiredEventQueue.clear();
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
        }
    }
}

