/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator.incremental;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.expression.Expression;

@Extension(name="distinctCount", namespace="incrementalAggregator", description="Returns the count of all events, in incremental event processing", parameters={@Parameter(name="arg", description="The attribute that needs to be counted.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns the distinct event count as a long.", type={DataType.LONG})}, examples={@Example(syntax=" define aggregation cseEventAggregation\n from cseEventStream\n select distinctCount(symbol) as countEvents,\n aggregate by timeStamp every sec ... hour;", description="distinctCount(symbol) returns the distinct count of all the symbols based on their arrival and expiry. The count is calculated for sec, min and hour durations.")})
public class DistinctCountIncrementalAttributeAggregator
extends IncrementalAttributeAggregator {
    private Attribute[] baseAttributes;
    private Expression[] baseAttributesInitialValues;

    @Override
    public void init(String attributeName, Attribute.Type attributeType) {
        if (!(attributeType.equals((Object)Attribute.Type.FLOAT) || attributeType.equals((Object)Attribute.Type.DOUBLE) || attributeType.equals((Object)Attribute.Type.INT) || attributeType.equals((Object)Attribute.Type.LONG) || attributeType.equals((Object)Attribute.Type.STRING) || attributeType.equals((Object)Attribute.Type.BOOL))) {
            throw new SiddhiAppRuntimeException("Distinct count aggregation cannot be executed on attribute type " + attributeType.toString());
        }
        Attribute set = new Attribute("AGG_SET_".concat(attributeName), Attribute.Type.OBJECT);
        Expression setInitialValue = Expression.function((String)"createSet", (Expression[])new Expression[]{Expression.variable((String)attributeName)});
        this.baseAttributes = new Attribute[]{set};
        this.baseAttributesInitialValues = new Expression[]{setInitialValue};
    }

    @Override
    public Expression aggregate() {
        return Expression.function((String)"sizeOfSet", (Expression[])new Expression[]{Expression.variable((String)this.baseAttributes[0].getName())});
    }

    @Override
    public Attribute[] getBaseAttributes() {
        return this.baseAttributes;
    }

    @Override
    public Expression[] getBaseAttributeInitialValues() {
        return this.baseAttributesInitialValues;
    }

    @Override
    public Expression[] getBaseAggregators() {
        Expression setAggregator = Expression.function((String)"unionSet", (Expression[])new Expression[]{Expression.variable((String)this.getBaseAttributes()[0].getName())});
        return new Expression[]{setAggregator};
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }
}

