/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.operator;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.InMemoryCompiledUpdateSet;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.Operator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class CollectionOperator
implements Operator {
    protected ExpressionExecutor expressionExecutor;
    protected int storeEventPosition;

    public CollectionOperator(ExpressionExecutor expressionExecutor, int storeEventPosition) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventPosition = storeEventPosition;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object storeEvents, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>();
        for (StreamEvent storeEvent : (Collection)storeEvents) {
            matchingEvent.setEvent(this.storeEventPosition, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
            }
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Object storeEvents) {
        try {
            for (StreamEvent storeEvent : (Collection)storeEvents) {
                matchingEvent.setEvent(this.storeEventPosition, storeEvent);
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object storeEvents) {
        if (((Collection)storeEvents).size() > 0) {
            deletingEventChunk.reset();
            while (deletingEventChunk.hasNext()) {
                StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
                try {
                    Iterator iterator = ((Collection)storeEvents).iterator();
                    while (iterator.hasNext()) {
                        StreamEvent storeEvent = (StreamEvent)iterator.next();
                        deletingEvent.setEvent(this.storeEventPosition, storeEvent);
                        if (!((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) continue;
                        iterator.remove();
                    }
                }
                finally {
                    deletingEvent.setEvent(this.storeEventPosition, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet) {
        if (((Collection)storeEvents).size() > 0) {
            updatingEventChunk.reset();
            while (updatingEventChunk.hasNext()) {
                StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
                try {
                    for (StreamEvent storeEvent : (Collection)storeEvents) {
                        updatingEvent.setEvent(this.storeEventPosition, storeEvent);
                        if (!((Boolean)this.expressionExecutor.execute(updatingEvent)).booleanValue()) continue;
                        for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                            storeEvent.setOutputData(entry.getValue().execute(updatingEvent), entry.getKey());
                        }
                    }
                }
                finally {
                    updatingEvent.setEvent(this.storeEventPosition, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> tryUpdate(ComplexEventChunk<StateEvent> updatingOrAddingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        updatingOrAddingEventChunk.reset();
        ComplexEventChunk<StateEvent> failedEventChunk = new ComplexEventChunk<StateEvent>();
        while (updatingOrAddingEventChunk.hasNext()) {
            StateEvent updateOrAddingEvent = (StateEvent)updatingOrAddingEventChunk.next();
            try {
                boolean updated = false;
                if (((Collection)storeEvents).size() > 0) {
                    for (StreamEvent storeEvent : (Collection)storeEvents) {
                        updateOrAddingEvent.setEvent(this.storeEventPosition, storeEvent);
                        if (!((Boolean)this.expressionExecutor.execute(updateOrAddingEvent)).booleanValue()) continue;
                        for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                            storeEvent.setOutputData(entry.getValue().execute(updateOrAddingEvent), entry.getKey());
                        }
                        updated = true;
                    }
                }
                if (updated) continue;
                updatingOrAddingEventChunk.remove();
                failedEventChunk.add(updateOrAddingEvent);
            }
            finally {
                updateOrAddingEvent.setEvent(this.storeEventPosition, null);
            }
        }
        return failedEventChunk;
    }
}

