/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.operator;

import io.siddhi.core.aggregation.Executor;
import io.siddhi.core.aggregation.IncrementalDataAggregator;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.aggregation.OutOfOrderEventsDataAggregator;
import io.siddhi.core.aggregation.persistedaggregation.PersistedIncrementalExecutor;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.populater.ComplexEventPopulater;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IncrementalAggregateCompileCondition
implements CompiledCondition {
    private static final Logger LOG = LogManager.getLogger(IncrementalAggregateCompileCondition.class);
    private final boolean isOnDemandQuery;
    private final String aggregationName;
    private final boolean isProcessingOnExternalTime;
    private final boolean isDistributed;
    private final List<TimePeriod.Duration> activeIncrementalDurations;
    private final StreamEventFactory streamEventFactoryForTableMeta;
    private final StreamEventCloner tableEventCloner;
    private final StreamEventFactory streamEventFactoryForAggregateMeta;
    private final StreamEventCloner aggregateEventCloner;
    private Map<TimePeriod.Duration, Table> aggregationTableMap;
    private List<ExpressionExecutor> outputExpressionExecutors;
    private boolean isOptimisedLookup;
    private Map<TimePeriod.Duration, CompiledSelection> withinTableCompiledSelection;
    private Map<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions;
    private CompiledCondition inMemoryStoreCompileCondition;
    private Map<TimePeriod.Duration, CompiledCondition> withinTableLowerGranularityCompileCondition;
    private CompiledCondition onCompiledCondition;
    private List<Attribute> additionalAttributes;
    private ExpressionExecutor perExpressionExecutor;
    private ExpressionExecutor startTimeEndTimeExpressionExecutor;
    private List<ExpressionExecutor> timestampFilterExecutors;
    private MetaStreamEvent tableMetaStreamEvent;
    private ComplexEventPopulater complexEventPopulater;
    private MatchingMetaInfoHolder alteredMatchingMetaInfoHolder;
    private MatchingMetaInfoHolder matchingHolderInfoForTableLookups;
    private List<VariableExpressionExecutor> variableExpExecutorsForTableLookups;

    public IncrementalAggregateCompileCondition(boolean isOnDemandQuery, String aggregationName, boolean isProcessingOnExternalTime, boolean isDistributed, List<TimePeriod.Duration> activeIncrementalDurations, Map<TimePeriod.Duration, Table> aggregationTableMap, List<ExpressionExecutor> outputExpressionExecutors, boolean isOptimisedLookup, Map<TimePeriod.Duration, CompiledSelection> withinTableCompiledSelection, Map<TimePeriod.Duration, CompiledCondition> withinTableCompiledConditions, CompiledCondition inMemoryStoreCompileCondition, Map<TimePeriod.Duration, CompiledCondition> withinTableLowerGranularityCompileCondition, CompiledCondition onCompiledCondition, List<Attribute> additionalAttributes, ExpressionExecutor perExpressionExecutor, ExpressionExecutor startTimeEndTimeExpressionExecutor, List<ExpressionExecutor> timestampFilterExecutors, MetaStreamEvent aggregateMetaSteamEvent, MatchingMetaInfoHolder alteredMatchingMetaInfoHolder, MatchingMetaInfoHolder matchingHolderInfoForTableLookups, List<VariableExpressionExecutor> variableExpExecutorsForTableLookups) {
        this.isOnDemandQuery = isOnDemandQuery;
        this.aggregationName = aggregationName;
        this.isProcessingOnExternalTime = isProcessingOnExternalTime;
        this.isDistributed = isDistributed;
        this.activeIncrementalDurations = activeIncrementalDurations;
        this.aggregationTableMap = aggregationTableMap;
        this.outputExpressionExecutors = outputExpressionExecutors;
        this.isOptimisedLookup = isOptimisedLookup;
        this.withinTableCompiledSelection = withinTableCompiledSelection;
        this.withinTableCompiledConditions = withinTableCompiledConditions;
        this.inMemoryStoreCompileCondition = inMemoryStoreCompileCondition;
        this.withinTableLowerGranularityCompileCondition = withinTableLowerGranularityCompileCondition;
        this.onCompiledCondition = onCompiledCondition;
        this.additionalAttributes = additionalAttributes;
        this.perExpressionExecutor = perExpressionExecutor;
        this.startTimeEndTimeExpressionExecutor = startTimeEndTimeExpressionExecutor;
        this.timestampFilterExecutors = timestampFilterExecutors;
        this.tableMetaStreamEvent = matchingHolderInfoForTableLookups.getMetaStateEvent().getMetaStreamEvent(1);
        this.streamEventFactoryForTableMeta = new StreamEventFactory(this.tableMetaStreamEvent);
        this.tableEventCloner = new StreamEventCloner(this.tableMetaStreamEvent, this.streamEventFactoryForTableMeta);
        this.streamEventFactoryForAggregateMeta = new StreamEventFactory(aggregateMetaSteamEvent);
        this.aggregateEventCloner = new StreamEventCloner(aggregateMetaSteamEvent, this.streamEventFactoryForAggregateMeta);
        this.alteredMatchingMetaInfoHolder = alteredMatchingMetaInfoHolder;
        this.matchingHolderInfoForTableLookups = matchingHolderInfoForTableLookups;
        this.variableExpExecutorsForTableLookups = variableExpExecutorsForTableLookups;
    }

    public void init() {
        QueryParserHelper.updateVariablePosition(this.matchingHolderInfoForTableLookups.getMetaStateEvent(), this.variableExpExecutorsForTableLookups);
    }

    public StreamEvent find(StateEvent matchingEvent, Map<TimePeriod.Duration, Executor> incrementalExecutorMap, Map<TimePeriod.Duration, List<ExpressionExecutor>> aggregateProcessingExecutorsMap, Map<TimePeriod.Duration, GroupByKeyGenerator> groupByKeyGeneratorMap, ExpressionExecutor shouldUpdateTimestamp, String timeZone) {
        ComplexEventChunk<StreamEvent> processedEvents;
        TimePeriod.Duration perValue;
        Long[] startTimeEndTime;
        ComplexEventChunk<StreamEvent> complexEventChunkToHoldWithinMatches = new ComplexEventChunk<StreamEvent>();
        int additionTimestampAttributesSize = this.timestampFilterExecutors.size() + 2;
        Object[] timestampFilters = new Long[additionTimestampAttributesSize];
        if (matchingEvent.getStreamEvent(0) == null) {
            StreamEvent streamEvent = new StreamEvent(0, additionTimestampAttributesSize, 0);
            matchingEvent.addEvent(0, streamEvent);
        }
        if ((startTimeEndTime = (Long[])this.startTimeEndTimeExpressionExecutor.execute(matchingEvent)) == null) {
            throw new SiddhiAppRuntimeException("Start and end times for within duration cannot be retrieved");
        }
        timestampFilters[0] = startTimeEndTime[0];
        timestampFilters[1] = startTimeEndTime[1];
        if (this.isDistributed) {
            for (int i = 0; i < additionTimestampAttributesSize - 2; ++i) {
                timestampFilters[i + 2] = (Long)this.timestampFilterExecutors.get(i).execute(matchingEvent);
            }
        }
        this.complexEventPopulater.populateComplexEvent(matchingEvent.getStreamEvent(0), timestampFilters);
        String perValueAsString = this.perExpressionExecutor.execute(matchingEvent).toString();
        try {
            perValue = Expression.Time.normalizeDuration((String)perValueAsString);
        }
        catch (SiddhiAppValidationException e) {
            throw new SiddhiAppRuntimeException("Aggregation Query's per value is expected to be of a valid time function of the following " + TimePeriod.Duration.SECONDS + ", " + TimePeriod.Duration.MINUTES + ", " + TimePeriod.Duration.HOURS + ", " + TimePeriod.Duration.DAYS + ", " + TimePeriod.Duration.MONTHS + ", " + TimePeriod.Duration.YEARS + ".");
        }
        if (!incrementalExecutorMap.keySet().contains(perValue)) {
            throw new SiddhiAppRuntimeException("The aggregate values for " + perValue.toString() + " granularity cannot be provided since aggregation definition " + this.aggregationName + " does not contain " + perValue.toString() + " duration");
        }
        Table tableForPerDuration = this.aggregationTableMap.get(perValue);
        StreamEvent withinMatchFromPersistedEvents = this.isOptimisedLookup ? this.query(tableForPerDuration, matchingEvent, this.withinTableCompiledConditions.get(perValue), this.withinTableCompiledSelection.get(perValue), this.tableMetaStreamEvent.getLastInputDefinition().getAttributeList().toArray(new Attribute[0])) : tableForPerDuration.find(matchingEvent, this.withinTableCompiledConditions.get(perValue));
        complexEventChunkToHoldWithinMatches.add(withinMatchFromPersistedEvents);
        long oldestInMemoryEventTimestamp = this.getOldestInMemoryEventTimestamp(incrementalExecutorMap, this.activeIncrementalDurations, perValue);
        if (this.isProcessingOnExternalTime || this.requiresAggregatingInMemoryData(oldestInMemoryEventTimestamp, startTimeEndTime)) {
            if (this.isDistributed) {
                int perValueIndex = this.activeIncrementalDurations.indexOf(perValue);
                if (perValueIndex != 0) {
                    HashMap<TimePeriod.Duration, CompiledCondition> lowerGranularityLookups = new HashMap<TimePeriod.Duration, CompiledCondition>();
                    for (int i = 0; i < perValueIndex; ++i) {
                        TimePeriod.Duration key = this.activeIncrementalDurations.get(i);
                        lowerGranularityLookups.put(key, this.withinTableLowerGranularityCompileCondition.get(key));
                    }
                    List<StreamEvent> eventChunks = lowerGranularityLookups.entrySet().stream().map(entry -> {
                        Table table = this.aggregationTableMap.get(entry.getKey());
                        if (this.isOptimisedLookup) {
                            return this.query(table, matchingEvent, (CompiledCondition)entry.getValue(), this.withinTableCompiledSelection.get(entry.getKey()), this.tableMetaStreamEvent.getLastInputDefinition().getAttributeList().toArray(new Attribute[0]));
                        }
                        return table.find(matchingEvent, (CompiledCondition)entry.getValue());
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    eventChunks.forEach(complexEventChunkToHoldWithinMatches::add);
                }
            } else {
                TimePeriod.Duration rootDuration;
                IncrementalDataAggregator incrementalDataAggregator = new IncrementalDataAggregator(this.activeIncrementalDurations, perValue, oldestInMemoryEventTimestamp, aggregateProcessingExecutorsMap.get(rootDuration), shouldUpdateTimestamp, groupByKeyGeneratorMap.get(rootDuration = this.activeIncrementalDurations.get(0)) != null, this.tableMetaStreamEvent, timeZone);
                ComplexEventChunk<StreamEvent> aggregatedInMemoryEventChunk = incrementalDataAggregator.aggregateInMemoryData(incrementalExecutorMap);
                StreamEvent withinMatchFromInMemory = ((Operator)this.inMemoryStoreCompileCondition).find(matchingEvent, aggregatedInMemoryEventChunk, this.tableEventCloner);
                complexEventChunkToHoldWithinMatches.add(withinMatchFromInMemory);
            }
        }
        if (this.isDistributed || this.isProcessingOnExternalTime) {
            List<ExpressionExecutor> expressionExecutors = aggregateProcessingExecutorsMap.get(perValue);
            GroupByKeyGenerator groupByKeyGenerator = groupByKeyGeneratorMap.get(perValue);
            OutOfOrderEventsDataAggregator outOfOrderEventsDataAggregator = new OutOfOrderEventsDataAggregator(expressionExecutors, shouldUpdateTimestamp, groupByKeyGenerator, this.tableMetaStreamEvent);
            processedEvents = outOfOrderEventsDataAggregator.aggregateData(complexEventChunkToHoldWithinMatches);
        } else {
            processedEvents = complexEventChunkToHoldWithinMatches;
        }
        ComplexEventChunk<StreamEvent> aggregateSelectionComplexEventChunk = this.createAggregateSelectionEventChunk(processedEvents, this.outputExpressionExecutors);
        return ((Operator)this.onCompiledCondition).find(matchingEvent, aggregateSelectionComplexEventChunk, this.aggregateEventCloner);
    }

    private StreamEvent query(Table tableForPerDuration, StateEvent matchingEvent, CompiledCondition compiledCondition, CompiledSelection compiledSelection, Attribute[] outputAttributes) {
        if (tableForPerDuration.getIsConnected()) {
            try {
                return ((QueryableProcessor)((Object)tableForPerDuration)).query(matchingEvent, compiledCondition, compiledSelection, outputAttributes);
            }
            catch (ConnectionUnavailableException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to query table '" + tableForPerDuration.getTableDefinition().getId() + "', as the datasource is unavailable.");
                }
                if (!this.isOnDemandQuery) {
                    tableForPerDuration.setIsConnectedToFalse();
                    tableForPerDuration.connectWithRetry();
                    return this.query(tableForPerDuration, matchingEvent, compiledCondition, compiledSelection, outputAttributes);
                }
                throw new SiddhiAppRuntimeException(e.getMessage(), e);
            }
        }
        if (tableForPerDuration.getIsTryingToConnect()) {
            LOG.warn("Error on '" + this.aggregationName + "' while performing query for event '" + matchingEvent + "', operation busy waiting at Table '" + tableForPerDuration.getTableDefinition().getId() + "' as its trying to reconnect!");
            tableForPerDuration.waitWhileConnect();
            LOG.info("Aggregation '" + this.aggregationName + "' table '" + tableForPerDuration.getTableDefinition().getId() + "' has become available for query for matching event '" + matchingEvent + "'");
            return this.query(tableForPerDuration, matchingEvent, compiledCondition, compiledSelection, outputAttributes);
        }
        tableForPerDuration.connectWithRetry();
        return this.query(tableForPerDuration, matchingEvent, compiledCondition, compiledSelection, outputAttributes);
    }

    private ComplexEventChunk<StreamEvent> createAggregateSelectionEventChunk(ComplexEventChunk<StreamEvent> complexEventChunkToHoldMatches, List<ExpressionExecutor> outputExpressionExecutors) {
        ComplexEventChunk<StreamEvent> aggregateSelectionComplexEventChunk = new ComplexEventChunk<StreamEvent>();
        StreamEvent resetEvent = this.streamEventFactoryForTableMeta.newInstance();
        resetEvent.setType(ComplexEvent.Type.RESET);
        while (complexEventChunkToHoldMatches.hasNext()) {
            StreamEvent streamEvent = (StreamEvent)complexEventChunkToHoldMatches.next();
            StreamEvent newStreamEvent = this.streamEventFactoryForAggregateMeta.newInstance();
            Object[] outputData = new Object[newStreamEvent.getOutputData().length];
            for (int i = 0; i < outputExpressionExecutors.size(); ++i) {
                outputData[i] = outputExpressionExecutors.get(i).execute(streamEvent);
            }
            newStreamEvent.setTimestamp(streamEvent.getTimestamp());
            newStreamEvent.setOutputData(outputData);
            aggregateSelectionComplexEventChunk.add(newStreamEvent);
        }
        for (ExpressionExecutor expressionExecutor : outputExpressionExecutors) {
            expressionExecutor.execute(resetEvent);
        }
        return aggregateSelectionComplexEventChunk;
    }

    private boolean requiresAggregatingInMemoryData(long oldestInMemoryEventTimestamp, Long[] startTimeEndTime) {
        if (oldestInMemoryEventTimestamp == -1L) {
            return false;
        }
        long endTimeForWithin = startTimeEndTime[1];
        return endTimeForWithin > oldestInMemoryEventTimestamp;
    }

    private long getOldestInMemoryEventTimestamp(Map<TimePeriod.Duration, Executor> incrementalExecutorMap, List<TimePeriod.Duration> incrementalDurations, TimePeriod.Duration perValue) {
        for (int i = perValue.ordinal(); i >= incrementalDurations.get(0).ordinal(); --i) {
            TimePeriod.Duration incrementalDuration = TimePeriod.Duration.values()[i];
            if (!incrementalExecutorMap.containsKey(incrementalDuration)) continue;
            if (incrementalExecutorMap.get(incrementalDuration) instanceof PersistedIncrementalExecutor) {
                return -1L;
            }
            long oldestEvent = ((IncrementalExecutor)incrementalExecutorMap.get(incrementalDuration)).getAggregationStartTimestamp();
            if (oldestEvent == -1L) continue;
            return oldestEvent;
        }
        return -1L;
    }

    public void setComplexEventPopulater(ComplexEventPopulater complexEventPopulater) {
        this.complexEventPopulater = complexEventPopulater;
    }

    public List<Attribute> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public MatchingMetaInfoHolder getAlteredMatchingMetaInfoHolder() {
        return this.alteredMatchingMetaInfoHolder;
    }
}

