/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.parser;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.aggregation.Executor;
import io.siddhi.core.aggregation.IncrementalAggregationProcessor;
import io.siddhi.core.aggregation.IncrementalDataPurger;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.aggregation.IncrementalExecutorsInitialiser;
import io.siddhi.core.aggregation.persistedaggregation.CudStreamProcessorQueueManager;
import io.siddhi.core.aggregation.persistedaggregation.PersistedIncrementalExecutor;
import io.siddhi.core.aggregation.persistedaggregation.QueuedCudStreamProcessor;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationQueryConfigurationEntry;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationQueryUtil;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationSelectFunctionTemplate;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationSelectQueryTemplate;
import io.siddhi.core.aggregation.persistedaggregation.config.DBAggregationTimeConversionDurationMapping;
import io.siddhi.core.aggregation.persistedaggregation.config.PersistedAggregationResultsProcessor;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.exception.CannotLoadConfigurationException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.executor.incremental.IncrementalAggregateBaseTimeFunctionExecutor;
import io.siddhi.core.query.input.stream.StreamRuntime;
import io.siddhi.core.query.input.stream.single.EntryValveExecutor;
import io.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.query.selector.GroupByKeyGenerator;
import io.siddhi.core.query.selector.attribute.aggregator.MaxAttributeAggregatorExecutor;
import io.siddhi.core.query.selector.attribute.aggregator.MinAttributeAggregatorExecutor;
import io.siddhi.core.query.selector.attribute.aggregator.SumAttributeAggregatorExecutor;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.SiddhiAppRuntimeBuilder;
import io.siddhi.core.util.SiddhiClassLoader;
import io.siddhi.core.util.config.ConfigManager;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.extension.holder.FunctionExecutorExtensionHolder;
import io.siddhi.core.util.extension.holder.IncrementalAttributeAggregatorExtensionHolder;
import io.siddhi.core.util.extension.holder.StreamProcessorExtensionHolder;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.InputStreamParser;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.AggregationDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.input.handler.StreamFunction;
import io.siddhi.query.api.execution.query.input.handler.StreamHandler;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.execution.query.selection.OutputAttribute;
import io.siddhi.query.api.expression.AttributeFunction;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.constant.StringConstant;
import io.siddhi.query.api.extension.Extension;
import io.siddhi.query.api.util.AnnotationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AggregationParser {
    private static final Logger log = LogManager.getLogger(AggregationParser.class);

    public static AggregationRuntime parse(AggregationDefinition aggregationDefinition, SiddhiAppContext siddhiAppContext, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder) {
        Annotation aggregationProperties;
        String timeZone = AggregationParser.getTimeZone(siddhiAppContext);
        boolean isDebugEnabled = log.isDebugEnabled();
        boolean isPersistedAggregation = false;
        boolean isReadOnly = false;
        if (!AggregationParser.validateTimeZone(timeZone).booleanValue()) {
            throw new SiddhiAppCreationException("Given timeZone '" + timeZone + "' for aggregations is invalid. Please provide a valid time zone.");
        }
        String aggregatorName = aggregationDefinition.getId();
        if (isDebugEnabled) {
            log.debug("Incremental aggregation initialization process started for aggregation " + aggregatorName);
        }
        if ((aggregationProperties = AnnotationHelper.getAnnotation((String)"persistedAggregation", (List)aggregationDefinition.getAnnotations())) != null) {
            String persistedAggregationMode = aggregationProperties.getElement("enable");
            isPersistedAggregation = persistedAggregationMode == null || Boolean.parseBoolean(persistedAggregationMode);
            String readOnlyMode = aggregationProperties.getElement("is.read.only");
            isReadOnly = Boolean.parseBoolean(readOnlyMode);
        }
        if (isPersistedAggregation) {
            aggregationDefinition.getSelector().getSelectionList().stream().forEach(outputAttribute -> {
                if (outputAttribute.getExpression() instanceof AttributeFunction && ((AttributeFunction)outputAttribute.getExpression()).getName().equals("distinctCount")) {
                    throw new SiddhiAppCreationException("Aggregation function 'distinctCount' does not supported with persisted aggregation type please use default incremental aggregation");
                }
            });
        }
        if (isDebugEnabled) {
            log.debug("Aggregation mode is defined as " + (isPersistedAggregation ? "persisted" : "inMemory") + " for aggregation " + aggregatorName);
        }
        if (aggregationDefinition.getTimePeriod() == null) {
            throw new SiddhiAppCreationException("Aggregation Definition '" + aggregationDefinition.getId() + "'s timePeriod is null. Hence, can't create the siddhi app '" + siddhiAppContext.getName() + "'", aggregationDefinition.getQueryContextStartIndex(), aggregationDefinition.getQueryContextEndIndex());
        }
        if (aggregationDefinition.getSelector() == null) {
            throw new SiddhiAppCreationException("Aggregation Definition '" + aggregationDefinition.getId() + "'s selection is not defined. Hence, can't create the siddhi app '" + siddhiAppContext.getName() + "'", aggregationDefinition.getQueryContextStartIndex(), aggregationDefinition.getQueryContextEndIndex());
        }
        if (streamDefinitionMap.get(aggregationDefinition.getBasicSingleInputStream().getStreamId()) == null) {
            throw new SiddhiAppCreationException("Stream " + aggregationDefinition.getBasicSingleInputStream().getStreamId() + " has not been defined");
        }
        Element userDefinedPrimaryKey = AnnotationHelper.getAnnotationElement((String)"PrimaryKey", null, (List)aggregationDefinition.getAnnotations());
        if (userDefinedPrimaryKey != null) {
            throw new SiddhiAppCreationException("Aggregation Tables have predefined primary key, but found '" + userDefinedPrimaryKey.getValue() + "' primary key defined though annotation.");
        }
        try {
            boolean isDistributed;
            ArrayList<VariableExpressionExecutor> incomingVariableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(siddhiAppContext, aggregatorName);
            StreamRuntime streamRuntime = InputStreamParser.parse((InputStream)aggregationDefinition.getBasicSingleInputStream(), null, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, windowMap, aggregationMap, incomingVariableExpressionExecutors, false, siddhiQueryContext);
            MetaStreamEvent incomingMetaStreamEvent = (MetaStreamEvent)streamRuntime.getMetaComplexEvent();
            incomingMetaStreamEvent.initializeOnAfterWindowData();
            List<TimePeriod.Duration> aggregationDurations = AggregationParser.getSortedPeriods(aggregationDefinition.getTimePeriod(), isPersistedAggregation);
            ArrayList<ExpressionExecutor> incomingExpressionExecutors = new ArrayList<ExpressionExecutor>();
            ArrayList<IncrementalAttributeAggregator> incrementalAttributeAggregators = new ArrayList<IncrementalAttributeAggregator>();
            List groupByVariableList = aggregationDefinition.getSelector().getGroupByList();
            ArrayList<Expression> outputExpressions = new ArrayList<Expression>();
            boolean isProcessingOnExternalTime = aggregationDefinition.getAggregateAttribute() != null;
            boolean isGroupBy = aggregationDefinition.getSelector().getGroupByList().size() != 0;
            ConfigManager configManager = siddhiAppContext.getSiddhiContext().getConfigManager();
            String shardId = configManager.extractProperty("shardId");
            boolean enablePartitioning = false;
            Annotation partitionById = AnnotationHelper.getAnnotation((String)"PartitionById", (List)aggregationDefinition.getAnnotations());
            if (partitionById != null) {
                String enableElement = partitionById.getElement("enable");
                enablePartitioning = enableElement == null || Boolean.parseBoolean(enableElement);
            }
            boolean shouldPartitionById = Boolean.parseBoolean(configManager.extractProperty("partitionById"));
            if (enablePartitioning || shouldPartitionById) {
                if (shardId == null) {
                    throw new SiddhiAppCreationException("Configuration 'shardId' not provided for @partitionById annotation");
                }
                isDistributed = true;
            } else {
                isDistributed = false;
            }
            if (isDebugEnabled) {
                log.debug("Distributed aggregation processing is " + (isDistributed ? "enabled" : "disabled") + " in " + aggregatorName + " aggregation ");
            }
            AggregationParser.populateIncomingAggregatorsAndExecutors(aggregationDefinition, siddhiQueryContext, tableMap, incomingVariableExpressionExecutors, incomingMetaStreamEvent, incomingExpressionExecutors, incrementalAttributeAggregators, groupByVariableList, outputExpressions, isProcessingOnExternalTime, isDistributed, shardId);
            boolean isLatestEventColAdded = incomingMetaStreamEvent.getOutputData().get(incomingMetaStreamEvent.getOutputData().size() - 1).getName().equals("AGG_LAST_EVENT_TIMESTAMP");
            int baseAggregatorBeginIndex = incomingMetaStreamEvent.getOutputData().size();
            ArrayList<Expression> finalBaseExpressions = new ArrayList<Expression>();
            boolean isOptimisedLookup = AggregationParser.populateFinalBaseAggregators(tableMap, incomingVariableExpressionExecutors, incomingMetaStreamEvent, incomingExpressionExecutors, incrementalAttributeAggregators, siddhiQueryContext, finalBaseExpressions);
            if (isDebugEnabled) {
                log.debug("Optimised lookup mode is " + (isOptimisedLookup ? "enabled" : "disabled") + " for aggregation " + aggregatorName);
            }
            StreamDefinition incomingOutputStreamDefinition = StreamDefinition.id((String)(aggregatorName + "_intermediate"));
            incomingOutputStreamDefinition.setQueryContextStartIndex(aggregationDefinition.getQueryContextStartIndex());
            incomingOutputStreamDefinition.setQueryContextEndIndex(aggregationDefinition.getQueryContextEndIndex());
            MetaStreamEvent processedMetaStreamEvent = new MetaStreamEvent();
            for (Attribute attribute2 : incomingMetaStreamEvent.getOutputData()) {
                incomingOutputStreamDefinition.attribute(attribute2.getName(), attribute2.getType());
                processedMetaStreamEvent.addOutputData(attribute2);
            }
            incomingMetaStreamEvent.setOutputDefinition(incomingOutputStreamDefinition);
            processedMetaStreamEvent.addInputDefinition((AbstractDefinition)incomingOutputStreamDefinition);
            processedMetaStreamEvent.setOutputDefinition(incomingOutputStreamDefinition);
            ArrayList<VariableExpressionExecutor> processVariableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
            HashMap<TimePeriod.Duration, List<ExpressionExecutor>> processExpressionExecutorsMap = new HashMap<TimePeriod.Duration, List<ExpressionExecutor>>();
            HashMap<TimePeriod.Duration, List<ExpressionExecutor>> processExpressionExecutorsMapForFind = new HashMap<TimePeriod.Duration, List<ExpressionExecutor>>();
            aggregationDurations.forEach(incrementalDuration -> {
                processExpressionExecutorsMap.put((TimePeriod.Duration)incrementalDuration, AggregationParser.constructProcessExpressionExecutors(siddhiQueryContext, tableMap, baseAggregatorBeginIndex, finalBaseExpressions, incomingOutputStreamDefinition, processedMetaStreamEvent, processVariableExpressionExecutors, isProcessingOnExternalTime, incrementalDuration, isDistributed, shardId, isLatestEventColAdded));
                processExpressionExecutorsMapForFind.put((TimePeriod.Duration)incrementalDuration, AggregationParser.constructProcessExpressionExecutors(siddhiQueryContext, tableMap, baseAggregatorBeginIndex, finalBaseExpressions, incomingOutputStreamDefinition, processedMetaStreamEvent, processVariableExpressionExecutors, isProcessingOnExternalTime, incrementalDuration, isDistributed, shardId, isLatestEventColAdded));
            });
            ExpressionExecutor shouldUpdateTimestamp = null;
            if (isLatestEventColAdded) {
                Variable shouldUpdateTimestampExp = new Variable("AGG_LAST_EVENT_TIMESTAMP");
                shouldUpdateTimestamp = ExpressionParser.parseExpression((Expression)shouldUpdateTimestampExp, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            }
            List<ExpressionExecutor> outputExpressionExecutors = outputExpressions.stream().map(expression -> ExpressionParser.parseExpression(expression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, isGroupBy, 0, ProcessingMode.BATCH, false, siddhiQueryContext)).collect(Collectors.toList());
            HashMap<TimePeriod.Duration, GroupByKeyGenerator> groupByKeyGeneratorMap = new HashMap<TimePeriod.Duration, GroupByKeyGenerator>();
            aggregationDurations.forEach(incrementalDuration -> {
                GroupByKeyGenerator groupByKeyGenerator = null;
                if (isProcessingOnExternalTime || isGroupBy) {
                    ArrayList<Expression> groupByExpressionList = new ArrayList<Expression>();
                    if (isProcessingOnExternalTime) {
                        Expression externalTimestampExpression = AttributeFunction.function((String)"incrementalAggregator", (String)"getAggregationStartTime", (Expression[])new Expression[]{new Variable("AGG_EVENT_TIMESTAMP"), new StringConstant(incrementalDuration.name())});
                        groupByExpressionList.add(externalTimestampExpression);
                    }
                    groupByExpressionList.addAll(groupByVariableList.stream().map(groupByVariable -> groupByVariable).collect(Collectors.toList()));
                    groupByKeyGenerator = new GroupByKeyGenerator(groupByExpressionList, processedMetaStreamEvent, -1, tableMap, processVariableExpressionExecutors, siddhiQueryContext);
                }
                groupByKeyGeneratorMap.put((TimePeriod.Duration)incrementalDuration, groupByKeyGenerator);
            });
            HashMap<TimePeriod.Duration, GroupByKeyGenerator> groupByKeyGeneratorMapForReading = new HashMap<TimePeriod.Duration, GroupByKeyGenerator>();
            if (isDistributed && !isProcessingOnExternalTime) {
                aggregationDurations.forEach(incrementalDuration -> {
                    ArrayList<Expression> groupByExpressionList = new ArrayList<Expression>();
                    Expression timestampExpression = AttributeFunction.function((String)"incrementalAggregator", (String)"getAggregationStartTime", (Expression[])new Expression[]{new Variable("AGG_TIMESTAMP"), new StringConstant(incrementalDuration.name())});
                    groupByExpressionList.add(timestampExpression);
                    if (isGroupBy) {
                        groupByExpressionList.addAll(groupByVariableList.stream().map(groupByVariable -> groupByVariable).collect(Collectors.toList()));
                    }
                    GroupByKeyGenerator groupByKeyGenerator = new GroupByKeyGenerator(groupByExpressionList, processedMetaStreamEvent, -1, tableMap, processVariableExpressionExecutors, siddhiQueryContext);
                    groupByKeyGeneratorMapForReading.put((TimePeriod.Duration)incrementalDuration, groupByKeyGenerator);
                });
            } else {
                groupByKeyGeneratorMapForReading.putAll(groupByKeyGeneratorMap);
            }
            EntryValveExecutor entryValveExecutor = new EntryValveExecutor(siddhiAppContext);
            LockWrapper lockWrapper = new LockWrapper(aggregatorName);
            lockWrapper.setLock(new ReentrantLock());
            Scheduler scheduler = SchedulerParser.parse(entryValveExecutor, siddhiQueryContext);
            scheduler.init(lockWrapper, aggregatorName);
            scheduler.setStreamEventFactory(new StreamEventFactory(processedMetaStreamEvent));
            QueryParserHelper.reduceMetaComplexEvent(incomingMetaStreamEvent);
            QueryParserHelper.reduceMetaComplexEvent(processedMetaStreamEvent);
            QueryParserHelper.updateVariablePosition(incomingMetaStreamEvent, incomingVariableExpressionExecutors);
            QueryParserHelper.updateVariablePosition(processedMetaStreamEvent, processVariableExpressionExecutors);
            HashMap<TimePeriod.Duration, Table> aggregationTables = AggregationParser.initDefaultTables(aggregatorName, aggregationDurations, processedMetaStreamEvent.getOutputStreamDefinition(), siddhiAppRuntimeBuilder, aggregationDefinition.getAnnotations(), groupByVariableList, isProcessingOnExternalTime, isDistributed);
            Map<TimePeriod.Duration, Executor> incrementalExecutorMap = AggregationParser.buildIncrementalExecutors(processedMetaStreamEvent, processExpressionExecutorsMap, groupByKeyGeneratorMap, aggregationDurations, aggregationTables, siddhiQueryContext, aggregatorName, shouldUpdateTimestamp, timeZone, isPersistedAggregation, incomingOutputStreamDefinition, isDistributed, shardId, isProcessingOnExternalTime, aggregationDefinition, configManager, groupByVariableList, isReadOnly);
            isOptimisedLookup = isOptimisedLookup && aggregationTables.get(aggregationDurations.get(0)) instanceof QueryableProcessor;
            List<String> groupByVariablesList = groupByVariableList.stream().map(Variable::getAttributeName).collect(Collectors.toList());
            ArrayList<OutputAttribute> defaultSelectorList = new ArrayList();
            if (isOptimisedLookup) {
                defaultSelectorList = incomingOutputStreamDefinition.getAttributeList().stream().map(attribute -> new OutputAttribute(new Variable(attribute.getName()))).collect(Collectors.toList());
            }
            IncrementalDataPurger incrementalDataPurger = new IncrementalDataPurger();
            incrementalDataPurger.init(aggregationDefinition, new StreamEventFactory(processedMetaStreamEvent), aggregationTables, isProcessingOnExternalTime, siddhiQueryContext, aggregationDurations, timeZone, windowMap, aggregationMap);
            IncrementalExecutorsInitialiser incrementalExecutorsInitialiser = new IncrementalExecutorsInitialiser(aggregationDurations, aggregationTables, incrementalExecutorMap, isDistributed, shardId, siddhiAppContext, processedMetaStreamEvent, tableMap, windowMap, aggregationMap, timeZone, isReadOnly, isPersistedAggregation, aggregationDefinition);
            IncrementalExecutor rootIncrementalExecutor = (IncrementalExecutor)incrementalExecutorMap.get(aggregationDurations.get(0));
            rootIncrementalExecutor.setScheduler(scheduler);
            entryValveExecutor.setNextExecutor(rootIncrementalExecutor);
            QueryParserHelper.initStreamRuntime(streamRuntime, incomingMetaStreamEvent, lockWrapper, aggregatorName);
            LatencyTracker latencyTrackerFind = null;
            LatencyTracker latencyTrackerInsert = null;
            ThroughputTracker throughputTrackerFind = null;
            ThroughputTracker throughputTrackerInsert = null;
            if (siddhiAppContext.getStatisticsManager() != null) {
                latencyTrackerFind = QueryParserHelper.createLatencyTracker(siddhiAppContext, aggregationDefinition.getId(), "Aggregations", "find");
                latencyTrackerInsert = QueryParserHelper.createLatencyTracker(siddhiAppContext, aggregationDefinition.getId(), "Aggregations", "insert");
                throughputTrackerFind = QueryParserHelper.createThroughputTracker(siddhiAppContext, aggregationDefinition.getId(), "Aggregations", "find");
                throughputTrackerInsert = QueryParserHelper.createThroughputTracker(siddhiAppContext, aggregationDefinition.getId(), "Aggregations", "insert");
            }
            AggregationRuntime aggregationRuntime = new AggregationRuntime(aggregationDefinition, isProcessingOnExternalTime, isDistributed, aggregationDurations, incrementalExecutorMap, aggregationTables, outputExpressionExecutors, processExpressionExecutorsMapForFind, shouldUpdateTimestamp, groupByKeyGeneratorMapForReading, isOptimisedLookup, defaultSelectorList, groupByVariablesList, isLatestEventColAdded, baseAggregatorBeginIndex, finalBaseExpressions, incrementalDataPurger, incrementalExecutorsInitialiser, (SingleStreamRuntime)streamRuntime, processedMetaStreamEvent, latencyTrackerFind, throughputTrackerFind, timeZone);
            streamRuntime.setCommonProcessor(new IncrementalAggregationProcessor(aggregationRuntime, incomingExpressionExecutors, processedMetaStreamEvent, latencyTrackerInsert, throughputTrackerInsert, siddhiAppContext));
            return aggregationRuntime;
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)aggregationDefinition, siddhiAppContext);
            throw t;
        }
    }

    private static String getTimeZone(SiddhiAppContext siddhiAppContext) {
        String timeZone = siddhiAppContext.getSiddhiContext().getConfigManager().extractProperty("aggTimeZone");
        if (timeZone == null) {
            return "GMT";
        }
        return timeZone;
    }

    private static Boolean validateTimeZone(String timeZone) {
        HashSet<String> timeZoneSet = new HashSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
        return timeZoneSet.contains(timeZone);
    }

    private static Map<TimePeriod.Duration, Executor> buildIncrementalExecutors(MetaStreamEvent processedMetaStreamEvent, Map<TimePeriod.Duration, List<ExpressionExecutor>> processExpressionExecutorsMap, Map<TimePeriod.Duration, GroupByKeyGenerator> groupByKeyGeneratorList, List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables, SiddhiQueryContext siddhiQueryContext, String aggregatorName, ExpressionExecutor shouldUpdateTimestamp, String timeZone, boolean isPersistedAggregation, StreamDefinition incomingOutputStreamDefinition, boolean isDistributed, String shardId, boolean isProcessingOnExternalTime, AggregationDefinition aggregationDefinition, ConfigManager configManager, List<Variable> groupByVariableList, boolean isReadOnly) {
        HashMap<TimePeriod.Duration, Executor> incrementalExecutorMap = new HashMap<TimePeriod.Duration, Executor>();
        Map<Object, Object> cudProcessors = new HashMap();
        Executor root = null;
        if (isPersistedAggregation) {
            if (!isReadOnly) {
                cudProcessors = AggregationParser.initAggregateQueryExecutor(incrementalDurations, processExpressionExecutorsMap, incomingOutputStreamDefinition, isDistributed, shardId, isProcessingOnExternalTime, siddhiQueryContext, aggregationDefinition, configManager, aggregationTables, groupByVariableList);
            }
            CudStreamProcessorQueueManager queueManager = new CudStreamProcessorQueueManager();
            LinkedBlockingQueue<QueuedCudStreamProcessor> cudStreamProcessorQueue = queueManager.initializeAndGetCudStreamProcessorQueue();
            siddhiQueryContext.getSiddhiAppContext().getExecutorService().execute(queueManager);
            for (int i = incrementalDurations.size() - 1; i >= 0; --i) {
                aggregationTables.putIfAbsent(incrementalDurations.get(i), null);
                boolean isRoot = i == 0;
                IncrementalExecutor child = root;
                TimePeriod.Duration duration = incrementalDurations.get(i);
                Executor incrementalExecutor = duration == TimePeriod.Duration.SECONDS || duration == TimePeriod.Duration.MINUTES || duration == TimePeriod.Duration.HOURS ? new IncrementalExecutor(aggregatorName, duration, processExpressionExecutorsMap.get(duration), shouldUpdateTimestamp, groupByKeyGeneratorList.get(duration), isRoot, aggregationTables.get(duration), child, siddhiQueryContext, processedMetaStreamEvent, timeZone, duration.equals((Object)TimePeriod.Duration.HOURS)) : new PersistedIncrementalExecutor(aggregatorName, duration, processExpressionExecutorsMap.get(duration), child, siddhiQueryContext, AggregationParser.generateCUDMetaStreamEvent(isProcessingOnExternalTime), timeZone, (Processor)cudProcessors.get(duration), cudStreamProcessorQueue);
                incrementalExecutorMap.put(duration, incrementalExecutor);
                root = incrementalExecutor;
            }
        } else {
            for (int i = incrementalDurations.size() - 1; i >= 0; --i) {
                boolean isRoot = i == 0;
                IncrementalExecutor child = root;
                TimePeriod.Duration duration = incrementalDurations.get(i);
                IncrementalExecutor incrementalExecutor = new IncrementalExecutor(aggregatorName, duration, processExpressionExecutorsMap.get(duration), shouldUpdateTimestamp, groupByKeyGeneratorList.get(duration), isRoot, aggregationTables.get(duration), child, siddhiQueryContext, processedMetaStreamEvent, timeZone, false);
                incrementalExecutorMap.put(duration, incrementalExecutor);
                root = incrementalExecutor;
            }
        }
        return incrementalExecutorMap;
    }

    private static List<ExpressionExecutor> constructProcessExpressionExecutors(SiddhiQueryContext siddhiQueryContext, Map<String, Table> tableMap, int baseAggregatorBeginIndex, List<Expression> finalBaseExpressions, StreamDefinition incomingOutputStreamDefinition, MetaStreamEvent processedMetaStreamEvent, List<VariableExpressionExecutor> processVariableExpressionExecutors, boolean isProcessingOnExternalTime, TimePeriod.Duration duration, boolean isDistributed, String shardId, boolean isLatestEventColAdded) {
        ArrayList<ExpressionExecutor> processExpressionExecutors = new ArrayList<ExpressionExecutor>();
        List attributeList = incomingOutputStreamDefinition.getAttributeList();
        int i = 1;
        Attribute attribute = (Attribute)attributeList.get(0);
        VariableExpressionExecutor variableExpressionExecutor = (VariableExpressionExecutor)ExpressionParser.parseExpression((Expression)new Variable(attribute.getName()), processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, true, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        processExpressionExecutors.add(variableExpressionExecutor);
        if (isDistributed) {
            StringConstant shardIdExpression = Expression.value((String)shardId);
            ExpressionExecutor shardIdExpressionExecutor = ExpressionParser.parseExpression((Expression)shardIdExpression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, true, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            processExpressionExecutors.add(shardIdExpressionExecutor);
            ++i;
        }
        if (isProcessingOnExternalTime) {
            Expression externalTimestampExpression = AttributeFunction.function((String)"incrementalAggregator", (String)"getAggregationStartTime", (Expression[])new Expression[]{new Variable("AGG_EVENT_TIMESTAMP"), new StringConstant(duration.name())});
            ExpressionExecutor externalTimestampExecutor = ExpressionParser.parseExpression(externalTimestampExpression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, true, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            processExpressionExecutors.add(externalTimestampExecutor);
            ++i;
        }
        if (isLatestEventColAdded) {
            --baseAggregatorBeginIndex;
        }
        while (i < baseAggregatorBeginIndex) {
            attribute = (Attribute)attributeList.get(i);
            variableExpressionExecutor = (VariableExpressionExecutor)ExpressionParser.parseExpression((Expression)new Variable(attribute.getName()), processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, true, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            processExpressionExecutors.add(variableExpressionExecutor);
            ++i;
        }
        if (isLatestEventColAdded) {
            Expression lastTimestampExpression = AttributeFunction.function((String)"max", (Expression[])new Expression[]{new Variable("AGG_LAST_EVENT_TIMESTAMP")});
            ExpressionExecutor latestTimestampExecutor = ExpressionParser.parseExpression(lastTimestampExpression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, true, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            processExpressionExecutors.add(latestTimestampExecutor);
        }
        for (Expression expression : finalBaseExpressions) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, processedMetaStreamEvent, 0, tableMap, processVariableExpressionExecutors, true, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            processExpressionExecutors.add(expressionExecutor);
        }
        return processExpressionExecutors;
    }

    private static boolean populateFinalBaseAggregators(Map<String, Table> tableMap, List<VariableExpressionExecutor> incomingVariableExpressionExecutors, MetaStreamEvent incomingMetaStreamEvent, List<ExpressionExecutor> incomingExpressionExecutors, List<IncrementalAttributeAggregator> incrementalAttributeAggregators, SiddhiQueryContext siddhiQueryContext, List<Expression> finalBaseAggregators) {
        boolean isOptimisedLookup = true;
        ArrayList<Attribute> finalBaseAttributes = new ArrayList<Attribute>();
        for (IncrementalAttributeAggregator incrementalAttributeAggregator : incrementalAttributeAggregators) {
            Attribute[] baseAttributes = incrementalAttributeAggregator.getBaseAttributes();
            Expression[] baseAttributeInitialValues = incrementalAttributeAggregator.getBaseAttributeInitialValues();
            Expression[] baseAggregators = incrementalAttributeAggregator.getBaseAggregators();
            if (baseAggregators.length > 1) {
                isOptimisedLookup = false;
            }
            for (int i = 0; i < baseAttributes.length; ++i) {
                AggregationParser.validateBaseAggregators(incrementalAttributeAggregators, incrementalAttributeAggregator, baseAttributes, baseAttributeInitialValues, baseAggregators, i);
                if (finalBaseAttributes.contains(baseAttributes[i])) continue;
                finalBaseAttributes.add(baseAttributes[i]);
                finalBaseAggregators.add(baseAggregators[i]);
                incomingMetaStreamEvent.addOutputData(baseAttributes[i]);
                incomingExpressionExecutors.add(ExpressionParser.parseExpression(baseAttributeInitialValues[i], incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext));
            }
        }
        return isOptimisedLookup;
    }

    private static void populateIncomingAggregatorsAndExecutors(AggregationDefinition aggregationDefinition, SiddhiQueryContext siddhiQueryContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> incomingVariableExpressionExecutors, MetaStreamEvent incomingMetaStreamEvent, List<ExpressionExecutor> incomingExpressionExecutors, List<IncrementalAttributeAggregator> incrementalAttributeAggregators, List<Variable> groupByVariableList, List<Expression> outputExpressions, boolean isProcessingOnExternalTime, boolean isDistributed, String shardId) {
        boolean isLatestEventAdded = false;
        ExpressionExecutor timestampExecutor = AggregationParser.getTimeStampExecutor(siddhiQueryContext, tableMap, incomingVariableExpressionExecutors, incomingMetaStreamEvent);
        Attribute timestampAttribute = new Attribute("AGG_TIMESTAMP", Attribute.Type.LONG);
        incomingMetaStreamEvent.addOutputData(timestampAttribute);
        incomingExpressionExecutors.add(timestampExecutor);
        if (isDistributed) {
            ConstantExpressionExecutor nodeIdExpExecutor = new ConstantExpressionExecutor(shardId, Attribute.Type.STRING);
            incomingExpressionExecutors.add(nodeIdExpExecutor);
            incomingMetaStreamEvent.addOutputData(new Attribute("SHARD_ID", Attribute.Type.STRING));
        }
        ExpressionExecutor externalTimestampExecutor = null;
        if (isProcessingOnExternalTime) {
            Variable externalTimestampExpression = aggregationDefinition.getAggregateAttribute();
            externalTimestampExecutor = ExpressionParser.parseExpression((Expression)externalTimestampExpression, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            if (externalTimestampExecutor.getReturnType() == Attribute.Type.STRING) {
                Expression expression = AttributeFunction.function((String)"incrementalAggregator", (String)"timestampInMilliseconds", (Expression[])new Expression[]{externalTimestampExpression});
                externalTimestampExecutor = ExpressionParser.parseExpression(expression, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            } else if (externalTimestampExecutor.getReturnType() != Attribute.Type.LONG) {
                throw new SiddhiAppCreationException("Aggregation Definition '" + aggregationDefinition.getId() + "'s timestamp attribute expects long or string, but found " + externalTimestampExecutor.getReturnType() + ". Hence, can't create the siddhi app '" + siddhiQueryContext.getSiddhiAppContext().getName() + "'", externalTimestampExpression.getQueryContextStartIndex(), externalTimestampExpression.getQueryContextEndIndex());
            }
            Iterator<Object> externalTimestampAttribute = new Attribute("AGG_EVENT_TIMESTAMP", Attribute.Type.LONG);
            incomingMetaStreamEvent.addOutputData((Attribute)externalTimestampAttribute);
            incomingExpressionExecutors.add(externalTimestampExecutor);
        }
        AbstractDefinition incomingLastInputStreamDefinition = incomingMetaStreamEvent.getLastInputDefinition();
        for (Variable groupByVariable : groupByVariableList) {
            incomingMetaStreamEvent.addOutputData((Attribute)incomingLastInputStreamDefinition.getAttributeList().get(incomingLastInputStreamDefinition.getAttributePosition(groupByVariable.getAttributeName())));
            incomingExpressionExecutors.add(ExpressionParser.parseExpression((Expression)groupByVariable, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext));
        }
        aggregationDefinition.getAttributeList().add(timestampAttribute);
        if (isProcessingOnExternalTime) {
            outputExpressions.add((Expression)Expression.variable((String)"AGG_EVENT_TIMESTAMP"));
        } else {
            outputExpressions.add((Expression)Expression.variable((String)"AGG_TIMESTAMP"));
        }
        for (OutputAttribute outputAttribute : aggregationDefinition.getSelector().getSelectionList()) {
            Expression expression = outputAttribute.getExpression();
            if (expression instanceof AttributeFunction) {
                IncrementalAttributeAggregator incrementalAggregator = null;
                try {
                    incrementalAggregator = (IncrementalAttributeAggregator)SiddhiClassLoader.loadExtensionImplementation((Extension)new AttributeFunction("incrementalAggregator", ((AttributeFunction)expression).getName(), ((AttributeFunction)expression).getParameters()), IncrementalAttributeAggregatorExtensionHolder.getInstance(siddhiQueryContext.getSiddhiAppContext()));
                }
                catch (SiddhiAppCreationException ex) {
                    try {
                        SiddhiClassLoader.loadExtensionImplementation((Extension)((AttributeFunction)expression), FunctionExecutorExtensionHolder.getInstance(siddhiQueryContext.getSiddhiAppContext()));
                        AggregationParser.processAggregationSelectors(aggregationDefinition, siddhiQueryContext, tableMap, incomingVariableExpressionExecutors, incomingMetaStreamEvent, incomingExpressionExecutors, outputExpressions, outputAttribute, expression);
                    }
                    catch (SiddhiAppCreationException e) {
                        throw new SiddhiAppCreationException("'" + ((AttributeFunction)expression).getName() + "' is neither a incremental attribute aggregator extension or a function extension", expression.getQueryContextStartIndex(), expression.getQueryContextEndIndex());
                    }
                }
                if (incrementalAggregator == null) continue;
                AggregationParser.initIncrementalAttributeAggregator(incomingLastInputStreamDefinition, (AttributeFunction)expression, incrementalAggregator);
                incrementalAttributeAggregators.add(incrementalAggregator);
                aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), incrementalAggregator.getReturnType()));
                outputExpressions.add(incrementalAggregator.aggregate());
                continue;
            }
            if (expression instanceof Variable && groupByVariableList.contains(expression)) {
                Attribute groupByAttribute = null;
                for (Attribute attribute : incomingMetaStreamEvent.getOutputData()) {
                    if (!attribute.getName().equals(((Variable)expression).getAttributeName())) continue;
                    groupByAttribute = attribute;
                    break;
                }
                if (groupByAttribute == null) {
                    throw new SiddhiAppCreationException("Expected GroupBy attribute '" + ((Variable)expression).getAttributeName() + "' not used in aggregation '" + siddhiQueryContext.getName() + "' processing.", expression.getQueryContextStartIndex(), expression.getQueryContextEndIndex());
                }
                aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), groupByAttribute.getType()));
                outputExpressions.add((Expression)Expression.variable((String)groupByAttribute.getName()));
                continue;
            }
            isLatestEventAdded = true;
            AggregationParser.processAggregationSelectors(aggregationDefinition, siddhiQueryContext, tableMap, incomingVariableExpressionExecutors, incomingMetaStreamEvent, incomingExpressionExecutors, outputExpressions, outputAttribute, expression);
        }
        if (isProcessingOnExternalTime && isLatestEventAdded) {
            Attribute lastEventTimeStamp = new Attribute("AGG_LAST_EVENT_TIMESTAMP", Attribute.Type.LONG);
            incomingMetaStreamEvent.addOutputData(lastEventTimeStamp);
            incomingExpressionExecutors.add(externalTimestampExecutor);
        }
    }

    private static void processAggregationSelectors(AggregationDefinition aggregationDefinition, SiddhiQueryContext siddhiQueryContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> incomingVariableExpressionExecutors, MetaStreamEvent incomingMetaStreamEvent, List<ExpressionExecutor> incomingExpressionExecutors, List<Expression> outputExpressions, OutputAttribute outputAttribute, Expression expression) {
        ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, incomingMetaStreamEvent, 0, tableMap, incomingVariableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        incomingExpressionExecutors.add(expressionExecutor);
        incomingMetaStreamEvent.addOutputData(new Attribute(outputAttribute.getRename(), expressionExecutor.getReturnType()));
        aggregationDefinition.getAttributeList().add(new Attribute(outputAttribute.getRename(), expressionExecutor.getReturnType()));
        outputExpressions.add((Expression)Expression.variable((String)outputAttribute.getRename()));
    }

    private static void validateBaseAggregators(List<IncrementalAttributeAggregator> incrementalAttributeAggregators, IncrementalAttributeAggregator incrementalAttributeAggregator, Attribute[] baseAttributes, Expression[] baseAttributeInitialValues, Expression[] baseAggregators, int i) {
        for (int i1 = i; i1 < incrementalAttributeAggregators.size(); ++i1) {
            IncrementalAttributeAggregator otherAttributeAggregator = incrementalAttributeAggregators.get(i1);
            if (otherAttributeAggregator == incrementalAttributeAggregator) continue;
            Attribute[] otherBaseAttributes = otherAttributeAggregator.getBaseAttributes();
            Expression[] otherBaseAttributeInitialValues = otherAttributeAggregator.getBaseAttributeInitialValues();
            Expression[] otherBaseAggregators = otherAttributeAggregator.getBaseAggregators();
            for (int j = 0; j < otherBaseAttributes.length; ++j) {
                if (!baseAttributes[i].equals((Object)otherBaseAttributes[j])) continue;
                if (!baseAttributeInitialValues[i].equals(otherBaseAttributeInitialValues[j])) {
                    throw new SiddhiAppCreationException("BaseAttributes having same name should be defined with same initial values, but baseAttribute '" + baseAttributes[i] + "' is defined in '" + incrementalAttributeAggregator.getClass().getName() + "' and '" + otherAttributeAggregator.getClass().getName() + "' with different initial values.");
                }
                if (baseAggregators[i].equals(otherBaseAggregators[j])) continue;
                throw new SiddhiAppCreationException("BaseAttributes having same name should be defined with same baseAggregators, but baseAttribute '" + baseAttributes[i] + "' is defined in '" + incrementalAttributeAggregator.getClass().getName() + "' and '" + otherAttributeAggregator.getClass().getName() + "' with different baseAggregators.");
            }
        }
    }

    private static void initIncrementalAttributeAggregator(AbstractDefinition lastInputStreamDefinition, AttributeFunction attributeFunction, IncrementalAttributeAggregator incrementalAttributeAggregator) {
        String attributeName = null;
        Attribute.Type attributeType = null;
        if (attributeFunction.getParameters() != null && attributeFunction.getParameters()[0] != null) {
            if (attributeFunction.getParameters().length != 1) {
                throw new SiddhiAppCreationException("Incremental aggregator requires only one parameter. Found " + attributeFunction.getParameters().length, attributeFunction.getQueryContextStartIndex(), attributeFunction.getQueryContextEndIndex());
            }
            if (!(attributeFunction.getParameters()[0] instanceof Variable)) {
                throw new SiddhiAppCreationException("Incremental aggregator expected a variable. However a parameter of type " + attributeFunction.getParameters()[0].getClass().getTypeName() + " was found", attributeFunction.getParameters()[0].getQueryContextStartIndex(), attributeFunction.getParameters()[0].getQueryContextEndIndex());
            }
            attributeName = ((Variable)attributeFunction.getParameters()[0]).getAttributeName();
            attributeType = lastInputStreamDefinition.getAttributeType(attributeName);
        }
        incrementalAttributeAggregator.init(attributeName, attributeType);
        Attribute[] baseAttributes = incrementalAttributeAggregator.getBaseAttributes();
        Expression[] baseAttributeInitialValues = incrementalAttributeAggregator.getBaseAttributeInitialValues();
        Expression[] baseAggregators = incrementalAttributeAggregator.getBaseAggregators();
        if (baseAttributes.length != baseAggregators.length) {
            throw new SiddhiAppCreationException("Number of baseAggregators '" + baseAggregators.length + "' and baseAttributes '" + baseAttributes.length + "' is not equal for '" + attributeFunction + "'", attributeFunction.getQueryContextStartIndex(), attributeFunction.getQueryContextEndIndex());
        }
        if (baseAttributeInitialValues.length != baseAggregators.length) {
            throw new SiddhiAppCreationException("Number of baseAggregators '" + baseAggregators.length + "' and baseAttributeInitialValues '" + baseAttributeInitialValues.length + "' is not equal for '" + attributeFunction + "'", attributeFunction.getQueryContextStartIndex(), attributeFunction.getQueryContextEndIndex());
        }
    }

    private static ExpressionExecutor getTimeStampExecutor(SiddhiQueryContext siddhiQueryContext, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, MetaStreamEvent metaStreamEvent) {
        Expression timestampExpression = AttributeFunction.function((String)"currentTimeMillis", null);
        ExpressionExecutor timestampExecutor = ExpressionParser.parseExpression(timestampExpression, metaStreamEvent, 0, tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        return timestampExecutor;
    }

    private static boolean isRange(TimePeriod timePeriod) {
        return timePeriod.getOperator() == TimePeriod.Operator.RANGE;
    }

    private static List<TimePeriod.Duration> getSortedPeriods(TimePeriod timePeriod, boolean isPersistedAggregation) {
        try {
            List<TimePeriod.Duration> durations = timePeriod.getDurations();
            if (AggregationParser.isRange(timePeriod)) {
                durations = AggregationParser.fillGap((TimePeriod.Duration)durations.get(0), (TimePeriod.Duration)durations.get(1));
            }
            return AggregationParser.sortedDurations(durations, isPersistedAggregation);
        }
        catch (Throwable t) {
            ExceptionUtil.populateQueryContext(t, (SiddhiElement)timePeriod, null);
            throw t;
        }
    }

    private static List<TimePeriod.Duration> sortedDurations(List<TimePeriod.Duration> durations, boolean isPersistedAggregation) {
        List<TimePeriod.Duration> copyDurations = new ArrayList<TimePeriod.Duration>(durations);
        Comparator periodComparator = (firstDuration, secondDuration) -> {
            int secondOrdinal;
            int firstOrdinal = firstDuration.ordinal();
            if (firstOrdinal > (secondOrdinal = secondDuration.ordinal())) {
                return 1;
            }
            if (firstOrdinal < secondOrdinal) {
                return -1;
            }
            return 0;
        };
        copyDurations.sort(periodComparator);
        if (isPersistedAggregation && ((TimePeriod.Duration)copyDurations.get(0)).ordinal() >= 3) {
            copyDurations = AggregationParser.fillGap(TimePeriod.Duration.HOURS, (TimePeriod.Duration)copyDurations.get(copyDurations.size() - 1));
        }
        return copyDurations;
    }

    private static List<TimePeriod.Duration> fillGap(TimePeriod.Duration start, TimePeriod.Duration end) {
        int endIndex;
        TimePeriod.Duration[] durations = TimePeriod.Duration.values();
        List<TimePeriod.Duration> filledDurations = new ArrayList<TimePeriod.Duration>();
        int startIndex = start.ordinal();
        if (startIndex > (endIndex = end.ordinal())) {
            throw new SiddhiAppCreationException("Start time period must be less than end time period for range aggregation calculation");
        }
        if (startIndex == endIndex) {
            filledDurations.add(start);
        } else {
            TimePeriod.Duration[] temp = new TimePeriod.Duration[endIndex - startIndex + 1];
            System.arraycopy(durations, startIndex, temp, 0, endIndex - startIndex + 1);
            filledDurations = Arrays.asList(temp);
        }
        return filledDurations;
    }

    private static HashMap<TimePeriod.Duration, Table> initDefaultTables(String aggregatorName, List<TimePeriod.Duration> aggregationDurations, StreamDefinition streamDefinition, SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder, List<Annotation> annotations, List<Variable> groupByVariableList, boolean isProcessingOnExternalTime, boolean enablePartitioning) {
        HashMap<TimePeriod.Duration, Table> aggregationTableMap = new HashMap<TimePeriod.Duration, Table>();
        Annotation primaryKeyAnnotation = new Annotation("PrimaryKey");
        primaryKeyAnnotation.element(null, "AGG_TIMESTAMP");
        if (enablePartitioning) {
            primaryKeyAnnotation.element(null, "SHARD_ID");
        }
        if (isProcessingOnExternalTime) {
            primaryKeyAnnotation.element(null, "AGG_EVENT_TIMESTAMP");
        }
        for (Variable groupByVariable : groupByVariableList) {
            primaryKeyAnnotation.element(null, groupByVariable.getAttributeName());
        }
        if (streamDefinition.getAttributeList().contains(new Attribute("AGG_LAST_EVENT_TIMESTAMP", Attribute.Type.LONG))) {
            Annotation indexAnnotation = new Annotation("Index");
            indexAnnotation.element(null, "AGG_LAST_EVENT_TIMESTAMP");
            annotations.add(indexAnnotation);
        }
        annotations.add(primaryKeyAnnotation);
        for (TimePeriod.Duration duration : aggregationDurations) {
            String tableId = aggregatorName + "_" + duration.toString();
            TableDefinition tableDefinition = TableDefinition.id((String)tableId);
            for (Attribute attribute : streamDefinition.getAttributeList()) {
                tableDefinition.attribute(attribute.getName(), attribute.getType());
            }
            annotations.forEach(arg_0 -> ((TableDefinition)tableDefinition).annotation(arg_0));
            siddhiAppRuntimeBuilder.defineTable(tableDefinition);
            aggregationTableMap.put(duration, (Table)siddhiAppRuntimeBuilder.getTableMap().get(tableId));
        }
        return aggregationTableMap;
    }

    private static Map<TimePeriod.Duration, Processor> initAggregateQueryExecutor(List<TimePeriod.Duration> aggregationDurations, Map<TimePeriod.Duration, List<ExpressionExecutor>> processExpressionExecutorsMap, StreamDefinition incomingOutputStreamDefinition, boolean isDistributed, String shardID, boolean isProcessingOnExternalTime, SiddhiQueryContext siddhiQueryContext, AggregationDefinition aggregationDefinition, ConfigManager configManager, Map<TimePeriod.Duration, Table> aggregationTables, List<Variable> groupByVariableList) {
        LinkedHashMap<TimePeriod.Duration, Processor> cudProcessors = new LinkedHashMap<TimePeriod.Duration, Processor>();
        String datasourceName = AnnotationHelper.getAnnotationElement((String)"store", (String)"datasource", (List)aggregationDefinition.getAnnotations()).getValue();
        if (datasourceName == null || datasourceName.isEmpty()) {
            throw new SiddhiAppCreationException("Datasource configuration must be provided inorder to use persisted aggregation mode");
        }
        Database databaseType = AggregationParser.getDatabaseType(configManager, datasourceName);
        if (log.isDebugEnabled()) {
            log.debug("Database type " + (Object)((Object)databaseType));
        }
        SiddhiAppContext cudSiddhiAppContext = new SiddhiAppContext();
        SiddhiContext context = new SiddhiContext();
        context.setConfigManager(configManager);
        cudSiddhiAppContext.setSiddhiContext(context);
        StringConstant datasource = new StringConstant(datasourceName);
        ConstantExpressionExecutor datasourceExecutor = new ConstantExpressionExecutor(datasource.getValue(), Attribute.Type.STRING);
        Expression[] streamHandler = isProcessingOnExternalTime ? new Expression[7] : new Expression[5];
        try {
            DBAggregationQueryConfigurationEntry dbAggregationQueryConfigurationEntry = DBAggregationQueryUtil.lookupCurrentQueryConfigurationEntry(databaseType);
            if (log.isDebugEnabled()) {
                log.debug("CUD queries for aggregation " + aggregationDefinition.getId());
            }
            for (int i = aggregationDurations.size() - 1; i > 0; --i) {
                if (aggregationDurations.get(i).ordinal() < 3) continue;
                if (log.isDebugEnabled()) {
                    log.debug(" Initializing cudProcessors for duration " + aggregationDurations.get(i));
                }
                String databaseSelectQuery = AggregationParser.generateDatabaseQuery(processExpressionExecutorsMap.get(aggregationDurations.get(i)), dbAggregationQueryConfigurationEntry, incomingOutputStreamDefinition, isDistributed, shardID, isProcessingOnExternalTime, aggregationTables.get(aggregationDurations.get(i)), aggregationTables.get(aggregationDurations.get(i - 1)), groupByVariableList, aggregationDurations.get(i));
                StringConstant selectQuery = new StringConstant(databaseSelectQuery);
                if (log.isDebugEnabled()) {
                    log.debug(selectQuery);
                }
                ConstantExpressionExecutor selectExecutor = new ConstantExpressionExecutor(selectQuery.getValue(), Attribute.Type.STRING);
                Map<Attribute, int[]> cudInputStreamAttributesMap = AggregationParser.generateCUDInputStreamAttributes(isProcessingOnExternalTime);
                ExpressionExecutor[] cudStreamProcessorInputVariables = isProcessingOnExternalTime ? new ExpressionExecutor[7] : new ExpressionExecutor[5];
                cudStreamProcessorInputVariables[0] = datasourceExecutor;
                cudStreamProcessorInputVariables[1] = selectExecutor;
                streamHandler[0] = datasource;
                streamHandler[1] = selectQuery;
                MetaStreamEvent metaStreamEvent = AggregationParser.generateCUDMetaStreamEvent(isProcessingOnExternalTime);
                StreamDefinition outputStream = new StreamDefinition();
                int j = 0;
                for (Map.Entry<Attribute, int[]> entry : cudInputStreamAttributesMap.entrySet()) {
                    Attribute attribute = entry.getKey();
                    Variable timestampVariable = new Variable(attribute.getName());
                    for (int position : entry.getValue()) {
                        streamHandler[position + 2] = timestampVariable;
                        VariableExpressionExecutor variableExpressionExecutor = new VariableExpressionExecutor(attribute, 0, 0);
                        variableExpressionExecutor.setPosition(new int[]{2, j});
                        cudStreamProcessorInputVariables[position + 2] = variableExpressionExecutor;
                    }
                    outputStream.attribute(attribute.getName(), attribute.getType());
                    ++j;
                }
                StreamFunction cudStreamFunction = new StreamFunction("rdbms", "cud", streamHandler);
                cudProcessors.put(aggregationDurations.get(i), AggregationParser.getCudProcessor((StreamHandler)cudStreamFunction, siddhiQueryContext, metaStreamEvent, cudStreamProcessorInputVariables, aggregationDurations.get(i)));
            }
            return cudProcessors;
        }
        catch (CannotLoadConfigurationException e) {
            throw new SiddhiAppCreationException("Error occurred while initializing the persisted incremental aggregation. Could not load the db quires for database type " + (Object)((Object)databaseType));
        }
    }

    private static MetaStreamEvent generateCUDMetaStreamEvent(boolean isProcessingOnExternalTime) {
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        Map<Attribute, int[]> cudInputStreamAttributesList = AggregationParser.generateCUDInputStreamAttributes(isProcessingOnExternalTime);
        StreamDefinition inputDefinition = new StreamDefinition();
        for (Attribute attribute : cudInputStreamAttributesList.keySet()) {
            metaStreamEvent.addData(attribute);
            inputDefinition.attribute(attribute.getName(), attribute.getType());
        }
        metaStreamEvent.addInputDefinition((AbstractDefinition)inputDefinition);
        metaStreamEvent.setEventType(MetaStreamEvent.EventType.DEFAULT);
        return metaStreamEvent;
    }

    private static String generateDatabaseQuery(List<ExpressionExecutor> expressionExecutors, DBAggregationQueryConfigurationEntry dbAggregationQueryConfigurationEntry, StreamDefinition incomingOutputStreamDefinition, boolean isDistributed, String shardID, boolean isProcessingOnExternalTime, Table aggregationTable, Table parentAggregationTable, List<Variable> groupByVariableList, TimePeriod.Duration duration) {
        DBAggregationSelectFunctionTemplate dbAggregationSelectFunctionTemplates = dbAggregationQueryConfigurationEntry.getRdbmsSelectFunctionTemplate();
        DBAggregationSelectQueryTemplate dbAggregationSelectQueryTemplate = dbAggregationQueryConfigurationEntry.getRdbmsSelectQueryTemplate();
        DBAggregationTimeConversionDurationMapping dbAggregationTimeConversionDurationMapping = dbAggregationQueryConfigurationEntry.getDbAggregationTimeConversionDurationMapping();
        List attributeList = incomingOutputStreamDefinition.getAttributeList();
        ArrayList groupByColumnNames = new ArrayList();
        StringJoiner outerSelectColumnJoiner = new StringJoiner(", ");
        StringJoiner subSelectT1ColumnJoiner = new StringJoiner(", ", " SELECT ", " ");
        StringJoiner subSelectT2ColumnJoiner = new StringJoiner(", ");
        StringJoiner innerSelectT2ColumnJoiner = new StringJoiner(", ", " SELECT ", " ");
        StringJoiner onConditionBuilder = new StringJoiner(" AND ");
        StringJoiner subSelectT2OnConditionBuilder = new StringJoiner(" AND ");
        StringJoiner groupByQueryBuilder = new StringJoiner(", ");
        StringJoiner groupByT3QueryBuilder = new StringJoiner(", ");
        StringJoiner finalSelectQuery = new StringJoiner(" ");
        StringJoiner completeQuery = new StringJoiner(" ");
        StringJoiner insertIntoColumns = new StringJoiner(", ");
        StringBuilder filterQueryBuilder = new StringBuilder();
        StringBuilder insertIntoQueryBuilder = new StringBuilder();
        String innerFromClause = " FROM " + parentAggregationTable.getTableDefinition().getId();
        StringJoiner innerT2Query = new StringJoiner(" ");
        StringJoiner subQueryT1 = new StringJoiner(" ");
        StringJoiner subQueryT2 = new StringJoiner(" ");
        attributeList.stream().forEach(attribute -> insertIntoColumns.add(attribute.getName()));
        int i = 0;
        insertIntoQueryBuilder.append(dbAggregationSelectQueryTemplate.getRecordInsertQuery().replace("{{TABLE_NAME}}", aggregationTable.getTableDefinition().getId()).replace("{{COLUMNS}}", insertIntoColumns.toString()));
        filterQueryBuilder.append(" (").append("AGG_TIMESTAMP").append(" >= ?").append(" AND ").append("AGG_TIMESTAMP").append(" < ? ").append(") ");
        if (isDistributed) {
            filterQueryBuilder.append(" AND ").append("SHARD_ID").append(" = '").append(shardID).append("' ");
            groupByQueryBuilder.add("SHARD_ID");
            groupByT3QueryBuilder.add("t3.SHARD_ID");
            innerSelectT2ColumnJoiner.add("SHARD_ID");
            subSelectT2OnConditionBuilder.add(parentAggregationTable.getTableDefinition().getId() + "." + "SHARD_ID" + " = " + "t3" + "." + "SHARD_ID");
            if (isProcessingOnExternalTime) {
                subSelectT1ColumnJoiner.add("SHARD_ID");
            }
        }
        if (isProcessingOnExternalTime) {
            groupByVariableList.stream().forEach(variable -> {
                groupByColumnNames.add(variable.getAttributeName());
                groupByQueryBuilder.add(variable.getAttributeName());
                groupByT3QueryBuilder.add("t3." + variable.getAttributeName());
                onConditionBuilder.add("t1." + variable.getAttributeName() + " = " + "t2" + "." + variable.getAttributeName());
                subSelectT2OnConditionBuilder.add(parentAggregationTable.getTableDefinition().getId() + "." + variable.getAttributeName() + " = " + "t3" + "." + variable.getAttributeName());
            });
            String innerT2WhereCondition = "t3." + groupByVariableList.get(0).getAttributeName() + " IS NOT NULL ";
            for (ExpressionExecutor expressionExecutor : expressionExecutors) {
                if (expressionExecutor instanceof VariableExpressionExecutor) {
                    VariableExpressionExecutor variableExpressionExecutor = (VariableExpressionExecutor)expressionExecutor;
                    if (variableExpressionExecutor.getAttribute().getName().equals("AGG_TIMESTAMP")) {
                        outerSelectColumnJoiner.add(" ?  AS " + variableExpressionExecutor.getAttribute().getName());
                    } else if (!variableExpressionExecutor.getAttribute().getName().equals("AGG_EVENT_TIMESTAMP")) {
                        if (groupByColumnNames.contains(variableExpressionExecutor.getAttribute().getName())) {
                            subSelectT2ColumnJoiner.add("t3." + variableExpressionExecutor.getAttribute().getName() + " AS " + variableExpressionExecutor.getAttribute().getName());
                            outerSelectColumnJoiner.add("t1." + variableExpressionExecutor.getAttribute().getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                            subSelectT1ColumnJoiner.add(variableExpressionExecutor.getAttribute().getName());
                            innerSelectT2ColumnJoiner.add(variableExpressionExecutor.getAttribute().getName());
                        } else {
                            subSelectT2ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMaxFunction().replace("{{COLUMN}}", variableExpressionExecutor.getAttribute().getName()) + " AS " + variableExpressionExecutor.getAttribute().getName());
                            outerSelectColumnJoiner.add("t2." + variableExpressionExecutor.getAttribute().getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                        }
                    }
                } else if (expressionExecutor instanceof IncrementalAggregateBaseTimeFunctionExecutor) {
                    if (((Attribute)attributeList.get(i)).getName().equals("AGG_EVENT_TIMESTAMP")) {
                        outerSelectColumnJoiner.add("t1.AGG_EVENT_TIMESTAMP AS AGG_EVENT_TIMESTAMP");
                        subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getTimeConversionFunction().replace("{{COLUMN}}", "AGG_EVENT_TIMESTAMP").replace("{{DURATION}}", dbAggregationTimeConversionDurationMapping.getDurationMapping(duration)) + " AS " + "AGG_EVENT_TIMESTAMP");
                        subSelectT2ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getTimeConversionFunction().replace("{{COLUMN}}", "AGG_EVENT_TIMESTAMP").replace("{{DURATION}}", dbAggregationTimeConversionDurationMapping.getDurationMapping(duration)) + " AS " + "AGG_EVENT_TIMESTAMP");
                        onConditionBuilder.add("t1.AGG_EVENT_TIMESTAMP = t2.AGG_EVENT_TIMESTAMP");
                    } else {
                        outerSelectColumnJoiner.add(" ?  AS " + ((Attribute)attributeList.get(i)).getName());
                    }
                } else if (expressionExecutor instanceof MaxAttributeAggregatorExecutor) {
                    if (((Attribute)attributeList.get(i)).getName().equals("AGG_LAST_EVENT_TIMESTAMP")) {
                        innerSelectT2ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMaxFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()) + " AS " + ((Attribute)attributeList.get(i)).getName());
                        subSelectT2ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMaxFunction().replace("{{COLUMN}}", "t3." + ((Attribute)attributeList.get(i)).getName()) + " AS " + ((Attribute)attributeList.get(i)).getName());
                        outerSelectColumnJoiner.add("t2." + ((Attribute)attributeList.get(i)).getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                        subSelectT2OnConditionBuilder.add(parentAggregationTable.getTableDefinition().getId() + "." + ((Attribute)attributeList.get(i)).getName() + " = " + "t3" + "." + ((Attribute)attributeList.get(i)).getName());
                    } else {
                        outerSelectColumnJoiner.add("t1." + ((Attribute)attributeList.get(i)).getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                        subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMaxFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()) + " AS " + ((Attribute)attributeList.get(i)).getName());
                    }
                } else if (expressionExecutor instanceof MinAttributeAggregatorExecutor) {
                    outerSelectColumnJoiner.add("t1." + ((Attribute)attributeList.get(i)).getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                    subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMinFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()) + " AS " + ((Attribute)attributeList.get(i)).getName());
                } else if (expressionExecutor instanceof ConstantExpressionExecutor) {
                    outerSelectColumnJoiner.add("t1." + ((Attribute)attributeList.get(i)).getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                } else if (expressionExecutor instanceof SumAttributeAggregatorExecutor) {
                    outerSelectColumnJoiner.add("t1." + ((Attribute)attributeList.get(i)).getName() + " AS " + ((Attribute)attributeList.get(i)).getName());
                    subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getSumFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()) + " AS " + ((Attribute)attributeList.get(i)).getName());
                }
                ++i;
            }
            groupByQueryBuilder.add(dbAggregationSelectFunctionTemplates.getTimeConversionFunction().replace("{{COLUMN}}", "AGG_EVENT_TIMESTAMP").replace("{{DURATION}}", dbAggregationTimeConversionDurationMapping.getDurationMapping(duration)));
            groupByT3QueryBuilder.add(dbAggregationSelectFunctionTemplates.getTimeConversionFunction().replace("{{COLUMN}}", "AGG_EVENT_TIMESTAMP").replace("{{DURATION}}", dbAggregationTimeConversionDurationMapping.getDurationMapping(duration)));
            String groupByClause = dbAggregationSelectQueryTemplate.getGroupByClause().replace("{{COLUMNS}}", groupByQueryBuilder.toString());
            String innerWhereFilterClause = dbAggregationSelectQueryTemplate.getWhereClause().replace("{{CONDITION}}", filterQueryBuilder.toString());
            innerT2Query.add(innerSelectT2ColumnJoiner.toString()).add(innerFromClause).add(innerWhereFilterClause).add(groupByClause);
            subQueryT1.add(subSelectT1ColumnJoiner.toString()).add(innerFromClause).add(innerWhereFilterClause).add(groupByClause);
            subQueryT2.add(dbAggregationSelectQueryTemplate.getSelectQueryWithInnerSelect().replace("{{SELECTORS}}", subSelectT2ColumnJoiner.toString()).replace("{{TABLE_NAME}}", parentAggregationTable.getTableDefinition().getId()).replace("{{INNER_QUERY_2}}", innerT2Query.toString()).replace("{{ON_CONDITION}}", subSelectT2OnConditionBuilder.toString()).replace("{{CONDITION}}", innerT2WhereCondition).replace("{{COLUMNS}}", groupByT3QueryBuilder.toString()));
            finalSelectQuery.add(dbAggregationSelectQueryTemplate.getJoinClause().replace("{{SELECTORS}}", outerSelectColumnJoiner.toString()).replace("{{FROM_CONDITION}}", subQueryT1.toString()).replace("{{INNER_QUERY_1}}", subQueryT2.toString()).replace("{{CONDITION}}", onConditionBuilder.toString()));
            completeQuery.add(insertIntoQueryBuilder.toString()).add(finalSelectQuery.toString());
        } else {
            for (ExpressionExecutor executor : expressionExecutors) {
                if (executor instanceof VariableExpressionExecutor) {
                    VariableExpressionExecutor variableExpressionExecutor = (VariableExpressionExecutor)executor;
                    if (variableExpressionExecutor.getAttribute().getName().equals("AGG_TIMESTAMP")) {
                        subSelectT1ColumnJoiner.add("?  AS " + variableExpressionExecutor.getAttribute().getName());
                    } else {
                        subSelectT1ColumnJoiner.add(variableExpressionExecutor.getAttribute().getName());
                        groupByQueryBuilder.add(variableExpressionExecutor.getAttribute().getName());
                    }
                } else if (executor instanceof ConstantExpressionExecutor) {
                    if (((ConstantExpressionExecutor)executor).getValue() != null) {
                        subSelectT1ColumnJoiner.add("'" + ((ConstantExpressionExecutor)executor).getValue() + "' " + " AS " + ((Attribute)attributeList.get(i)).getName());
                    } else {
                        subSelectT1ColumnJoiner.add(((Attribute)attributeList.get(i)).getName());
                    }
                } else if (executor instanceof SumAttributeAggregatorExecutor) {
                    subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getSumFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()).concat(" AS ").concat(((Attribute)attributeList.get(i)).getName()));
                } else if (executor instanceof MinAttributeAggregatorExecutor) {
                    subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMinFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()).concat(" AS ").concat(((Attribute)attributeList.get(i)).getName()));
                } else if (executor instanceof MaxAttributeAggregatorExecutor) {
                    subSelectT1ColumnJoiner.add(dbAggregationSelectFunctionTemplates.getMaxFunction().replace("{{COLUMN}}", ((Attribute)attributeList.get(i)).getName()).concat(" AS ").concat(((Attribute)attributeList.get(i)).getName()));
                }
                ++i;
            }
            completeQuery.add(insertIntoQueryBuilder.toString()).add(subSelectT1ColumnJoiner.toString()).add(innerFromClause).add(" WHERE " + filterQueryBuilder).add(dbAggregationSelectQueryTemplate.getGroupByClause().replace("{{COLUMNS}}", groupByQueryBuilder.toString()));
        }
        return completeQuery.toString();
    }

    private static Map<Attribute, int[]> generateCUDInputStreamAttributes(boolean isProcessingOnExternalTime) {
        LinkedHashMap<Attribute, int[]> cudInputStreamAttributeList = new LinkedHashMap<Attribute, int[]>();
        if (isProcessingOnExternalTime) {
            cudInputStreamAttributeList.put(new Attribute("FROM_TIMESTAMP", Attribute.Type.LONG), new int[]{0, 1, 3});
            cudInputStreamAttributeList.put(new Attribute("TO_TIMESTAMP", Attribute.Type.LONG), new int[]{2, 4});
        } else {
            cudInputStreamAttributeList.put(new Attribute("FROM_TIMESTAMP", Attribute.Type.LONG), new int[]{0, 1});
            cudInputStreamAttributeList.put(new Attribute("TO_TIMESTAMP", Attribute.Type.LONG), new int[]{2});
        }
        return cudInputStreamAttributeList;
    }

    private static Database getDatabaseType(ConfigManager configManager, String datasourceName) {
        ConfigReader configReader = configManager.generateConfigReader("wso2.datasources", datasourceName);
        String databaseType = configReader.readConfig("driverClassName", "null").toLowerCase();
        if (databaseType.contains("mysql")) {
            return Database.MYSQL;
        }
        if (databaseType.contains("oracle")) {
            return Database.ORACLE;
        }
        if (databaseType.contains("mssql") || databaseType.contains("sqlserver")) {
            return Database.MSSQL;
        }
        if (databaseType.contains("postgres")) {
            return Database.PostgreSQL;
        }
        log.warn("Provided database type " + databaseType + "is not recognized as a supported database type for persisted incremental aggregation, using MySQL as default ");
        return Database.MYSQL;
    }

    public static StreamEvent createRestEvent(MetaStreamEvent metaStreamEvent, StreamEvent streamEvent) {
        streamEvent.setTimestamp(0L);
        streamEvent.setType(ComplexEvent.Type.RESET);
        List<Attribute> outputData = metaStreamEvent.getOutputData();
        int outputDataSize = outputData.size();
        block9: for (int i = 0; i < outputDataSize; ++i) {
            Attribute attribute = outputData.get(i);
            switch (attribute.getType()) {
                case STRING: {
                    streamEvent.setOutputData("", i);
                    continue block9;
                }
                case INT: {
                    streamEvent.setOutputData(0, i);
                    continue block9;
                }
                case LONG: {
                    streamEvent.setOutputData(0L, i);
                    continue block9;
                }
                case FLOAT: {
                    streamEvent.setOutputData(Float.valueOf(0.0f), i);
                    continue block9;
                }
                case DOUBLE: {
                    streamEvent.setOutputData(0.0, i);
                    continue block9;
                }
                case BOOL: {
                    streamEvent.setOutputData(false, i);
                    continue block9;
                }
                case OBJECT: {
                    streamEvent.setOutputData(null, i);
                }
            }
        }
        return streamEvent;
    }

    private static Processor getCudProcessor(StreamHandler streamHandler, SiddhiQueryContext siddhiQueryContext, MetaStreamEvent metaStreamEvent, ExpressionExecutor[] attributeExpressionExecutors, TimePeriod.Duration duration) {
        ConfigReader configReader = siddhiQueryContext.getSiddhiContext().getConfigManager().generateConfigReader(((StreamFunction)streamHandler).getNamespace(), ((StreamFunction)streamHandler).getName());
        StreamProcessor abstractStreamProcessor = (StreamProcessor)SiddhiClassLoader.loadExtensionImplementation((Extension)streamHandler, StreamProcessorExtensionHolder.getInstance(siddhiQueryContext.getSiddhiAppContext()));
        abstractStreamProcessor.initProcessor(metaStreamEvent, attributeExpressionExecutors, configReader, false, false, false, (SiddhiElement)streamHandler, siddhiQueryContext);
        if (metaStreamEvent.getInputDefinitions().size() == 2) {
            AbstractDefinition outputDefinition = metaStreamEvent.getInputDefinitions().get(1);
            List outputAttributes = outputDefinition.getAttributeList();
            for (Attribute attribute : outputAttributes) {
                metaStreamEvent.addOutputData(attribute);
            }
            metaStreamEvent.setOutputDefinition((StreamDefinition)outputDefinition);
        }
        abstractStreamProcessor.constructStreamEventPopulater(metaStreamEvent, 0);
        abstractStreamProcessor.setNextProcessor(new PersistedAggregationResultsProcessor(duration));
        return abstractStreamProcessor;
    }

    public static enum Database {
        MYSQL,
        ORACLE,
        MSSQL,
        DB2,
        PostgreSQL,
        H2,
        DEFAULT;

    }
}

