/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.doc.gen.extensions;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ExtensionDocCache {
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_LAST_MODIFIED_DATETIME = "lastModifiedDateTime";
    private final JSONObject cache;
    private final JSONObject memento;
    private final Path cachePath;
    private boolean inMemory = false;

    public ExtensionDocCache(Path cachePath) {
        JSONObject cache;
        try {
            JSONTokener tokener = new JSONTokener(cachePath.toUri().toURL().openStream());
            cache = new JSONObject(tokener);
            if (cache.length() == 0) {
                this.inMemory = true;
            }
        }
        catch (IOException e) {
            this.inMemory = true;
            cache = new JSONObject();
        }
        this.cache = cache;
        this.cachePath = cachePath;
        this.memento = new JSONObject(cache.toString());
    }

    public boolean has(String extension) {
        return this.cache.has(extension);
    }

    public void add(String extension, String description, String lastModifiedDateTime) {
        JSONObject values = this.cache.has(extension) ? this.cache.getJSONObject(extension) : new JSONObject();
        values.put(KEY_DESCRIPTION, (Object)description);
        values.put(KEY_LAST_MODIFIED_DATETIME, (Object)lastModifiedDateTime);
        this.cache.put(extension, (Object)values);
    }

    public String getLastModifiedDateTime(String extension) {
        if (this.cache.has(extension)) {
            JSONObject values = this.cache.getJSONObject(extension);
            return values.getString(KEY_LAST_MODIFIED_DATETIME);
        }
        return null;
    }

    public void remove(String extension) {
        this.cache.remove(extension);
    }

    public void removeComplementOf(Set<String> extensions) {
        this.cache.keySet().removeIf(e -> !extensions.contains(e));
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public boolean commit() {
        if (this.cache.equals(this.memento)) {
            return false;
        }
        try (PrintWriter writer = new PrintWriter(this.cachePath.toString(), StandardCharsets.UTF_8.toString());){
            writer.println(this.cache.toString(2));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Map<String, String> getExtensionDescriptionMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Set extensions = this.cache.keySet();
        for (String extension : extensions) {
            JSONObject values = this.cache.getJSONObject(extension);
            map.put(extension, values.getString(KEY_DESCRIPTION));
        }
        return map;
    }
}

