/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.doc.gen.extensions;

import io.siddhi.doc.gen.extensions.ExtensionDocCache;
import io.siddhi.doc.gen.extensions.githubclient.ContentsBodyReader;
import io.siddhi.doc.gen.extensions.githubclient.GithubContentsClient;
import io.siddhi.doc.gen.extensions.githubclient.HtmlContentsResponse;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class ExtensionDocRetriever {
    private static final Log log = new SystemStreamLog();
    private final String baseGithubId;
    private final List<String> extensions;
    private final ExtensionDocCache cache;
    private boolean throttled = false;

    public ExtensionDocRetriever(String baseGithubId, List<String> extensions, ExtensionDocCache cache) {
        this.baseGithubId = baseGithubId;
        this.extensions = extensions;
        this.cache = cache;
    }

    public boolean pull() {
        try {
            for (String extension : this.extensions) {
                HtmlContentsResponse response;
                GithubContentsClient githubClient = new GithubContentsClient.Builder(this.baseGithubId, extension).isReadme(true).build();
                if (this.cache.has(extension)) {
                    githubClient.setHeader("If-Modified-Since", this.cache.getLastModifiedDateTime(extension));
                }
                if ((response = githubClient.getContentsResponse(HtmlContentsResponse.class)).getStatus() == 403) {
                    this.throttled = true;
                    break;
                }
                this.updateCache(extension, response);
            }
            this.cache.removeComplementOf(new TreeSet<String>(this.extensions));
            if (!this.throttled) {
                this.cache.commit();
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            return false;
        }
        return true;
    }

    private void updateCache(String extension, HtmlContentsResponse response) throws IOException {
        int status = response.getStatus();
        switch (status) {
            case 200: {
                ContentsBodyReader reader = response.getContentsBodyReader();
                String firstParagraph = reader.getFirstParagraph();
                if (firstParagraph == null) {
                    return;
                }
                this.cache.add(extension, firstParagraph, response.getHeader("Last-Modified").get(0));
                break;
            }
            case 304: {
                break;
            }
            case 404: {
                this.cache.remove(extension);
                break;
            }
            default: {
                log.error((CharSequence)String.format("Error occurred while retrieving the extension '%s': %d %s", extension, status, response.getError().toString()));
            }
        }
    }

    public boolean isThrottled() {
        return this.throttled;
    }
}

