/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.doc.gen.extensions.githubclient;

import io.siddhi.doc.gen.extensions.githubclient.ContentsResponse;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class GithubContentsClient {
    private static final String API_DOMAIN = "api.github.com";
    private final HttpsURLConnection connection;

    private GithubContentsClient(Builder builder) throws IOException {
        StringBuilder urlBuilder = new StringBuilder().append("https://").append(API_DOMAIN).append("/repos").append("/").append(builder.owner).append("/").append(builder.repos);
        if (builder.isReadme) {
            urlBuilder.append("/readme");
        } else {
            urlBuilder.append("/contents").append(builder.path);
        }
        String queryParams = builder.queryParamsBuilder.toString();
        if (!queryParams.isEmpty()) {
            urlBuilder.append("?").append(queryParams);
        }
        URL url = new URL(urlBuilder.toString());
        this.connection = (HttpsURLConnection)url.openConnection();
    }

    public void setHeader(String key, String val) {
        this.connection.setRequestProperty(key, val);
    }

    public <T extends ContentsResponse> T getContentsResponse(Class<T> tClass) throws ReflectiveOperationException {
        Constructor<T> constructor = tClass.getDeclaredConstructor(HttpsURLConnection.class);
        constructor.setAccessible(true);
        return (T)((ContentsResponse)constructor.newInstance(this.connection));
    }

    public static class Builder {
        private final String owner;
        private final String repos;
        private final StringBuilder queryParamsBuilder;
        private boolean isReadme = false;
        private String path = "/";

        public Builder(String owner, String repos) {
            this.owner = owner;
            this.repos = repos;
            this.queryParamsBuilder = new StringBuilder();
        }

        public Builder isReadme(boolean isReadme) {
            this.isReadme = isReadme;
            return this;
        }

        public Builder path(String path) {
            if (!path.isEmpty() && path.charAt(0) != '/') {
                path = "/" + path;
            }
            this.path = path;
            return this;
        }

        public Builder queryParam(String key, String val) {
            if (this.queryParamsBuilder.length() != 0) {
                this.queryParamsBuilder.append("&");
            }
            this.queryParamsBuilder.append(key).append("=").append(val);
            return this;
        }

        public GithubContentsClient build() throws IOException {
            return new GithubContentsClient(this);
        }
    }
}

