/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api.execution.partition;

import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.partition.PartitionType;
import io.siddhi.query.api.expression.Expression;
import java.util.Arrays;

public class RangePartitionType
implements PartitionType {
    private static final long serialVersionUID = 1L;
    private final String streamId;
    private final RangePartitionProperty[] rangePartitionProperties;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public RangePartitionType(String streamId, RangePartitionProperty[] rangePartitionProperties) {
        this.streamId = streamId;
        this.rangePartitionProperties = Arrays.copyOfRange(rangePartitionProperties, 0, rangePartitionProperties.length);
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    public RangePartitionProperty[] getRangePartitionProperties() {
        return Arrays.copyOfRange(this.rangePartitionProperties, 0, this.rangePartitionProperties.length);
    }

    public String toString() {
        return "RangePartitionType{id='" + this.streamId + '\'' + ", rangePartitionProperties=" + Arrays.toString(this.rangePartitionProperties) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangePartitionType)) {
            return false;
        }
        RangePartitionType that = (RangePartitionType)o;
        if (!Arrays.equals(this.rangePartitionProperties, that.rangePartitionProperties)) {
            return false;
        }
        return !(this.streamId != null ? !this.streamId.equals(that.streamId) : that.streamId != null);
    }

    public int hashCode() {
        int result = this.streamId != null ? this.streamId.hashCode() : 0;
        result = 31 * result + (this.rangePartitionProperties != null ? Arrays.hashCode(this.rangePartitionProperties) : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }

    public static class RangePartitionProperty
    implements SiddhiElement {
        private static final long serialVersionUID = 1L;
        private final String partitionKey;
        private final Expression condition;
        private int[] queryContextStartIndex;
        private int[] queryContextEndIndex;

        public RangePartitionProperty(String partitionKey, Expression condition) {
            this.partitionKey = partitionKey;
            this.condition = condition;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public String toString() {
            return "RangePartitionProperty{partitionKey='" + this.partitionKey + '\'' + ", condition=" + this.condition + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RangePartitionProperty that = (RangePartitionProperty)o;
            if (!this.condition.equals(that.condition)) {
                return false;
            }
            return this.partitionKey.equals(that.partitionKey);
        }

        public int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + this.condition.hashCode();
            return result;
        }

        @Override
        public int[] getQueryContextStartIndex() {
            return this.queryContextStartIndex;
        }

        @Override
        public void setQueryContextStartIndex(int[] lineAndColumn) {
            this.queryContextStartIndex = lineAndColumn;
        }

        @Override
        public int[] getQueryContextEndIndex() {
            return this.queryContextEndIndex;
        }

        @Override
        public void setQueryContextEndIndex(int[] lineAndColumn) {
            this.queryContextEndIndex = lineAndColumn;
        }
    }
}

