/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api.execution.query;

import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.output.stream.DeleteStream;
import io.siddhi.query.api.execution.query.output.stream.OutputStream;
import io.siddhi.query.api.execution.query.output.stream.ReturnStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateOrInsertStream;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.execution.query.output.stream.UpdateStream;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;

public class StoreQuery
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private InputStore inputStore;
    private Selector selector = new Selector();
    private OutputStream outputStream = new ReturnStream(OutputStream.OutputEventType.CURRENT_EVENTS);
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;
    private StoreQueryType type;

    public static StoreQuery query() {
        return new StoreQuery();
    }

    public StoreQuery from(InputStore inputStore) {
        this.inputStore = inputStore;
        return this;
    }

    public InputStore getInputStore() {
        return this.inputStore;
    }

    public StoreQuery select(Selector selector) {
        this.selector = selector;
        return this;
    }

    public StoreQuery outStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        if (outputStream != null && outputStream.getOutputEventType() == null) {
            outputStream.setOutputEventType(OutputStream.OutputEventType.CURRENT_EVENTS);
        }
        return this;
    }

    public void deleteBy(String outputTableId, Expression onDeletingExpression) {
        this.outputStream = new DeleteStream(outputTableId, OutputStream.OutputEventType.CURRENT_EVENTS, onDeletingExpression);
    }

    public void updateBy(String outputTableId, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, OutputStream.OutputEventType.CURRENT_EVENTS, onUpdateExpression);
    }

    public void updateBy(String outputTableId, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateStream(outputTableId, OutputStream.OutputEventType.CURRENT_EVENTS, updateSetAttributes, onUpdateExpression);
    }

    public void updateOrInsertBy(String outputTableId, UpdateSet updateSetAttributes, Expression onUpdateExpression) {
        this.outputStream = new UpdateOrInsertStream(outputTableId, OutputStream.OutputEventType.CURRENT_EVENTS, updateSetAttributes, onUpdateExpression);
    }

    public Selector getSelector() {
        return this.selector;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String toString() {
        return "StoreQuery{inputStore=" + this.inputStore + ", selector=" + this.selector + ", outputStream=" + this.outputStream + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreQuery that = (StoreQuery)o;
        if (this.inputStore != null ? !this.inputStore.equals(that.inputStore) : that.inputStore != null) {
            return false;
        }
        if (this.outputStream != null ? !this.outputStream.equals(that.outputStream) : that.outputStream != null) {
            return false;
        }
        return this.selector != null ? this.selector.equals(that.selector) : that.selector == null;
    }

    public int hashCode() {
        int result = this.inputStore != null ? this.inputStore.hashCode() : 0;
        result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
        result = 31 * result + (this.outputStream != null ? this.outputStream.hashCode() : 0);
        return result;
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }

    public StoreQueryType getType() {
        return this.type;
    }

    public void setType(StoreQueryType type) {
        this.type = type;
    }

    public static enum StoreQueryType {
        INSERT,
        DELETE,
        UPDATE,
        SELECT,
        UPDATE_OR_INSERT,
        FIND;

    }
}

