/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api.execution.query.input.stream;

import io.siddhi.query.api.execution.query.input.state.CountStateElement;
import io.siddhi.query.api.execution.query.input.state.EveryStateElement;
import io.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import io.siddhi.query.api.execution.query.input.state.NextStateElement;
import io.siddhi.query.api.execution.query.input.state.StateElement;
import io.siddhi.query.api.execution.query.input.state.StreamStateElement;
import io.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import io.siddhi.query.api.execution.query.input.stream.InputStream;
import io.siddhi.query.api.expression.constant.TimeConstant;
import java.util.ArrayList;
import java.util.List;

public class StateInputStream
extends InputStream {
    private static final long serialVersionUID = 1L;
    private Type stateType;
    private StateElement stateElement;
    private List<String> streamIdList;
    private TimeConstant withinTime;

    public StateInputStream(Type stateType, StateElement stateElement, TimeConstant withinTime) {
        this.stateType = stateType;
        this.stateElement = stateElement;
        this.streamIdList = this.collectStreamIds(stateElement, new ArrayList<String>());
        this.withinTime = withinTime;
    }

    public StateElement getStateElement() {
        return this.stateElement;
    }

    public Type getStateType() {
        return this.stateType;
    }

    @Override
    public List<String> getAllStreamIds() {
        return this.streamIdList;
    }

    @Override
    public List<String> getUniqueStreamIds() {
        ArrayList<String> uniqueStreams = new ArrayList<String>();
        for (String aStreamId : this.streamIdList) {
            if (uniqueStreams.contains(aStreamId)) continue;
            uniqueStreams.add(aStreamId);
        }
        return uniqueStreams;
    }

    private List<String> collectStreamIds(StateElement stateElement, List<String> streamIds) {
        if (stateElement instanceof LogicalStateElement) {
            this.collectStreamIds(((LogicalStateElement)stateElement).getStreamStateElement1(), streamIds);
            this.collectStreamIds(((LogicalStateElement)stateElement).getStreamStateElement2(), streamIds);
        } else if (stateElement instanceof CountStateElement) {
            this.collectStreamIds(((CountStateElement)stateElement).getStreamStateElement(), streamIds);
        } else if (stateElement instanceof EveryStateElement) {
            this.collectStreamIds(((EveryStateElement)stateElement).getStateElement(), streamIds);
        } else if (stateElement instanceof NextStateElement) {
            this.collectStreamIds(((NextStateElement)stateElement).getStateElement(), streamIds);
            this.collectStreamIds(((NextStateElement)stateElement).getNextStateElement(), streamIds);
        } else if (stateElement instanceof StreamStateElement) {
            BasicSingleInputStream basicSingleInputStream = ((StreamStateElement)stateElement).getBasicSingleInputStream();
            streamIds.add(basicSingleInputStream.getStreamId());
        }
        return streamIds;
    }

    public int getStreamCount(String streamId) {
        int count = 0;
        for (String aStreamId : this.streamIdList) {
            if (!streamId.equals(aStreamId)) continue;
            ++count;
        }
        return count;
    }

    public TimeConstant getWithinTime() {
        return this.withinTime;
    }

    public String toString() {
        return "StateInputStream{stateType=" + (Object)((Object)this.stateType) + ", stateElement=" + this.stateElement + ", streamIdList=" + this.streamIdList + ", withinTime=" + this.withinTime + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StateInputStream)) {
            return false;
        }
        StateInputStream that = (StateInputStream)o;
        if (this.stateType != that.stateType) {
            return false;
        }
        if (this.stateElement != null ? !this.stateElement.equals(that.stateElement) : that.stateElement != null) {
            return false;
        }
        if (this.streamIdList != null ? !this.streamIdList.equals(that.streamIdList) : that.streamIdList != null) {
            return false;
        }
        return this.withinTime != null ? this.withinTime.equals(that.withinTime) : that.withinTime == null;
    }

    public int hashCode() {
        int result = this.stateType != null ? this.stateType.hashCode() : 0;
        result = 31 * result + (this.stateElement != null ? this.stateElement.hashCode() : 0);
        result = 31 * result + (this.streamIdList != null ? this.streamIdList.hashCode() : 0);
        result = 31 * result + (this.withinTime != null ? this.withinTime.hashCode() : 0);
        return result;
    }

    public static enum Type {
        PATTERN,
        SEQUENCE;

    }
}

