/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api.execution.query.output.ratelimit;

import io.siddhi.query.api.SiddhiElement;
import io.siddhi.query.api.exception.UnsupportedAttributeTypeException;
import io.siddhi.query.api.execution.query.output.ratelimit.EventOutputRate;
import io.siddhi.query.api.execution.query.output.ratelimit.SnapshotOutputRate;
import io.siddhi.query.api.execution.query.output.ratelimit.TimeOutputRate;
import io.siddhi.query.api.expression.constant.Constant;
import io.siddhi.query.api.expression.constant.IntConstant;
import io.siddhi.query.api.expression.constant.LongConstant;
import io.siddhi.query.api.expression.constant.TimeConstant;

public abstract class OutputRate
implements SiddhiElement {
    private static final long serialVersionUID = 1L;
    private int[] queryContextStartIndex;
    private int[] queryContextEndIndex;

    public static EventOutputRate perEvents(Constant events) {
        if (events instanceof LongConstant) {
            return new EventOutputRate(((LongConstant)events).getValue().intValue());
        }
        if (events instanceof IntConstant) {
            return new EventOutputRate(((IntConstant)events).getValue());
        }
        throw new UnsupportedAttributeTypeException("Unsupported output event rate type, output event rate only supports int");
    }

    public static TimeOutputRate perTimePeriod(TimeConstant timeConstant) {
        return new TimeOutputRate(timeConstant.value());
    }

    public static TimeOutputRate perTimePeriod(LongConstant longConstant) {
        return new TimeOutputRate(longConstant.getValue());
    }

    public static SnapshotOutputRate perSnapshot(TimeConstant timeConstant) {
        return new SnapshotOutputRate(timeConstant.value());
    }

    public static SnapshotOutputRate perSnapshot(LongConstant longConstant) {
        return new SnapshotOutputRate(longConstant.getValue());
    }

    @Override
    public int[] getQueryContextStartIndex() {
        return this.queryContextStartIndex;
    }

    @Override
    public void setQueryContextStartIndex(int[] lineAndColumn) {
        this.queryContextStartIndex = lineAndColumn;
    }

    @Override
    public int[] getQueryContextEndIndex() {
        return this.queryContextEndIndex;
    }

    @Override
    public void setQueryContextEndIndex(int[] lineAndColumn) {
        this.queryContextEndIndex = lineAndColumn;
    }

    public static enum Type {
        ALL,
        FIRST,
        LAST,
        SNAPSHOT;

    }
}

