/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.query.api.util;

import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.exception.DuplicateAnnotationException;
import java.util.List;

public class AnnotationHelper {
    public static Annotation getAnnotation(String annotationName, List<Annotation> annotationList) {
        Annotation annotation = null;
        for (Annotation aAnnotation : annotationList) {
            if (!annotationName.equalsIgnoreCase(aAnnotation.getName())) continue;
            if (annotation == null) {
                annotation = aAnnotation;
                continue;
            }
            throw new DuplicateAnnotationException("Annotation @" + annotationName + " is defined twice", aAnnotation.getQueryContextStartIndex(), aAnnotation.getQueryContextEndIndex());
        }
        return annotation;
    }

    public static Element getAnnotationElement(String annotationName, String elementName, List<Annotation> annotationList) {
        Annotation annotation = AnnotationHelper.getAnnotation(annotationName, annotationList);
        if (annotation != null) {
            Element element = null;
            for (Element aElement : annotation.getElements()) {
                if (elementName == null) {
                    if (aElement.getKey() != null) continue;
                    if (element == null) {
                        element = aElement;
                        continue;
                    }
                    throw new DuplicateAnnotationException("Annotation element @" + annotationName + "(...) is defined twice", aElement.getQueryContextStartIndex(), aElement.getQueryContextEndIndex());
                }
                if (!elementName.equalsIgnoreCase(aElement.getKey())) continue;
                if (element == null) {
                    element = aElement;
                    continue;
                }
                throw new DuplicateAnnotationException("Annotation element @" + annotationName + "(" + elementName + "=...) is defined twice", aElement.getQueryContextStartIndex(), aElement.getQueryContextEndIndex());
            }
            return element;
        }
        return null;
    }
}

