/*
 * Copyright (c) 2016, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package io.siddhi.query.api.expression.constant;

import io.siddhi.query.api.expression.Expression;

/**
 * Integer constant {@link Expression}
 */
public class IntConstant extends Expression implements Constant {

    private static final long serialVersionUID = 1L;
    private Integer value;

    public IntConstant(int value) {

        this.value = value;
    }

    public Integer getValue() {

        return value;
    }

    @Override
    public String toString() {

        return "IntConstant{" +
                "value=" + value +
                '}';
    }

    @Override
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        IntConstant that = (IntConstant) o;

        if (value != null ? !value.equals(that.value) : that.value != null) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {

        return value != null ? value.hashCode() : 0;
    }
}
