/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.gson;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.json.gson.GsonNamespaceConext;
import org.apache.axis2.json.gson.factory.JSONType;
import org.apache.axis2.json.gson.factory.JsonObject;
import org.apache.axis2.json.gson.factory.XmlNode;
import org.apache.axis2.json.gson.factory.XmlNodeGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;

public class GsonXMLStreamWriter
implements XMLStreamWriter {
    private static final Log log = LogFactory.getLog(GsonXMLStreamWriter.class);
    private JsonWriter jsonWriter;
    private Queue<JsonObject> queue = new LinkedList<JsonObject>();
    private Stack<JsonObject> stack = new Stack();
    private Stack<JsonObject> miniStack = new Stack();
    private JsonObject flushObject;
    private JsonObject topNestedArrayObj;
    private Stack<JsonObject> processedJsonObjects = new Stack();
    private List<XmlSchema> xmlSchemaList;
    private QName elementQName;
    private XmlNode mainXmlNode;
    private ConfigurationContext configContext;
    private XmlNodeGenerator xmlNodeGenerator;
    private boolean isProcessed;
    private Map<String, String> uriPrefixMap = new HashMap<String, String>();
    private boolean potentialEmpty = false;
    private JsonObject potentialEmptyElement = null;
    private boolean emptyObjectExists = false;

    public GsonXMLStreamWriter(JsonWriter jsonWriter, QName elementQName, List<XmlSchema> xmlSchemaList, ConfigurationContext context) {
        this.processSchemaUpdates(elementQName, xmlSchemaList, context);
        this.jsonWriter = jsonWriter;
        this.elementQName = elementQName;
        this.xmlSchemaList = xmlSchemaList;
        this.configContext = context;
    }

    private void processSchemaUpdates(QName elementQname, List<XmlSchema> xmlSchemaList, ConfigurationContext configContext) {
        block2: {
            block3: {
                Object ob = configContext.getProperty("CurrentXmlSchema");
                if (ob == null) break block3;
                Map schemaMap = (Map)ob;
                if (schemaMap == null) break block2;
                XmlSchema currentXmlSchema = (XmlSchema)schemaMap.get(elementQname);
                for (XmlSchema xmlSchema : xmlSchemaList) {
                    if (!xmlSchema.getTargetNamespace().equals(elementQname.getNamespaceURI())) continue;
                    if (currentXmlSchema == xmlSchema) break block2;
                    schemaMap.put(elementQname, xmlSchema);
                    configContext.setProperty("xmlnodes", null);
                    if (!log.isDebugEnabled()) break block2;
                    log.debug((Object)("Updating message schema. [Current:" + currentXmlSchema + ", New:" + xmlSchema + "]"));
                    break block2;
                }
                break block2;
            }
            HashMap<QName, XmlSchema> schemaMap = new HashMap<QName, XmlSchema>();
            for (XmlSchema xmlSchema : xmlSchemaList) {
                if (!xmlSchema.getTargetNamespace().equals(elementQname.getNamespaceURI())) continue;
                schemaMap.put(elementQname, xmlSchema);
                configContext.setProperty("CurrentXmlSchema", schemaMap);
                break;
            }
        }
    }

    private void process() throws IOException {
        Object ob = this.configContext.getProperty("xmlnodes");
        if (ob != null) {
            Map nodeMap = (Map)ob;
            XmlNode resNode = (XmlNode)nodeMap.get(this.elementQName);
            if (resNode != null) {
                this.xmlNodeGenerator = new XmlNodeGenerator();
                this.queue = this.xmlNodeGenerator.getQueue(resNode);
            } else {
                this.xmlNodeGenerator = new XmlNodeGenerator(this.xmlSchemaList, this.elementQName);
                this.mainXmlNode = this.xmlNodeGenerator.getMainXmlNode();
                this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
                nodeMap.put(this.elementQName, this.mainXmlNode);
                this.configContext.setProperty("xmlnodes", (Object)nodeMap);
            }
        } else {
            HashMap<QName, XmlNode> newNodeMap = new HashMap<QName, XmlNode>();
            this.xmlNodeGenerator = new XmlNodeGenerator(this.xmlSchemaList, this.elementQName);
            this.mainXmlNode = this.xmlNodeGenerator.getMainXmlNode();
            this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
            newNodeMap.put(this.elementQName, this.mainXmlNode);
            this.configContext.setProperty("xmlnodes", newNodeMap);
        }
        this.isProcessed = true;
        this.jsonWriter.beginObject();
    }

    private void writeStartJson(JsonObject jsonObject) throws IOException {
        if (jsonObject.getType() == JSONType.OBJECT) {
            this.jsonWriter.name(jsonObject.getName());
        } else if (jsonObject.getType() == JSONType.ARRAY) {
            this.jsonWriter.name(jsonObject.getName());
            this.jsonWriter.beginArray();
        } else if (jsonObject.getType() == JSONType.NESTED_ARRAY) {
            this.jsonWriter.name(jsonObject.getName());
            this.jsonWriter.beginArray();
            this.jsonWriter.beginObject();
            if (this.topNestedArrayObj == null) {
                this.topNestedArrayObj = jsonObject;
                this.processedJsonObjects.push(jsonObject);
            }
        } else if (jsonObject.getType() == JSONType.NESTED_OBJECT) {
            this.jsonWriter.name(jsonObject.getName());
            this.jsonWriter.beginObject();
        }
    }

    private void writeEndJson(JsonObject endJson) throws IOException {
        if (endJson.getType() != JSONType.OBJECT) {
            if (endJson.getType() == JSONType.ARRAY) {
                this.jsonWriter.endArray();
            } else if (endJson.getType() == JSONType.NESTED_ARRAY) {
                this.jsonWriter.endArray();
            } else if (endJson.getType() == JSONType.NESTED_OBJECT) {
                this.jsonWriter.endObject();
            }
        }
    }

    private JsonObject popStack() {
        if (this.topNestedArrayObj == null || this.stack.peek().getType() == JSONType.NESTED_OBJECT || this.stack.peek().getType() == JSONType.NESTED_ARRAY) {
            return this.stack.pop();
        }
        this.processedJsonObjects.push(this.stack.peek());
        return this.stack.pop();
    }

    private void fillMiniStack(JsonObject nestedJsonObject) {
        while (!this.processedJsonObjects.peek().getName().equals(nestedJsonObject.getName()) || !this.processedJsonObjects.peek().getType().name().equals(nestedJsonObject.getType().name())) {
            this.miniStack.push(this.processedJsonObjects.pop());
        }
        this.processedJsonObjects.pop();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        block29: {
            if (!this.isProcessed) {
                try {
                    this.process();
                }
                catch (IOException e) {
                    throw new XMLStreamException("Error occours while write first begin object ");
                }
            }
            JsonObject stackObj = null;
            try {
                if (this.miniStack.isEmpty()) {
                    if (!this.queue.isEmpty()) {
                        JsonObject queObj = this.queue.peek();
                        if (this.potentialEmpty && this.potentialEmptyElement == queObj) {
                            this.potentialEmpty = false;
                            this.potentialEmptyElement = null;
                        }
                        if (!(queObj.getName().equals(localName) || queObj.getMinOccurs() != 0L || !this.stack.isEmpty() && this.stack.peek().getName().equals(localName))) {
                            while (queObj != null && !queObj.getName().equals(localName)) {
                                this.skipChildElementsFromQueue(queObj);
                                queObj = this.queue.peek();
                            }
                        }
                        if (queObj != null && queObj.getName().equals(localName)) {
                            if (this.flushObject != null) {
                                if (this.topNestedArrayObj != null && this.flushObject.getType() == JSONType.NESTED_ARRAY && this.flushObject.getName().equals(this.topNestedArrayObj.getName())) {
                                    this.topNestedArrayObj = null;
                                    this.processedJsonObjects.clear();
                                }
                                this.popStack();
                                this.writeEndJson(this.flushObject);
                                this.flushObject = null;
                            }
                            if (this.topNestedArrayObj != null && (queObj.getType() == JSONType.NESTED_ARRAY || queObj.getType() == JSONType.NESTED_OBJECT)) {
                                this.processedJsonObjects.push(queObj);
                            }
                            this.writeStartJson(queObj);
                            this.stack.push(this.queue.poll());
                            JsonObject nextObj = this.queue.peek();
                            if (nextObj != null && nextObj.getMinOccurs() == 0L) {
                                this.potentialEmpty = true;
                                this.potentialEmptyElement = nextObj;
                            }
                            break block29;
                        }
                        if (this.stack.isEmpty()) break block29;
                        stackObj = this.stack.peek();
                        if (stackObj.getName().equals(localName)) {
                            if (stackObj.getType() == JSONType.NESTED_ARRAY) {
                                this.fillMiniStack(stackObj);
                                this.jsonWriter.beginObject();
                                this.processedJsonObjects.push(stackObj);
                            }
                            this.flushObject = null;
                            break block29;
                        }
                        throw new XMLStreamException("Invalid Staring element");
                    }
                    if (!this.stack.isEmpty()) {
                        stackObj = this.stack.peek();
                        if (stackObj.getName().equals(localName)) {
                            this.flushObject = null;
                            if (stackObj.getType() == JSONType.NESTED_ARRAY) {
                                this.fillMiniStack(stackObj);
                                this.jsonWriter.beginObject();
                                this.processedJsonObjects.push(stackObj);
                            }
                            break block29;
                        }
                        throw new XMLStreamException("Invalid Staring element");
                    }
                    throw new XMLStreamException("Invalid Starting  element");
                }
                JsonObject queObj = this.miniStack.peek();
                if (queObj.getName().equals(localName)) {
                    if (this.flushObject != null) {
                        this.popStack();
                        this.writeEndJson(this.flushObject);
                        this.flushObject = null;
                    }
                    if (this.topNestedArrayObj != null && (queObj.getType() == JSONType.NESTED_OBJECT || queObj.getType() == JSONType.NESTED_ARRAY)) {
                        this.processedJsonObjects.push(queObj);
                    }
                    this.writeStartJson(queObj);
                    this.stack.push(this.miniStack.pop());
                    break block29;
                }
                if (this.stack.isEmpty()) break block29;
                stackObj = this.stack.peek();
                if (stackObj.getName().equals(localName)) {
                    this.flushObject = null;
                    if (stackObj.getType() == JSONType.NESTED_ARRAY) {
                        this.fillMiniStack(stackObj);
                        this.jsonWriter.beginObject();
                        this.processedJsonObjects.push(stackObj);
                    }
                    break block29;
                }
                if (queObj.getMinOccurs() == 0L) {
                    this.skipChildElementsFromMiniStack(queObj);
                    queObj = this.miniStack.peek();
                    if (queObj.getName().equals(localName)) {
                        if (this.flushObject != null) {
                            this.popStack();
                            this.writeEndJson(this.flushObject);
                            this.flushObject = null;
                        }
                        if (this.topNestedArrayObj != null && (queObj.getType() == JSONType.NESTED_OBJECT || queObj.getType() == JSONType.NESTED_ARRAY)) {
                            this.processedJsonObjects.push(queObj);
                        }
                        this.writeStartJson(queObj);
                        this.stack.push(this.miniStack.pop());
                    }
                    break block29;
                }
                throw new XMLStreamException("Invalid Staring element");
            }
            catch (IOException e) {
                throw new XMLStreamException(" Json Writer throw an error");
            }
        }
    }

    private void skipChildElementsFromQueue(JsonObject parentObject) {
        JsonObject tempObject = this.queue.poll();
        if (this.processedJsonObjects.isEmpty() || !tempObject.equals(this.processedJsonObjects.peek())) {
            this.processedJsonObjects.push(tempObject);
        }
        if (parentObject.getChildObjects() != null && parentObject.getChildObjects().size() > 0) {
            for (String childName : parentObject.getChildObjects()) {
                JsonObject childObject = this.queue.peek();
                if (!childObject.getName().equals(childName) || !childObject.getParentName().equals(parentObject.getName())) continue;
                tempObject = this.queue.poll();
                this.processedJsonObjects.push(tempObject);
                JsonObject tempParentObject = this.queue.peek();
                if (tempParentObject.getChildObjects() != null && tempParentObject.getChildObjects().size() > 0 && tempParentObject.getParentName() != null && tempParentObject.getParentName().equals(childObject.getName())) {
                    this.skipChildElementsFromQueue(tempParentObject);
                    continue;
                }
                if (tempParentObject.getParentName() == null || !tempParentObject.getParentName().equals(childName)) continue;
                this.skipChildElementsFromQueue(childObject);
            }
        }
    }

    private void skipChildElementsFromMiniStack(JsonObject parentObject) {
        JsonObject tempObject = this.miniStack.pop();
        this.processedJsonObjects.push(tempObject);
        if (parentObject.getChildObjects() != null && parentObject.getChildObjects().size() > 0) {
            for (String childName : parentObject.getChildObjects()) {
                JsonObject childObject = this.miniStack.peek();
                if (!childObject.getName().equals(childName) || !childObject.getParentName().equals(parentObject.getName())) continue;
                tempObject = this.miniStack.pop();
                this.processedJsonObjects.push(tempObject);
                JsonObject tempParentObject = this.miniStack.peek();
                if (tempParentObject.getChildObjects() != null && tempParentObject.getChildObjects().size() > 0 && tempParentObject.getParentName() != null && tempParentObject.getParentName().equals(childObject.getName())) {
                    this.skipChildElementsFromMiniStack(tempParentObject);
                    continue;
                }
                if (tempParentObject.getParentName() == null || !tempParentObject.getParentName().equals(childName)) continue;
                this.skipChildElementsFromMiniStack(childObject);
            }
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occours while write first begin object ");
            }
        }
        JsonObject stackObj = null;
        try {
            if (this.potentialEmpty) {
                this.emptyObjectExists = true;
            }
            if (this.flushObject != null) {
                if (this.topNestedArrayObj != null && this.flushObject.getType() == JSONType.NESTED_ARRAY && this.flushObject.equals(this.topNestedArrayObj.getName())) {
                    this.topNestedArrayObj = null;
                    this.processedJsonObjects.clear();
                }
                this.popStack();
                this.writeEndJson(this.flushObject);
                this.flushObject = null;
                this.writeEndElement();
            } else if (this.stack.peek().getType() == JSONType.ARRAY) {
                this.flushObject = this.stack.peek();
            } else if (this.stack.peek().getType() == JSONType.NESTED_ARRAY) {
                this.flushObject = this.stack.peek();
                this.jsonWriter.endObject();
            } else {
                stackObj = this.popStack();
                this.writeEndJson(stackObj);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("Json writer throw an exception");
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occours while write first begin object ");
            }
        }
        if (this.emptyObjectExists) {
            this.queue.clear();
        }
        if (this.queue.isEmpty() && this.stack.isEmpty()) {
            try {
                if (this.flushObject != null) {
                    this.writeEndJson(this.flushObject);
                }
                this.jsonWriter.endObject();
                this.jsonWriter.flush();
                this.jsonWriter.close();
            }
            catch (IOException e) {
                throw new XMLStreamException("JsonWriter threw an exception", e);
            }
        } else {
            throw new XMLStreamException("Invalid xml element");
        }
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.jsonWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occur while closing JsonWriter");
        }
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceURI) && "nil".equals(localName) && "true".equals(value)) {
            try {
                this.jsonWriter.nullValue();
            }
            catch (IOException e) {
                throw new XMLStreamException("Failed to write attribute, 'nullValue'.", e);
            }
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occur while write first begin object ");
            }
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (!this.isProcessed) {
            this.xmlNodeGenerator.getMainXmlNode();
            this.queue = this.xmlNodeGenerator.getQueue(this.mainXmlNode);
            this.isProcessed = true;
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        if (!this.isProcessed) {
            try {
                this.process();
            }
            catch (IOException e) {
                throw new XMLStreamException("Error occur while trying to write first begin object ");
            }
        }
        try {
            JsonObject peek = this.stack.peek();
            String valueType = peek.getValueType();
            if (valueType.equals("string")) {
                this.jsonWriter.value(text);
            } else if (valueType.equals("int") || valueType.equals("integer")) {
                Integer num = new Integer(text);
                this.jsonWriter.value((Number)num);
            } else if (valueType.equals("long")) {
                this.jsonWriter.value((Number)Long.valueOf(text));
            } else if (valueType.equals("double")) {
                this.jsonWriter.value((Number)Double.valueOf(text));
            } else if (valueType.equals("boolean")) {
                this.jsonWriter.value(Boolean.valueOf(text).booleanValue());
            } else {
                this.jsonWriter.value(text);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException("JsonWriter throw an exception");
        }
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.uriPrefixMap.get(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.uriPrefixMap.put(uri, prefix);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new GsonNamespaceConext();
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException("Method is not implemented");
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }
}

