/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.service.Lifecycle;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DependencyManager {
    private static final Log log = LogFactory.getLog(DependencyManager.class);
    public static final String SERVICE_INIT_METHOD = "init";
    public static final String SERVICE_DESTROY_METHOD = "destroy";

    public static void initServiceClass(Object obj, ServiceContext serviceContext) throws AxisFault {
        DependencyManager.initServiceObject(obj, serviceContext);
    }

    public static void initServiceObject(Object obj, ServiceContext serviceContext) throws AxisFault {
        if (obj instanceof Lifecycle) {
            ((Lifecycle)obj).init(serviceContext);
            return;
        }
        Class<?> classToLoad = obj.getClass();
        Method method = null;
        try {
            method = classToLoad.getMethod(SERVICE_INIT_METHOD, ServiceContext.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            try {
                method.invoke(obj, serviceContext);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Exception trying to call init", (Throwable)e);
                throw new AxisFault("Can not access the method ", e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"Exception trying to call init", (Throwable)e);
                throw new AxisFault(" Incorrect arguments ", e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Exception trying to call init", (Throwable)e);
                throw new AxisFault(" problem in invocation the method ", e);
            }
        }
    }

    public static void initService(ServiceGroupContext serviceGroupContext) throws AxisFault {
        AxisServiceGroup serviceGroup = serviceGroupContext.getDescription();
        Iterator<AxisService> serviceItr = serviceGroup.getServices();
        while (serviceItr.hasNext()) {
            AxisService axisService = serviceItr.next();
            ServiceContext serviceContext = serviceGroupContext.getServiceContext(axisService);
            AxisService service = serviceContext.getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            Parameter implInfoParam = service.getParameter("ServiceClass");
            if (implInfoParam == null) continue;
            try {
                AbstractMessageReceiver.ThreadContextDescriptor tc = DependencyManager.setThreadContext(axisService);
                Class implClass = Loader.loadClass(classLoader, ((String)implInfoParam.getValue()).trim());
                Object serviceImpl = DependencyManager.makeNewServiceObject(service);
                serviceContext.setProperty("serviceObject", serviceImpl);
                DependencyManager.initServiceObject(serviceImpl, serviceContext);
                DependencyManager.restoreThreadContext(tc);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
    }

    protected static Object makeNewServiceObject(AxisService service) throws AxisFault {
        Object serviceObject = Utils.createServiceObject(service);
        if (serviceObject == null) {
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        return serviceObject;
    }

    public static void destroyServiceObject(ServiceContext serviceContext) {
        Object obj = serviceContext.getProperty("serviceObject");
        if (obj != null) {
            if (obj instanceof Lifecycle) {
                ((Lifecycle)obj).destroy(serviceContext);
                return;
            }
            Class<?> classToLoad = obj.getClass();
            Method method = null;
            try {
                method = classToLoad.getMethod(SERVICE_DESTROY_METHOD, ServiceContext.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                try {
                    method.invoke(obj, serviceContext);
                }
                catch (IllegalAccessException e) {
                    log.info((Object)"Exception trying to call destroy", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.info((Object)"Exception trying to call destroy", (Throwable)e);
                }
            }
        }
    }

    protected static AbstractMessageReceiver.ThreadContextDescriptor setThreadContext(final AxisService service) {
        ClassLoader contextClassLoader;
        AbstractMessageReceiver.ThreadContextDescriptor tc = new AbstractMessageReceiver.ThreadContextDescriptor();
        tc.oldMessageContext = MessageContext.currentMessageContext.get();
        tc.oldClassLoader = contextClassLoader = DependencyManager.getContextClassLoader_doPriv();
        String serviceTCCL = (String)service.getParameterValue("ServiceTCCL");
        if (serviceTCCL != null) {
            serviceTCCL = serviceTCCL.trim().toLowerCase();
            serviceTCCL = "composite";
            if (serviceTCCL.equals("composite")) {
                final ClassLoader loader = (ClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MultiParentClassLoader(new URL[0], new ClassLoader[]{service.getClassLoader(), contextClassLoader});
                    }
                });
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(loader);
                        return null;
                    }
                });
            } else if (serviceTCCL.equals("service")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(service.getClassLoader());
                        return null;
                    }
                });
            }
        }
        return tc;
    }

    private static ClassLoader getContextClassLoader_doPriv() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected static void restoreThreadContext(final AbstractMessageReceiver.ThreadContextDescriptor tc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(tc.oldClassLoader);
                return null;
            }
        });
        MessageContext.currentMessageContext.set(tc.oldMessageContext);
    }
}

