/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.scheduler;

import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.SchedulerTask;

public class Scheduler {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SchedulerTask schedulerTask, DeploymentIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 2) {
                    this.scheduler.scheduleWithFixedDelay(schedulerTask, 10L, 10L, TimeUnit.SECONDS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulerTask schedulerTask, DeploymentIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                schedulerTask.state = 1;
                this.scheduler.scheduleWithFixedDelay(schedulerTask, 10L, 10L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(SchedulerTask schedulerTask) {
        Object object = schedulerTask.lock;
        synchronized (object) {
            schedulerTask.state = 2;
            this.scheduler.shutdown();
        }
    }

    public class SchedulerTimerTask
    extends TimerTask {
        private DeploymentIterator iterator;
        private SchedulerTask schedulerTask;

        public SchedulerTimerTask(SchedulerTask schedulerTask, DeploymentIterator iterator) {
            this.schedulerTask = schedulerTask;
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.schedulerTask.run();
            Scheduler.this.reschedule(this.schedulerTask, this.iterator);
        }
    }
}

