/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMProcessingInstructionImpl;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationXMLBuilder
implements Builder {
    private static final Log log = LogFactory.getLog(ApplicationXMLBuilder.class);
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public ApplicationXMLBuilder() {
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        SOAPEnvelope soapEnvelope;
        block7: {
            SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
            soapEnvelope = soapFactory.getDefaultEnvelope();
            if (inputStream != null) {
                try {
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
                    int b = pushbackInputStream.read();
                    if (b <= 0) break block7;
                    pushbackInputStream.unread(b);
                    XMLStreamReader xmlReader = "true".equals(messageContext.getProperty("ApplicationXMLBuilder.allowDTD")) || messageContext.getParameter("ApplicationXMLBuilder.allowDTD") != null && "true".equals(messageContext.getParameter("ApplicationXMLBuilder.allowDTD").getValue()) ? this.inputFactory.createXMLStreamReader(pushbackInputStream, (String)messageContext.getProperty("CHARACTER_SET_ENCODING")) : StAXUtils.createXMLStreamReader((StAXParserConfiguration)StAXParserConfiguration.SOAP, (InputStream)pushbackInputStream, (String)((String)messageContext.getProperty("CHARACTER_SET_ENCODING")));
                    String charEncodingSchema = xmlReader.getCharacterEncodingScheme();
                    if (Objects.nonNull(charEncodingSchema) && !charEncodingSchema.equals(messageContext.getProperty("CHARACTER_SET_ENCODING"))) {
                        messageContext.setProperty("XML_DECLARATION_ENCODING", charEncodingSchema);
                    }
                    StAXOMBuilder builder = new StAXOMBuilder(xmlReader);
                    OMNodeEx documentElement = (OMNodeEx)builder.getDocumentElement();
                    try {
                        this.preserveXmlProcessingInstructions(documentElement, messageContext);
                    }
                    catch (OMException e) {
                        log.error((Object)"Error while preserving XML Processing Instructions.", (Throwable)e);
                    }
                    documentElement.setParent(null);
                    SOAPBody body = soapEnvelope.getBody();
                    body.addChild((OMNode)documentElement);
                }
                catch (XMLStreamException e) {
                    throw AxisFault.makeFault(e);
                }
                catch (IOException e) {
                    throw AxisFault.makeFault(e);
                }
            }
        }
        return soapEnvelope;
    }

    private void preserveXmlProcessingInstructions(OMNodeEx documentElement, MessageContext messageContext) throws OMException {
        String preserveXmlProcessingInstructions = (String)messageContext.getProperty("PRESERVE_XML_PROCESSING_INSTRUCTIONS");
        if ("true".equalsIgnoreCase(preserveXmlProcessingInstructions)) {
            OMContainer parent = documentElement.getParent();
            OMNode element = null;
            if (Objects.nonNull(parent)) {
                OMNode currentChild = parent.getFirstOMChild();
                while (Objects.nonNull(currentChild)) {
                    OMNode nextChild;
                    if (currentChild instanceof OMProcessingInstructionImpl) {
                        if (element == null) {
                            element = currentChild;
                        } else {
                            try {
                                element.insertSiblingAfter(currentChild);
                            }
                            catch (OMException e) {
                                log.error((Object)"Error while preserving the XML Processing Instruction.", (Throwable)e);
                            }
                        }
                    }
                    if (Objects.nonNull(nextChild = currentChild.getNextOMSibling()) && !nextChild.equals(currentChild)) {
                        currentChild = nextChild;
                        continue;
                    }
                    currentChild = null;
                }
            }
            if (element != null) {
                messageContext.setProperty("XML_PROCESSING_INSTRUCTION_ELEMENTS", element);
            }
        }
    }
}

