/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.repository.util.WSInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSInfoList
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog(WSInfoList.class);
    private List jarList = new ArrayList();
    public Map currentJars = new HashMap();
    private Boolean isServiceUnDeploymentAllowed = true;
    private boolean locked = false;
    private final DeploymentEngine deploymentEngine;

    public WSInfoList(DeploymentEngine deploy_engine) {
        this.deploymentEngine = deploy_engine;
    }

    public void setServiceUnDeploymentAllowed(Boolean isServiceUnDeploymentAllowed) {
        this.isServiceUnDeploymentAllowed = isServiceUnDeploymentAllowed;
    }

    public synchronized void addWSInfoItem(File file, Deployer deployer, int type) {
        WSInfo info = (WSInfo)this.currentJars.get(file.getAbsolutePath());
        if (info != null) {
            if (this.deploymentEngine.isHotUpdate() && this.isModified(file, info)) {
                WSInfo wsInfo = new WSInfo(info.getFileName(), info.getLastModifiedDate(), deployer, type);
                this.deploymentEngine.addWSToUndeploy(wsInfo);
                DeploymentFileData deploymentFileData = new DeploymentFileData(file, deployer);
                this.deploymentEngine.addWSToDeploy(deploymentFileData);
            }
        } else {
            info = this.getFileItem(file, deployer, type);
            this.setLastModifiedDate(file, info);
        }
        this.jarList.add(info.getFileName());
    }

    private synchronized void checkForUndeployedServices() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        if (this.isServiceUnDeploymentAllowed.booleanValue()) {
            Iterator infoItems = this.currentJars.keySet().iterator();
            ArrayList<String> tobeRemoved = new ArrayList<String>();
            while (infoItems.hasNext()) {
                int index;
                String filepath;
                File dir;
                String fileName = (String)infoItems.next();
                WSInfo infoItem = (WSInfo)this.currentJars.get(fileName);
                if (infoItem.getType() == 1) continue;
                boolean found = false;
                for (int i = 0; i < this.jarList.size(); ++i) {
                    String s = (String)this.jarList.get(i);
                    if (!fileName.equals(s)) continue;
                    found = true;
                }
                if (found || !(dir = new File(filepath = fileName.substring(0, index = fileName.lastIndexOf(File.separator)))).exists()) continue;
                tobeRemoved.add(fileName);
                log.debug((Object)(fileName + " was added to undeployable list"));
                this.deploymentEngine.addWSToUndeploy(infoItem);
            }
            for (int i = 0; i < tobeRemoved.size(); ++i) {
                String fileName = (String)tobeRemoved.get(i);
                this.currentJars.remove(fileName);
            }
            tobeRemoved.clear();
            this.jarList.clear();
        } else {
            log.warn((Object)"Service un-deployment has been stopped");
        }
        this.locked = false;
    }

    public void init() {
        this.jarList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        DeploymentEngine deploymentEngine = this.deploymentEngine;
        synchronized (deploymentEngine) {
            this.checkForUndeployedServices();
            this.deploymentEngine.unDeploy();
            this.deploymentEngine.doDeploy();
        }
    }

    private WSInfo getFileItem(File file, Deployer deployer, int type) {
        String fileName = file.getName();
        WSInfo info = (WSInfo)this.currentJars.get(fileName);
        if (info == null) {
            info = new WSInfo(file.getAbsolutePath(), file.lastModified(), deployer, type);
            this.currentJars.put(file.getAbsolutePath(), info);
            DeploymentFileData fileData = new DeploymentFileData(file, deployer);
            this.deploymentEngine.addWSToDeploy(fileData);
        }
        return info;
    }

    private boolean isModified(File file, WSInfo wsInfo) {
        long currentTimeStamp = wsInfo.getLastModifiedDate();
        this.setLastModifiedDate(file, wsInfo);
        return currentTimeStamp != wsInfo.getLastModifiedDate();
    }

    private void setLastModifiedDate(File file, WSInfo wsInfo) {
        if (file.getName().startsWith(".")) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File fileItem = files[i];
                if (fileItem.isDirectory()) {
                    this.setLastModifiedDate(fileItem, wsInfo);
                    continue;
                }
                if (wsInfo.getLastModifiedDate() >= fileItem.lastModified()) continue;
                wsInfo.setLastModifiedDate(fileItem.lastModified());
            }
        } else if (wsInfo.getLastModifiedDate() != file.lastModified()) {
            wsInfo.setLastModifiedDate(file.lastModified());
        }
    }
}

