/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrettyPrinter {
    private static final Log log = LogFactory.getLog(PrettyPrinter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prettify(File file) {
        String property = System.getProperty("axis2.jalopy");
        if (property == null || !JavaUtils.isTrueExplicitly(property)) {
            return;
        }
        PrintStream backupOutputStream = System.out;
        PrintStream backupErrorStream = System.err;
        System.setOut(new PrintStream(new ByteArrayOutputStream()));
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        try {
            Class clazz = Loader.loadClass("de.hunsicker.jalopy.Jalopy");
            Object prettifier = clazz.newInstance();
            Method input = clazz.getMethod("setInput", File.class);
            input.invoke(prettifier, file);
            Method output = clazz.getMethod("setOutput", File.class);
            output.invoke(prettifier, file);
            Class clazz2 = Loader.loadClass("de.hunsicker.jalopy.storage.Convention");
            Method instance = clazz2.getMethod("getInstance", new Class[0]);
            Object settings = instance.invoke(null, new Object[0]);
            Class clazz3 = Loader.loadClass("de.hunsicker.jalopy.storage.ConventionKeys");
            Field field = clazz3.getField("COMMENT_FORMAT_MULTI_LINE");
            Object key = field.get(null);
            Method put = clazz2.getMethod("put", key.getClass(), String.class);
            put.invoke(settings, key, "true");
            Method format = clazz.getMethod("format", new Class[0]);
            format.invoke(prettifier, new Object[0]);
            log.debug((Object)("Pretty printed file : " + file));
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)("Jalopy/Log4j not found - unable to pretty print " + file));
        }
        catch (Exception e) {
            log.warn((Object)("Exception occurred while trying to pretty print file " + file), (Throwable)e);
        }
        catch (Throwable t) {
            log.debug((Object)("Exception occurred while trying to pretty print file " + file), t);
        }
        finally {
            System.setOut(backupOutputStream);
            System.setErr(backupErrorStream);
        }
    }
}

