/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jython;

import com.sun.script.jython.JythonScope;
import com.sun.script.jython.JythonScriptEngineFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.__builtin__;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private ScriptEngineFactory factory;
    private PyObject myScope;
    public static final String JYTHON_COMPILE_MODE = "com.sun.script.jython.comp.mode";
    private static ThreadLocal<PySystemState> systemState;
    private static final /* synthetic */ Class class$java$lang$Object;

    public JythonScriptEngine() {
        this.myScope = this.newScope(this.context);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        PyCode code = this.compileScript(script, this.context);
        return new JythonCompiledScript(code);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    @Override
    public Object invokeMethod(Object obj, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.invokeImpl(obj, name, args);
    }

    private Object invokeImpl(Object obj, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("method name is null");
        }
        this.setSystemState();
        PyObject thiz = obj instanceof PyObject ? (PyObject)obj : (obj == null ? this.myScope : JythonScriptEngine.java2py(obj));
        PyObject func = thiz.__findattr__(name);
        if (!(func != null && func.isCallable() || thiz != this.myScope)) {
            systemState.get();
            PyObject builtins = PySystemState.builtins;
            func = builtins.__finditem__(name);
        }
        if (func == null || !func.isCallable()) {
            throw new NoSuchMethodException(name);
        }
        PyObject res = func.__call__(JythonScriptEngine.wrapArguments(args));
        return JythonScriptEngine.py2java(res);
    }

    @Override
    public <T> T getInterface(Object obj, Class<T> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(obj, clazz);
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        final Object thiz = obj;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                Object res = JythonScriptEngine.access$100(JythonScriptEngine.this, thiz, m.getName(), args);
                return JythonScriptEngine.py2java(JythonScriptEngine.java2py(res), m.getReturnType());
            }
        });
    }

    @Override
    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        PyCode code = this.compileScript(str, ctx);
        return this.evalCode(code, ctx);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JythonScriptEngine jythonScriptEngine = this;
        synchronized (jythonScriptEngine) {
            if (this.factory == null) {
                this.factory = new JythonScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public void setContext(ScriptContext ctx) {
        super.setContext(ctx);
        this.myScope = this.newScope(this.context);
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    static PyObject java2py(Object javaObj) {
        return Py.java2py((Object)javaObj);
    }

    static Object py2java(PyObject pyObj, Class type) {
        return pyObj == null ? null : pyObj.__tojava__(type);
    }

    static Object py2java(PyObject pyObj) {
        return JythonScriptEngine.py2java(pyObj, class$java$lang$Object == null ? (class$java$lang$Object = JythonScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
    }

    static PyObject[] wrapArguments(Object[] args) {
        if (args == null) {
            return new PyObject[0];
        }
        PyObject[] res = new PyObject[args.length];
        for (int i = 0; i < args.length; ++i) {
            res[i] = JythonScriptEngine.java2py(args[i]);
        }
        return res;
    }

    private PyObject getJythonScope(ScriptContext ctx) {
        if (ctx == this.context) {
            return this.myScope;
        }
        return this.newScope(ctx);
    }

    private PyObject newScope(ScriptContext ctx) {
        return new JythonScope(this, ctx);
    }

    private void setSystemState() {
        if (systemState.get() == null) {
            PySystemState newState = new PySystemState();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            newState.setClassLoader(cl);
            systemState.set(newState);
            Py.setSystemState((PySystemState)newState);
        }
    }

    private PyCode compileScript(String script, ScriptContext ctx) throws ScriptException {
        try {
            String mode;
            this.setSystemState();
            String fileName = (String)ctx.getAttribute("javax.script.filename");
            if (fileName == null) {
                fileName = "<unknown>";
            }
            if ((mode = (String)ctx.getAttribute(JYTHON_COMPILE_MODE)) == null) {
                mode = "exec";
            }
            return __builtin__.compile((String)script, (String)fileName, (String)mode);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private Object evalCode(PyCode code, ScriptContext ctx) throws ScriptException {
        try {
            this.setSystemState();
            PyObject scope = this.getJythonScope(ctx);
            PyObject res = Py.runCode((PyCode)code, (PyObject)scope, (PyObject)scope);
            return res.__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = JythonScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    static Object access$000(JythonScriptEngine x0, PyCode x1, ScriptContext x2) throws ScriptException {
        return x0.evalCode(x1, x2);
    }

    static Object access$100(JythonScriptEngine x0, Object x1, String x2, Object[] x3) throws ScriptException, NoSuchMethodException {
        return x0.invokeImpl(x1, x2, x3);
    }

    static {
        PySystemState.initialize();
        systemState = new ThreadLocal();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private class JythonCompiledScript
    extends CompiledScript {
        private PyCode code;

        JythonCompiledScript(PyCode code) {
            this.code = code;
        }

        public ScriptEngine getEngine() {
            return JythonScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JythonScriptEngine.access$000(JythonScriptEngine.this, this.code, ctx);
        }
    }
}

