/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.gzip;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;

public class GzipFileObject
extends CompressedFileFileObject {
    protected GzipFileObject(AbstractFileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, container, fs);
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        InputStream is = this.getContainer().getContent().getInputStream();
        return new GZIPInputStream(is);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        OutputStream os = this.getContainer().getContent().getOutputStream(false);
        return new GZIPOutputStream(os);
    }
}

