/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.provider.tar.TarBuffer;
import org.apache.commons.vfs2.provider.tar.TarEntry;

class TarInputStream
extends FilterInputStream {
    private TarBuffer buffer;
    private TarEntry currEntry;
    private boolean debug;
    private int entryOffset;
    private long entrySize;
    private boolean hasHitEOF;
    private byte[] oneBuf;
    private byte[] readBuf;

    TarInputStream(InputStream input) {
        this(input, 10240, 512);
    }

    TarInputStream(InputStream input, int blockSize) {
        this(input, blockSize, 512);
    }

    TarInputStream(InputStream input, int blockSize, int recordSize) {
        super(input);
        this.buffer = new TarBuffer(input, blockSize, recordSize);
        this.oneBuf = new byte[1];
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.buffer.setDebug(debug);
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] headerBuf;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long numToSkip = this.entrySize - (long)this.entryOffset;
            if (this.debug) {
                String message = "TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + numToSkip + " bytes";
                this.debug(message);
            }
            if (numToSkip > 0L) {
                this.longSkip(numToSkip);
            }
            this.readBuf = null;
        }
        if ((headerBuf = this.buffer.readRecord()) == null) {
            if (this.debug) {
                this.debug("READ NULL RECORD");
            }
            this.hasHitEOF = true;
            this.currEntry = null;
        } else if (this.buffer.isEOFRecord(headerBuf)) {
            if (this.debug) {
                this.debug("READ EOF RECORD");
            }
            this.hasHitEOF = true;
            this.currEntry = null;
        } else {
            this.currEntry = new TarEntry(headerBuf);
            if (headerBuf[257] != 117 || headerBuf[258] != 115 || headerBuf[259] != 116 || headerBuf[260] != 97 || headerBuf[261] != 114) {
                // empty if block
            }
            if (this.debug) {
                String message = "TarInputStream: SET CURRENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize();
                this.debug(message);
            }
            this.entryOffset = 0;
            this.entrySize = this.currEntry.getSize();
        }
        if (null != this.currEntry && this.currEntry.isGNULongNameEntry()) {
            StringBuffer longName = new StringBuffer();
            byte[] buffer = new byte[256];
            int length = 0;
            while ((length = this.read(buffer)) >= 0) {
                String str = new String(buffer, 0, length);
                longName.append(str);
            }
            this.getNextEntry();
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.currEntry.setName(longName.toString());
        }
        return this.currEntry;
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    @Override
    public int available() throws IOException {
        long remaining = this.entrySize - (long)this.entryOffset;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public void copyEntryContents(OutputStream output) throws IOException {
        int numRead;
        byte[] buffer = new byte[32768];
        while ((numRead = this.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, numRead);
        }
    }

    @Override
    public void mark(int markLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int num = this.read(this.oneBuf, 0, 1);
        if (num == -1) {
            return num;
        }
        return this.oneBuf[0];
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int position = offset;
        int numToRead = count;
        int totalRead = 0;
        if ((long)this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)(numToRead + this.entryOffset) > this.entrySize) {
            numToRead = (int)(this.entrySize - (long)this.entryOffset);
        }
        if (null != this.readBuf) {
            int size = numToRead > this.readBuf.length ? this.readBuf.length : numToRead;
            System.arraycopy(this.readBuf, 0, buffer, position, size);
            if (size >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                int newLength = this.readBuf.length - size;
                byte[] newBuffer = new byte[newLength];
                System.arraycopy(this.readBuf, size, newBuffer, 0, newLength);
                this.readBuf = newBuffer;
            }
            totalRead += size;
            numToRead -= size;
            position += size;
        }
        while (numToRead > 0) {
            byte[] rec = this.buffer.readRecord();
            if (null == rec) {
                String message = "unexpected EOF with " + numToRead + " bytes unread";
                throw new IOException(message);
            }
            int recordLength = rec.length;
            int size = numToRead;
            if (recordLength > size) {
                System.arraycopy(rec, 0, buffer, position, size);
                this.readBuf = new byte[recordLength - size];
                System.arraycopy(rec, size, this.readBuf, 0, recordLength - size);
            } else {
                size = recordLength;
                System.arraycopy(rec, 0, buffer, position, recordLength);
            }
            totalRead += size;
            numToRead -= size;
            position += size;
        }
        this.entryOffset += totalRead;
        return totalRead;
    }

    @Override
    public void reset() {
    }

    public void longSkip(long numToSkip) throws IOException {
        long skipped = 0L;
        while (skipped < numToSkip) {
            if (numToSkip - skipped > Integer.MAX_VALUE) {
                this.skip(Integer.MAX_VALUE);
                skipped += Integer.MAX_VALUE;
                continue;
            }
            this.skip((int)(numToSkip - skipped));
            skipped += numToSkip - skipped;
        }
    }

    public void skip(int numToSkip) throws IOException {
        int count;
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (int num = numToSkip; num > 0 && (numRead = this.read(skipBuf, 0, count = num > skipBuf.length ? skipBuf.length : num)) != -1; num -= numRead) {
        }
    }

    protected void debug(String message) {
        if (this.debug) {
            System.err.println(message);
        }
    }
}

