/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.tasks.AbstractSyncTask;

public class CopyTask
extends AbstractSyncTask {
    private boolean overwrite;
    private boolean preserveLastModified = true;

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isPreserveLastModified() {
        return this.preserveLastModified;
    }

    @Override
    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        this.log("Copying " + srcFile + " to " + destFile);
        destFile.copyFrom(srcFile, Selectors.SELECT_SELF);
        if (this.preserveLastModified && srcFile.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED) && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
            long lastModTime = srcFile.getContent().getLastModifiedTime();
            destFile.getContent().setLastModifiedTime(lastModTime);
        }
    }

    @Override
    protected void handleUpToDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        if (this.overwrite) {
            this.handleOutOfDateFile(srcFile, destFile);
        }
    }
}

