/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.util.Messages;

public abstract class AbstractVfsTestCase
extends TestCase {
    private static File baseDir;
    private static final Pattern URL_PATTERN;
    private static final Pattern PASSWORD_PATTERN;

    public static String getPackageName(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        if (null != pkg) {
            return pkg.getName();
        }
        String name = clazz.getName();
        if (-1 == name.lastIndexOf(".")) {
            return "";
        }
        return name.substring(0, name.lastIndexOf("."));
    }

    public static File getTestResource(String name) {
        return AbstractVfsTestCase.getTestResource(name, true);
    }

    public static File getTestResource(String name, boolean mustExist) {
        File file = new File(AbstractVfsTestCase.getTestDirectoryFile(), name);
        file = AbstractVfsTestCase.getCanonicalFile(file);
        if (mustExist) {
            AbstractVfsTestCase.assertTrue((String)("Test file \"" + file + "\" does not exist."), (boolean)file.exists());
        } else {
            AbstractVfsTestCase.assertTrue((String)("Test file \"" + file + "\" should not exist."), (!file.exists() ? 1 : 0) != 0);
        }
        return file;
    }

    public static File getTestDirectoryFile() {
        if (baseDir == null) {
            String baseDirProp = AbstractVfsTestCase.getTestDirectory();
            baseDir = AbstractVfsTestCase.getCanonicalFile(new File(baseDirProp));
        }
        return baseDir;
    }

    public static String getTestDirectory() {
        return System.getProperty("test.basedir", "target/test-classes/test-data");
    }

    public static String getResourceTestDirectory() {
        return System.getProperty("test.basedir.res", "test-data");
    }

    public static File getTestDirectory(String name) {
        File file = new File(AbstractVfsTestCase.getTestDirectoryFile(), name);
        file = AbstractVfsTestCase.getCanonicalFile(file);
        AbstractVfsTestCase.assertTrue((String)("Test directory \"" + file + "\" does not exist or is not a directory."), (file.isDirectory() || file.mkdirs() ? 1 : 0) != 0);
        return file;
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static void assertSameMessage(String[] messages, Throwable throwable) {
        Throwable current = throwable;
        for (int i = 0; i < messages.length; ++i) {
            String message = messages[i];
            AbstractVfsTestCase.assertNotNull((Object)current);
            if (message != null) {
                AbstractVfsTestCase.assertEquals((String)message, (String)current.getMessage());
            }
            current = AbstractVfsTestCase.getCause(current);
        }
    }

    public static Throwable getCause(Throwable throwable) {
        try {
            Method method = throwable.getClass().getMethod("getCause", null);
            return (Throwable)method.invoke((Object)throwable, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void assertSameMessage(String code, Throwable throwable) {
        AbstractVfsTestCase.assertSameMessage(code, new Object[0], throwable);
    }

    public static void assertSameMessage(String code, Object[] params, Throwable throwable) {
        Object[] parmArray = params;
        if (throwable instanceof FileSystemException) {
            FileSystemException fse = (FileSystemException)throwable;
            AbstractVfsTestCase.assertEquals((String)code, (String)fse.getCode());
            AbstractVfsTestCase.assertEquals((int)params.length, (int)fse.getInfo().length);
            parmArray = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                String value = String.valueOf(params[i]);
                Matcher urlMatcher = URL_PATTERN.matcher(value);
                if (urlMatcher.find()) {
                    Matcher pwdMatcher = PASSWORD_PATTERN.matcher(value);
                    value = pwdMatcher.replaceFirst(":***@");
                }
                AbstractVfsTestCase.assertEquals((String)value, (String)fse.getInfo()[i]);
                parmArray[i] = value;
            }
        }
        String message = Messages.getString((String)code, (Object[])parmArray);
        AbstractVfsTestCase.assertEquals((String)message, (String)throwable.getMessage());
    }

    public static void assertSameMessage(String code, Object param, Throwable throwable) {
        AbstractVfsTestCase.assertSameMessage(code, new Object[]{param}, throwable);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    static {
        URL_PATTERN = Pattern.compile("[a-z]+://.*");
        PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");
    }
}

