/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.test.FileInfo;

public class VerifyingFileSelector
extends Assert
implements FileSelector {
    private final FileInfo rootFile;
    private final List<FileObject> files = new ArrayList<FileObject>();
    private FileInfo currentFolderInfo;
    private FileObject currentFolder;
    private Set<String> children;
    private List<Set<String>> stack = new ArrayList<Set<String>>();

    public VerifyingFileSelector(FileInfo fileInfo) {
        this.rootFile = fileInfo;
        this.children = new HashSet<String>();
        this.children.add(this.rootFile.baseName);
    }

    public boolean includeFile(FileSelectInfo fileInfo) throws FileSystemException {
        FileObject file = fileInfo.getFile();
        if (file == this.currentFolder) {
            VerifyingFileSelector.assertEquals((int)0, (int)this.children.size());
            this.currentFolder = this.currentFolder.getParent();
            this.currentFolderInfo = this.currentFolderInfo.getParent();
            this.children = this.stack.remove(0);
        }
        String baseName = file.getName().getBaseName();
        FileInfo childInfo = this.getChild(baseName);
        VerifyingFileSelector.assertSame((Object)childInfo.type, (Object)file.getType());
        boolean isChild = this.children.remove(baseName);
        VerifyingFileSelector.assertTrue((boolean)isChild);
        this.files.add(file);
        return true;
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) throws FileSystemException {
        FileObject folder = fileInfo.getFile();
        VerifyingFileSelector.assertSame((Object)FileType.FOLDER, (Object)folder.getType());
        String baseName = folder.getName().getBaseName();
        if (this.currentFolder == null) {
            VerifyingFileSelector.assertEquals((String)this.rootFile.baseName, (String)baseName);
            this.currentFolderInfo = this.rootFile;
        } else {
            VerifyingFileSelector.assertSame((Object)this.currentFolder, (Object)folder.getParent());
            this.currentFolderInfo = this.getChild(baseName);
            VerifyingFileSelector.assertSame((Object)FileType.FOLDER, (Object)this.currentFolderInfo.type);
        }
        this.stack.add(0, this.children);
        this.children = new HashSet<String>(this.currentFolderInfo.children.keySet());
        this.currentFolder = folder;
        return true;
    }

    private FileInfo getChild(String baseName) {
        if (this.currentFolderInfo == null) {
            VerifyingFileSelector.assertEquals((String)this.rootFile.baseName, (String)baseName);
            return this.rootFile;
        }
        FileInfo child = this.currentFolderInfo.children.get(baseName);
        VerifyingFileSelector.assertNotNull((String)("Could not locate child " + baseName), (Object)child);
        return child;
    }

    public List<FileObject> finish() {
        VerifyingFileSelector.assertEquals((int)0, (int)this.children.size());
        return this.files;
    }
}

