/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.test.FileInfo;
import org.apache.commons.vfs2.test.VerifyingFileSelector;

public class ProviderReadTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT};
    }

    public void testStructure() throws Exception {
        FileInfo baseInfo = this.buildExpectedStructure();
        this.assertSameStructure(this.getReadFolder(), baseInfo);
    }

    protected void assertSameStructure(FileObject folder, FileInfo expected) throws Exception {
        ArrayList<FileInfo> queueExpected = new ArrayList<FileInfo>();
        queueExpected.add(expected);
        ArrayList<FileObject> queueActual = new ArrayList<FileObject>();
        queueActual.add(folder);
        while (queueActual.size() > 0) {
            int i;
            FileObject file = (FileObject)queueActual.remove(0);
            FileInfo info = (FileInfo)queueExpected.remove(0);
            ProviderReadTests.assertSame((Object)info.type, (Object)file.getType());
            if (info.type == FileType.FILE) continue;
            FileObject[] children = file.getChildren();
            ProviderReadTests.assertNotNull((Object)children);
            int length = children.length;
            if (info.children.size() != children.length) {
                for (i = 0; i < children.length; ++i) {
                    if (children[i].getName().getBaseName().startsWith(".")) {
                        --length;
                        continue;
                    }
                    System.out.println(children[i].getName());
                }
            }
            ProviderReadTests.assertEquals((String)("count children of \"" + file.getName() + "\""), (int)info.children.size(), (int)length);
            for (i = 0; i < children.length; ++i) {
                FileObject child = children[i];
                String childName = child.getName().getBaseName();
                if (childName.startsWith(".")) continue;
                FileInfo childInfo = info.children.get(childName);
                ProviderReadTests.assertNotNull((Object)childInfo);
                queueExpected.add(childInfo);
                queueActual.add(child);
            }
        }
    }

    public void testType() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ProviderReadTests.assertSame((Object)FileType.FILE, (Object)file.getType());
        file = this.getReadFolder().resolveFile("dir1");
        ProviderReadTests.assertSame((Object)FileType.FOLDER, (Object)file.getType());
        file = this.getReadFolder().resolveFile("unknown-child");
        ProviderReadTests.assertSame((Object)FileType.IMAGINARY, (Object)file.getType());
    }

    public void testRoot() throws FileSystemException {
        FileSystem fs = this.getReadFolder().getFileSystem();
        String uri = fs.getRootURI();
        FileObject file = this.getManager().resolveFile(uri);
        file.getChildren();
    }

    public void testFolderContent() throws Exception {
        if (this.getReadFolder().getFileSystem().hasCapability(Capability.DIRECTORY_READ_CONTENT)) {
            return;
        }
        FileObject folder = this.getReadFolder().resolveFile("dir1");
        try {
            folder.getContent().getInputStream();
            ProviderReadTests.fail();
        }
        catch (FileSystemException e) {
            ProviderReadTests.assertSameMessage("vfs.provider/read-not-file.error", folder, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentReadFolder() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("file1.txt");
        ProviderReadTests.assertTrue((boolean)file.exists());
        FileObject folder = this.getReadFolder().resolveFile("dir1");
        ProviderReadTests.assertTrue((boolean)folder.exists());
        InputStream instr = file.getContent().getInputStream();
        try {
            folder.exists();
            folder.getType();
            folder.getChildren();
        }
        finally {
            instr.close();
        }
    }

    public void testFindFiles() throws Exception {
        FileInfo fileInfo = this.buildExpectedStructure();
        VerifyingFileSelector selector = new VerifyingFileSelector(fileInfo);
        FileObject[] actualFiles = this.getReadFolder().findFiles((FileSelector)selector);
        List<FileObject> expectedFiles = selector.finish();
        ProviderReadTests.assertEquals((int)expectedFiles.size(), (int)actualFiles.length);
        int count = expectedFiles.size();
        for (int i = 0; i < count; ++i) {
            FileObject expected = expectedFiles.get(i);
            FileObject actual = actualFiles[i];
            ProviderReadTests.assertEquals((Object)expected, (Object)actual);
        }
    }
}

