/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;

public class FileDepthSelector
implements FileSelector {
    private final int minDepth;
    private final int maxDepth;

    public FileDepthSelector(int minDepth, int maxDepth) {
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean includeFile(FileSelectInfo fileInfo) {
        int depth = fileInfo.getDepth();
        return this.minDepth <= depth && depth <= this.maxDepth;
    }

    @Override
    public boolean traverseDescendents(FileSelectInfo fileInfo) {
        return fileInfo.getDepth() < this.maxDepth;
    }
}

