/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class FtpClientFactory {
    private static final int BUFSZ = 40;
    private static final Log log = LogFactory.getLog(FtpClientFactory.class);

    private FtpClientFactory() {
    }

    public static FTPClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions, Integer defaultTimeout) throws FileSystemException {
        return FtpClientFactory.createConnection(hostname, port, username, password, workingDirectory, fileSystemOptions, null, null, null, null, null, null, defaultTimeout);
    }

    public static FTPClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return FtpClientFactory.createConnection(hostname, port, username, password, workingDirectory, fileSystemOptions, null, null, null, null, null, null, null);
    }

    public static FTPClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions, String proxyServer, String proxyPort, String proxyUser, String proxyPassword, String timeout, String retryCount, Integer defaultTimeout) throws FileSystemException {
        if (username == null) {
            username = "anonymous".toCharArray();
        }
        if (password == null) {
            password = "anonymous".toCharArray();
        }
        Integer lTimeout = null;
        try {
            lTimeout = Integer.parseInt(timeout);
        }
        catch (NumberFormatException nfe) {
            lTimeout = 5000;
        }
        Integer iRetryCount = null;
        try {
            iRetryCount = Integer.parseInt(retryCount);
        }
        catch (NumberFormatException nfe) {
            iRetryCount = 5;
        }
        boolean proxyMode = false;
        try {
            FTPClient client;
            if (proxyServer != null && proxyPort != null) {
                int iProxyPort;
                try {
                    iProxyPort = Integer.parseInt(proxyPort);
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("Invalid proxy port " + proxyPort + ". Set the port as 8080. (default)"));
                    iProxyPort = 8080;
                }
                if (proxyUser != null && proxyPassword != null) {
                    client = new FTPHTTPClient(proxyServer, iProxyPort, proxyUser, proxyPassword);
                    proxyMode = true;
                } else {
                    client = new FTPHTTPClient(proxyServer, iProxyPort);
                    proxyMode = true;
                }
            } else {
                client = new FTPClient();
            }
            FtpClientFactory.configureClient(fileSystemOptions, client);
            FTPFileEntryParserFactory myFactory = FtpFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions);
            if (myFactory != null) {
                client.setParserFactory(myFactory);
            }
            try {
                String controlEncoding;
                Integer socketTimeout;
                int reply;
                if (defaultTimeout != null && defaultTimeout > 0) {
                    client.setDefaultTimeout(defaultTimeout.intValue());
                }
                if (proxyMode) {
                    client.setConnectTimeout(lTimeout.intValue());
                    boolean connect = false;
                    while (!connect && iRetryCount > 0) {
                        Integer n;
                        Integer n2;
                        try {
                            client.connect(hostname, port);
                            connect = true;
                        }
                        catch (SocketTimeoutException e) {
                            n2 = iRetryCount;
                            n = iRetryCount = Integer.valueOf(iRetryCount - 1);
                        }
                        catch (IOException e) {
                            n2 = iRetryCount;
                            n = iRetryCount = Integer.valueOf(iRetryCount - 1);
                        }
                    }
                } else {
                    client.connect(hostname, port);
                }
                if (defaultTimeout != null && defaultTimeout > 0) {
                    client.setSoTimeout(defaultTimeout.intValue());
                }
                if (!FTPReply.isPositiveCompletion((int)(reply = client.getReplyCode()))) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", hostname);
                }
                if (!client.login(UserAuthenticatorUtils.toString(username), UserAuthenticatorUtils.toString(password))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{hostname, UserAuthenticatorUtils.toString(username)}, null);
                }
                Integer fileType = FtpFileSystemConfigBuilder.getInstance().getFileType(fileSystemOptions);
                if (fileType == null) {
                    fileType = 2;
                }
                if (!client.setFileType(fileType.intValue())) {
                    throw new FileSystemException("vfs.provider.ftp/set-fileType.error", hostname);
                }
                Integer dataTimeout = FtpFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (dataTimeout != null) {
                    client.setDataTimeout(dataTimeout.intValue());
                }
                if ((socketTimeout = FtpFileSystemConfigBuilder.getInstance().getSoTimeout(fileSystemOptions)) != null) {
                    client.setSoTimeout(socketTimeout.intValue());
                }
                Boolean userDirIsRoot = FtpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue() || client.changeWorkingDirectory(workingDirectory))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", workingDirectory);
                }
                Boolean passiveMode = FtpFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (proxyMode || passiveMode != null && passiveMode.booleanValue()) {
                    client.enterLocalPassiveMode();
                }
                if ((controlEncoding = FtpFileSystemConfigBuilder.getInstance().getControlEncoding(fileSystemOptions)) != null) {
                    client.setControlEncoding(controlEncoding);
                }
            }
            catch (IOException e) {
                if (client.isConnected()) {
                    client.disconnect();
                }
                throw e;
            }
            return client;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
    }

    private static void configureClient(FileSystemOptions fileSystemOptions, FTPClient client) {
        String key = FtpFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
        if (key != null) {
            String[] shortMonthNames;
            String serverTimeZoneId;
            String recentDateFormat;
            String defaultDateFormat;
            FTPClientConfig config = new FTPClientConfig(key);
            String serverLanguageCode = FtpFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
            if (serverLanguageCode != null) {
                config.setServerLanguageCode(serverLanguageCode);
            }
            if ((defaultDateFormat = FtpFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                config.setDefaultDateFormatStr(defaultDateFormat);
            }
            if ((recentDateFormat = FtpFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                config.setRecentDateFormatStr(recentDateFormat);
            }
            if ((serverTimeZoneId = FtpFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                config.setServerTimeZoneId(serverTimeZoneId);
            }
            if ((shortMonthNames = FtpFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                StringBuilder shortMonthNamesStr = new StringBuilder(40);
                for (int i = 0; i < shortMonthNames.length; ++i) {
                    if (shortMonthNamesStr.length() > 0) {
                        shortMonthNamesStr.append("|");
                    }
                    shortMonthNamesStr.append(shortMonthNames[i]);
                }
                config.setShortMonthNames(shortMonthNamesStr.toString());
            }
            client.configure(config);
        }
    }
}

