/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftps.FtpsClientWrapper;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;

public class FtpsFileProvider
extends FtpFileProvider {
    public static final String KEY_STORE = "vfs.ssl.keystore";
    public static final String TRUST_STORE = "vfs.ssl.truststore";
    public static final String KS_PASSWD = "vfs.ssl.kspassword";
    public static final String TS_PASSWD = "vfs.ssl.tspassword";
    public static final String KEY_PASSWD = "vfs.ssl.keypassword";
    private static final Log log = LogFactory.getLog(FtpsFileProvider.class);

    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        FileSystemOptions opts = new FileSystemOptions();
        if (name instanceof URLFileName) {
            String queryString;
            this.getLogger().info((Object)("FileName :" + name.getURI()));
            if (fileSystemOptions != null) {
                opts = fileSystemOptions;
            }
            if ((queryString = ((URLFileName)name).getQueryString()) != null) {
                FtpsFileSystemConfigBuilder cfgBuilder = FtpsFileSystemConfigBuilder.getInstance();
                StringTokenizer st = new StringTokenizer(queryString, "&");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    String[] arg = param.split("=");
                    if ("vfs.passive".equalsIgnoreCase(arg[0]) && "true".equalsIgnoreCase(arg[1])) {
                        cfgBuilder.setPassiveMode(opts, true);
                        continue;
                    }
                    if ("vfs.implicit".equalsIgnoreCase(arg[0]) && "true".equalsIgnoreCase(arg[1])) {
                        cfgBuilder.setFtpsType(opts, "implicit");
                        continue;
                    }
                    if ("vfs.protection".equalsIgnoreCase(arg[0])) {
                        if ("P".equalsIgnoreCase(arg[1])) {
                            cfgBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.P);
                            continue;
                        }
                        if ("C".equalsIgnoreCase(arg[1])) {
                            cfgBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.C);
                            continue;
                        }
                        if ("S".equalsIgnoreCase(arg[1])) {
                            cfgBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.S);
                            continue;
                        }
                        if (!"E".equalsIgnoreCase(arg[1])) continue;
                        cfgBuilder.setDataChannelProtectionLevel(opts, FtpsDataChannelProtectionLevel.E);
                        continue;
                    }
                    if (KEY_STORE.equalsIgnoreCase(arg[0])) {
                        cfgBuilder.setKeyStore(opts, arg[1].trim());
                        continue;
                    }
                    if (TRUST_STORE.equalsIgnoreCase(arg[0])) {
                        cfgBuilder.setTrustStore(opts, arg[1].trim());
                        continue;
                    }
                    if (KS_PASSWD.equalsIgnoreCase(arg[0])) {
                        cfgBuilder.setKeyStorePW(opts, arg[1]);
                        continue;
                    }
                    if (TS_PASSWD.equalsIgnoreCase(arg[0])) {
                        cfgBuilder.setTrustStorePW(opts, arg[1]);
                        continue;
                    }
                    if (!KEY_PASSWD.equalsIgnoreCase(arg[0])) continue;
                    cfgBuilder.setKeyPW(opts, arg[1]);
                }
            }
        }
        FtpsClientWrapper ftpClient = new FtpsClientWrapper(rootName, opts, this.defaultTimeout);
        return new FtpFileSystem(rootName, ftpClient, fileSystemOptions);
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpsFileSystemConfigBuilder.getInstance();
    }
}

