/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;

public final class RamFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String MAX_SIZE_KEY = "maxsize";
    private static final RamFileSystemConfigBuilder SINGLETON = new RamFileSystemConfigBuilder();

    private RamFileSystemConfigBuilder() {
        super("ram.");
    }

    public static RamFileSystemConfigBuilder getInstance() {
        return SINGLETON;
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return RamFileSystem.class;
    }

    public int getMaxSize(FileSystemOptions opts) {
        return this.getInteger(opts, MAX_SIZE_KEY, Integer.MAX_VALUE);
    }

    public void setMaxSize(FileSystemOptions opts, int sizeInBytes) {
        this.setParam(opts, MAX_SIZE_KEY, new Integer(sizeInBytes));
    }
}

