/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class ProviderRandomReadWriteTests
extends AbstractProviderTestCase {
    private final String TEST_DATA = "This is a test file.";

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.GET_TYPE, Capability.CREATE, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    public void testRandomWrite() throws Exception {
        FileObject file = null;
        try {
            file = this.createScratchFolder().resolveFile("random_write.txt");
            file.createFile();
            RandomAccessContent ra = file.getContent().getRandomAccessContent(RandomAccessMode.READWRITE);
            ra.writeByte((int)"This is a test file.".charAt(0));
            ra.seek(3L);
            ra.writeByte((int)"This is a test file.".charAt(3));
            ra.writeByte((int)"This is a test file.".charAt(4));
            ra.seek(3L);
            ra.writeByte((int)"This is a test file.".charAt(7));
            ra.writeByte((int)"This is a test file.".charAt(8));
            ra.seek(10L);
            ra.writeByte((int)"This is a test file.".charAt(10));
            ra.writeByte((int)"This is a test file.".charAt(11));
            ra.seek(0L);
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)"This is a test file.".charAt(0));
            ra.seek(3L);
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)"This is a test file.".charAt(7));
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)"This is a test file.".charAt(8));
            ra.seek(10L);
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)"This is a test file.".charAt(10));
            ProviderRandomReadWriteTests.assertEquals((int)ra.readByte(), (int)"This is a test file.".charAt(11));
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }
}

