/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.local.LocalFileRandomAccessContent;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class LocalFile
extends AbstractFileObject
implements FileObject {
    private final String rootFile;
    private File file;

    protected LocalFile(LocalFileSystem fileSystem, String rootFile, AbstractFileName name) throws FileSystemException {
        super(name, fileSystem);
        this.rootFile = rootFile;
    }

    protected File getLocalFile() {
        return this.file;
    }

    @Override
    protected void doAttach() throws Exception {
        if (this.file == null) {
            String fileName = this.rootFile + this.getName().getPathDecoded();
            this.file = new File(fileName);
        }
    }

    @Override
    protected FileType doGetType() throws Exception {
        if (!this.file.exists() && this.file.length() < 1L) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return UriParser.encode(this.file.list());
    }

    @Override
    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", this.file);
        }
    }

    @Override
    protected void doRename(FileObject newfile) throws Exception {
        LocalFile newLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(newfile);
        if (!this.file.renameTo(newLocalFile.getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", new String[]{this.file.toString(), newfile.toString()});
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", this.file);
        }
    }

    @Override
    protected boolean doIsWriteable() throws FileSystemException {
        return this.file.canWrite();
    }

    @Override
    protected boolean doIsHidden() {
        return this.file.isHidden();
    }

    @Override
    protected boolean doIsReadable() throws FileSystemException {
        return this.file.canRead();
    }

    @Override
    protected long doGetLastModifiedTime() throws FileSystemException {
        return this.file.lastModified();
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws FileSystemException {
        return this.file.setLastModified(modtime);
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.file);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new FileOutputStream(this.file.getPath(), bAppend);
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new LocalFileRandomAccessContent(this.file, mode);
    }

    @Override
    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        if (!FileObjectUtils.isInstanceOf(destFile, LocalFile.class)) {
            return false;
        }
        LocalFile destLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(destFile);
        if (!this.exists() || !destLocalFile.exists()) {
            return false;
        }
        try {
            return this.file.getCanonicalPath().equals(destLocalFile.file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }
}

