/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SftpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Session session;
    private ChannelSftp idleChannel;

    protected SftpFileSystem(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.session = session;
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        block11: {
            Session session;
            if (this.session != null && this.session.isConnected()) break block11;
            this.doCloseCommunicationLink();
            UserAuthenticationData authData = null;
            try {
                GenericFileName rootName = (GenericFileName)this.getRootName();
                authData = UserAuthenticatorUtils.authenticate(this.getFileSystemOptions(), SftpFileProvider.AUTHENTICATOR_TYPES);
                session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), this.getFileSystemOptions());
            }
            catch (Exception e) {
                try {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    UserAuthenticatorUtils.cleanup(authData);
                    throw throwable;
                }
            }
            UserAuthenticatorUtils.cleanup(authData);
            this.session = session;
        }
        try {
            ChannelSftp channel;
            if (this.idleChannel != null) {
                channel = this.idleChannel;
                this.idleChannel = null;
            } else {
                channel = (ChannelSftp)this.session.openChannel("sftp");
                channel.connect();
                Boolean userDirIsRoot = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                String workingDirectory = this.getRootName().getPath();
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue())) {
                    try {
                        channel.cd(workingDirectory);
                    }
                    catch (SftpException e) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", workingDirectory, (Throwable)e);
                    }
                }
            }
            return channel;
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)e);
        }
    }

    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            if (channel.isConnected() && !channel.isClosed()) {
                this.idleChannel = channel;
            }
        } else {
            channel.disconnect();
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(SftpFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 1000.0;
    }
}

