/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class FtpsClientFactory {
    protected static String KS_PASSWD;
    protected static String TS_PASSWD;
    protected static String KEY_PASSWD;
    protected static String KEYSTORE;
    protected static String TRUSTSTORE;
    protected static KeyManager clientKeyManager;
    protected static TrustManager clientTrustManager;
    private static final Log log;

    private FtpsClientFactory() {
    }

    public static FTPSClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (username == null) {
            username = "anonymous".toCharArray();
        }
        if (password == null) {
            password = "anonymous".toCharArray();
        }
        try {
            FTPFileEntryParserFactory myFactory;
            FTPSClient client;
            if (FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions).equals("explicit")) {
                client = new FTPSClient();
            } else if (FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions).equals("implicit")) {
                client = new FTPSClient(true);
            } else {
                throw new FileSystemException("Invalid FTPS type of " + FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions) + " specified. Must be 'implicit' or 'explicit'");
            }
            String key = FtpsFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
            if (key != null) {
                String[] shortMonthNames;
                String serverTimeZoneId;
                String recentDateFormat;
                String defaultDateFormat;
                FTPClientConfig config = new FTPClientConfig(key);
                String serverLanguageCode = FtpsFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
                if (serverLanguageCode != null) {
                    config.setServerLanguageCode(serverLanguageCode);
                }
                if ((defaultDateFormat = FtpsFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                    config.setDefaultDateFormatStr(defaultDateFormat);
                }
                if ((recentDateFormat = FtpsFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                    config.setRecentDateFormatStr(recentDateFormat);
                }
                if ((serverTimeZoneId = FtpsFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                    config.setServerTimeZoneId(serverTimeZoneId);
                }
                if ((shortMonthNames = FtpsFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                    StringBuilder shortMonthNamesStr = new StringBuilder(40);
                    for (int i = 0; i < shortMonthNames.length; ++i) {
                        if (shortMonthNamesStr.length() > 0) {
                            shortMonthNamesStr.append("|");
                        }
                        shortMonthNamesStr.append(shortMonthNames[i]);
                    }
                    config.setShortMonthNames(shortMonthNamesStr.toString());
                }
                client.configure(config);
            }
            if ((myFactory = FtpsFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions)) != null) {
                client.setParserFactory(myFactory);
            }
            try {
                FtpsClientFactory.addSSLParameters(client, fileSystemOptions);
                client.connect(hostname, port);
                log.info((Object)"Successfully connected to the FTP server");
                int reply = client.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", hostname);
                }
                if (!client.login(UserAuthenticatorUtils.toString(username), UserAuthenticatorUtils.toString(password))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{hostname, UserAuthenticatorUtils.toString(username)}, null);
                }
                if (!client.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", hostname);
                }
                Integer dataTimeout = FtpsFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (dataTimeout != null) {
                    client.setDataTimeout(dataTimeout.intValue());
                }
                Boolean userDirIsRoot = FtpsFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue() || client.changeWorkingDirectory(workingDirectory))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", workingDirectory);
                }
                Boolean passiveMode = FtpsFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (passiveMode != null && passiveMode.booleanValue()) {
                    client.enterLocalPassiveMode();
                }
            }
            catch (IOException e) {
                if (client.isConnected()) {
                    client.disconnect();
                }
                throw e;
            }
            return client;
        }
        catch (Exception exc) {
            log.error((Object)exc);
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
    }

    private static void addSSLParameters(FTPSClient ftpsClient, FileSystemOptions fileSystemOptions) throws Exception {
        KEYSTORE = FtpsFileSystemConfigBuilder.getInstance().getKeyStore(fileSystemOptions);
        TRUSTSTORE = FtpsFileSystemConfigBuilder.getInstance().getTrustStore(fileSystemOptions);
        KS_PASSWD = FtpsFileSystemConfigBuilder.getInstance().getKeyStorePW(fileSystemOptions);
        TS_PASSWD = FtpsFileSystemConfigBuilder.getInstance().getTrustStorePW(fileSystemOptions);
        KEY_PASSWD = FtpsFileSystemConfigBuilder.getInstance().getKeyPW(fileSystemOptions);
        KeyManagerFactory keyManagerFactory = null;
        TrustManagerFactory trustManagerFactory = null;
        try {
            FileInputStream keystorePath = new FileInputStream(new File(KEYSTORE));
            FileInputStream truststorePath = new FileInputStream(new File(TRUSTSTORE));
            KeyStore keyStore = KeyStore.getInstance("jks");
            KeyStore trustStore = KeyStore.getInstance("jks");
            keyStore.load(keystorePath, KS_PASSWD.toCharArray());
            trustStore.load(truststorePath, TS_PASSWD.toCharArray());
            keystorePath.close();
            truststorePath.close();
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, KEY_PASSWD.toCharArray());
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Error occurred when initializing keystores", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while retrieving the keystore paths", (Throwable)e);
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Error when getting the default algorithm", (Throwable)e);
            throw e;
        }
        catch (CertificateException e) {
            log.error((Object)"Certificate exception occurred when loading the KeyStores ", (Throwable)e);
            throw e;
        }
        catch (UnrecoverableKeyException e) {
            log.error((Object)"Unrecoverable Key exception occurred", (Throwable)e);
            throw e;
        }
        clientKeyManager = keyManagerFactory.getKeyManagers()[0];
        clientTrustManager = trustManagerFactory.getTrustManagers()[0];
        ftpsClient.setKeyManager(clientKeyManager);
        ftpsClient.setTrustManager(clientTrustManager);
        log.info((Object)"SSL parameters added to the FTPS client");
    }

    static {
        log = LogFactory.getLog(FtpsClientFactory.class);
    }
}

