/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

class HttpRandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected long filePointer = 0L;
    private final HttpFileObject fileObject;
    private final HttpFileSystem fileSystem;
    private DataInputStream dis = null;
    private MonitorInputStream mis = null;

    HttpRandomAccessContent(HttpFileObject fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
        this.fileSystem = (HttpFileSystem)this.fileObject.getFileSystem();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(pos)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        long skipped;
        if (this.dis != null) {
            return this.dis;
        }
        GetMethod getMethod = new GetMethod();
        this.fileObject.setupMethod((HttpMethod)getMethod);
        getMethod.setRequestHeader("Range", "bytes=" + this.filePointer + "-");
        int status = this.fileSystem.getClient().executeMethod((HttpMethod)getMethod);
        if (status != 206 && status != 200) {
            throw new FileSystemException("vfs.provider.http/get-range.error", new Object[]{this.fileObject.getName(), new Long(this.filePointer)});
        }
        this.mis = new HttpFileObject.HttpInputStream(getMethod);
        if (status == 200 && (skipped = this.mis.skip(this.filePointer)) != this.filePointer) {
            throw new FileSystemException("vfs.provider.http/get-range.error", new Object[]{this.fileObject.getName(), new Long(this.filePointer)});
        }
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++HttpRandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    HttpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    HttpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }
        });
        return this.dis;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.dis.close();
            this.dis = null;
            this.mis = null;
        }
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

