/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileData;
import org.apache.commons.vfs2.provider.ram.RamFileOutputStream;
import org.apache.commons.vfs2.provider.ram.RamFileRandomAccessContent;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;
import org.apache.commons.vfs2.provider.ram.RamFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class RamFileObject
extends AbstractFileObject
implements FileObject {
    private final RamFileSystem fs;
    private RamFileData data;

    protected RamFileObject(AbstractFileName name, RamFileSystem fs) {
        super(name, fs);
        this.fs = fs;
        this.fs.attach(this);
    }

    private void save() throws FileSystemException {
        this.fs.save(this);
    }

    @Override
    protected FileType doGetType() throws Exception {
        return this.data.getType();
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return this.fs.listChildren(this.getName());
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.data.getBuffer().length;
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
        }
        return new ByteArrayInputStream(this.data.getBuffer());
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (!bAppend) {
            this.data.setBuffer(new byte[0]);
        }
        return new RamFileOutputStream(this);
    }

    @Override
    protected void doDelete() throws Exception {
        this.fs.delete(this);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.data.getLastModified();
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.data.setLastModified(modtime);
        return true;
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.injectType(FileType.FOLDER);
        this.save();
    }

    @Override
    protected void doRename(FileObject newfile) throws Exception {
        this.fs.rename(this, (RamFileObject)newfile);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new RamFileRandomAccessContent(this, mode);
    }

    @Override
    protected void doAttach() throws Exception {
        this.fs.attach(this);
    }

    RamFileData getData() {
        return this.data;
    }

    void setData(RamFileData data) {
        this.data = data;
    }

    @Override
    protected void injectType(FileType fileType) {
        this.data.setType(fileType);
        super.injectType(fileType);
    }

    @Override
    protected void endOutput() throws Exception {
        super.endOutput();
        this.save();
    }

    int size() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    synchronized void resize(int newSize) throws IOException {
        if (this.fs.getFileSystemOptions() != null) {
            int maxSize = RamFileSystemConfigBuilder.getInstance().getMaxSize(this.fs.getFileSystemOptions());
            if (this.fs.size() + newSize - this.size() > maxSize) {
                throw new IOException("FileSystem capacity (" + maxSize + ") exceeded.");
            }
        }
        this.data.resize(newSize);
    }
}

