/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;

public final class SftpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    public static final ProxyType PROXY_HTTP = new ProxyType("http");
    public static final ProxyType PROXY_SOCKS5 = new ProxyType("socks");
    private static final SftpFileSystemConfigBuilder BUILDER = new SftpFileSystemConfigBuilder();
    private static final String USER_DIR_IS_ROOT = SftpFileSystemConfigBuilder.class.getName() + ".USER_DIR_IS_ROOT";
    private static final String TIMEOUT = SftpFileSystemConfigBuilder.class.getName() + ".TIMEOUT";

    private SftpFileSystemConfigBuilder() {
        super("sftp.");
    }

    public static SftpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setUserInfo(FileSystemOptions opts, UserInfo info) {
        this.setParam(opts, UserInfo.class.getName(), info);
    }

    public UserInfo getUserInfo(FileSystemOptions opts) {
        return (UserInfo)this.getParam(opts, UserInfo.class.getName());
    }

    public void setKnownHosts(FileSystemOptions opts, File sshdir) throws FileSystemException {
        this.setParam(opts, "knownHosts", sshdir);
    }

    public File getKnownHosts(FileSystemOptions opts) {
        return (File)this.getParam(opts, "knownHosts");
    }

    public void setIdentities(FileSystemOptions opts, File[] identities) throws FileSystemException {
        this.setParam(opts, "identities", identities);
    }

    public void setCompression(FileSystemOptions opts, String compression) throws FileSystemException {
        this.setParam(opts, "compression", compression);
    }

    public String getCompression(FileSystemOptions opts) {
        return this.getString(opts, "compression");
    }

    public File[] getIdentities(FileSystemOptions opts) {
        return (File[])this.getParam(opts, "identities");
    }

    public void setStrictHostKeyChecking(FileSystemOptions opts, String hostKeyChecking) throws FileSystemException {
        if (hostKeyChecking == null || !hostKeyChecking.equals("ask") && !hostKeyChecking.equals("no") && !hostKeyChecking.equals("yes")) {
            throw new FileSystemException("vfs.provider.sftp/StrictHostKeyChecking-arg.error", hostKeyChecking);
        }
        this.setParam(opts, "StrictHostKeyChecking", hostKeyChecking);
    }

    public String getStrictHostKeyChecking(FileSystemOptions opts) {
        return this.getString(opts, "StrictHostKeyChecking", "no");
    }

    public void setUserDirIsRoot(FileSystemOptions opts, boolean userDirIsRoot) {
        this.setParam(opts, USER_DIR_IS_ROOT, userDirIsRoot ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions opts) {
        return this.getBoolean(opts, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public void setTimeout(FileSystemOptions opts, Integer timeout) {
        this.setParam(opts, TIMEOUT, timeout);
    }

    public Integer getTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, TIMEOUT);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return SftpFileSystem.class;
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, "proxyHost", proxyHost);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, "proxyPort", new Integer(proxyPort));
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, "proxyPort", 0);
    }

    public void setProxyType(FileSystemOptions opts, ProxyType proxyType) {
        this.setParam(opts, "proxyType", proxyType);
    }

    public ProxyType getProxyType(FileSystemOptions opts) {
        return (ProxyType)this.getParam(opts, "proxyType");
    }

    public void setPreferredAuthentications(FileSystemOptions opts, String preferredAuthentications) {
        this.setParam(opts, "PreferredAuthentications", preferredAuthentications);
    }

    public String getPreferredAuthentications(FileSystemOptions opts) {
        return (String)this.getParam(opts, "PreferredAuthentications");
    }

    public static final class ProxyType
    implements Serializable,
    Comparable<ProxyType> {
        private static final long serialVersionUID = 20101208L;
        private final String proxyType;

        private ProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        public int compareTo(ProxyType o) {
            return this.proxyType.compareTo(o.proxyType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyType proxyType1 = (ProxyType)o;
            return !(this.proxyType != null ? !this.proxyType.equals(proxyType1.proxyType) : proxyType1.proxyType != null);
        }

        public int hashCode() {
            return this.proxyType.hashCode();
        }
    }
}

