/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.apache.commons.vfs2.provider.url.UrlFileSystem;

public class UrlFileProvider
extends AbstractFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public UrlFileProvider() {
        this.setFileNameParser(new UrlFileNameParser());
    }

    @Override
    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            URL url = new URL(uri);
            URL rootUrl = new URL(url, "/");
            String key = this.getClass().getName() + rootUrl.toString();
            FileSystem fs = this.findFileSystem((Comparable<?>)((Object)key), fileSystemOptions);
            if (fs == null) {
                String extForm = rootUrl.toExternalForm();
                FileName rootName = this.getContext().parseURI(extForm);
                fs = new UrlFileSystem(rootName, fileSystemOptions);
                this.addFileSystem((Comparable<?>)((Object)key), fs);
            }
            return fs.resolveFile(url.getPath());
        }
        catch (MalformedURLException e) {
            throw new FileSystemException("vfs.provider.url/badly-formed-uri.error", uri, (Throwable)e);
        }
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

