/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileSystemException;

public class MonitorOutputStream
extends BufferedOutputStream {
    private boolean finished;

    public MonitorOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void close() throws IOException {
        if (this.finished) {
            return;
        }
        IOException exc = null;
        try {
            super.close();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.onClose();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        this.finished = true;
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.assertOpen();
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        super.write(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.assertOpen();
        super.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.assertOpen();
        super.write(b);
    }

    protected void assertOpen() throws FileSystemException {
        if (this.finished) {
            throw new FileSystemException("vfs.provider/closed.error");
        }
    }

    protected void onClose() throws IOException {
    }
}

