/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import junit.framework.TestCase;
import org.apache.commons.vfs2.FileSystemException;

public class FileSystemExceptionTest
extends TestCase {
    public void testMasksPasswordOfUrlsWithBasicAuthentication() {
        FileSystemException fse = new FileSystemException("vfs.provider/rename.error", (Object[])new String[]{"file://test.bin", "http://foo:bar@junit.org/test.bin"});
        FileSystemExceptionTest.assertEquals((String)"file://test.bin", (String)fse.getInfo()[0]);
        FileSystemExceptionTest.assertEquals((String)"http://foo:***@junit.org/test.bin", (String)fse.getInfo()[1]);
    }

    public void testDoesNotModifyUrlsWithoutPassword() {
        FileSystemException fse = new FileSystemException("vfs.provider/delete.error", (Object[])new String[]{"http://foo@junit.org/test.bin"});
        FileSystemExceptionTest.assertEquals((String)"http://foo@junit.org/test.bin", (String)fse.getInfo()[0]);
    }

    public void testProperDetectionOfUrl() {
        FileSystemException fse = new FileSystemException("vfs.provider/delete.error", (Object[])new String[]{"zip:http://foo:bar@junit.org/test.bin"});
        FileSystemExceptionTest.assertEquals((String)"zip:http://foo:***@junit.org/test.bin", (String)fse.getInfo()[0]);
    }
}

