/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ram.test;

import java.io.File;
import junit.framework.Test;
import org.apache.commons.AbstractVfsTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;

public class RamProviderTestCase
extends AbstractProviderTestConfig
implements ProviderTestConfig {
    private boolean inited = false;
    private static Log log = LogFactory.getLog(RamProviderTestCase.class);

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new RamProviderTestCase());
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        try {
            manager.addProvider("ram", (FileProvider)new RamFileProvider());
            manager.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        if (!this.inited) {
            FileObject fo = manager.resolveFile("ram:/");
            RamFileSystem fs = (RamFileSystem)fo.getFileSystem();
            fs.importTree(new File(AbstractVfsTestCase.getTestDirectory()));
            fo.close();
            this.inited = true;
        }
        String uri = "ram:/";
        return manager.resolveFile("ram:/");
    }
}

