/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;

public class DelegatingFileSystemOptionsBuilderTest
extends TestCase {
    private StandardFileSystemManager fsm = null;
    private static String[] schemes = new String[]{"webdav", "http", "ftp", "file", "zip", "tar", "tgz", "bz2", "gz", "jar", "tmp", "ram"};

    protected void setUp() throws Exception {
        super.setUp();
        this.fsm = new StandardFileSystemManager();
        this.fsm.init();
    }

    protected void tearDown() throws Exception {
        if (this.fsm != null) {
            this.fsm.close();
        }
        super.tearDown();
    }

    public void testDelegatingGood() throws Throwable {
        String[] identityPaths = new String[]{"/file1", "/file2"};
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delgate = new DelegatingFileSystemOptionsBuilder((FileSystemManager)this.fsm);
        delgate.setConfigString(opts, "http", "proxyHost", "proxy");
        delgate.setConfigString(opts, "http", "proxyPort", "8080");
        delgate.setConfigClass(opts, "sftp", "userinfo", TrustEveryoneUserInfo.class);
        delgate.setConfigStrings(opts, "sftp", "identities", identityPaths);
        DelegatingFileSystemOptionsBuilderTest.assertEquals((String)"http.proxyHost", (String)HttpFileSystemConfigBuilder.getInstance().getProxyHost(opts), (String)"proxy");
        DelegatingFileSystemOptionsBuilderTest.assertEquals((String)"http.proxyPort", (int)HttpFileSystemConfigBuilder.getInstance().getProxyPort(opts), (int)8080);
        DelegatingFileSystemOptionsBuilderTest.assertEquals((String)"sftp.userInfo", SftpFileSystemConfigBuilder.getInstance().getUserInfo(opts).getClass(), TrustEveryoneUserInfo.class);
        File[] identities = SftpFileSystemConfigBuilder.getInstance().getIdentities(opts);
        DelegatingFileSystemOptionsBuilderTest.assertNotNull((String)"sftp.identities", (Object)identities);
        DelegatingFileSystemOptionsBuilderTest.assertEquals((String)"sftp.identities size", (int)identities.length, (int)identityPaths.length);
        for (int iterIdentities = 0; iterIdentities < identities.length; ++iterIdentities) {
            DelegatingFileSystemOptionsBuilderTest.assertEquals((String)("sftp.identities #" + iterIdentities), (String)identities[iterIdentities].getAbsolutePath(), (String)new File(identityPaths[iterIdentities]).getAbsolutePath());
        }
    }

    public void testDelegatingBad() throws Throwable {
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delgate = new DelegatingFileSystemOptionsBuilder((FileSystemManager)this.fsm);
        try {
            delgate.setConfigString(opts, "http", "proxyPort", "wrong_port");
            DelegatingFileSystemOptionsBuilderTest.fail();
        }
        catch (FileSystemException e) {
            DelegatingFileSystemOptionsBuilderTest.assertEquals(e.getCause().getClass(), InvocationTargetException.class);
            DelegatingFileSystemOptionsBuilderTest.assertEquals(((InvocationTargetException)e.getCause()).getTargetException().getClass(), NumberFormatException.class);
        }
        try {
            delgate.setConfigClass(opts, "sftp", "userinfo", String.class);
            DelegatingFileSystemOptionsBuilderTest.fail();
        }
        catch (FileSystemException e) {
            DelegatingFileSystemOptionsBuilderTest.assertEquals((String)e.getCode(), (String)"vfs.provider/config-value-invalid.error");
        }
    }

    public void testConfiguration() throws Exception {
        for (int i = 0; i < schemes.length; ++i) {
            DelegatingFileSystemOptionsBuilderTest.assertTrue((String)("Missing" + schemes[i] + " provider"), (boolean)this.fsm.hasProvider(schemes[i]));
        }
    }
}

