/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.tar.TarEntry;
import org.apache.commons.vfs2.provider.tar.TarFileSystem;

public class TarFileObject
extends AbstractFileObject
implements FileObject {
    protected TarEntry entry;
    private final HashSet<String> children = new HashSet();
    private final TarFileSystem fs;
    private FileType type;

    protected TarFileObject(AbstractFileName name, TarEntry entry, TarFileSystem fs, boolean tarExists) throws FileSystemException {
        super(name, fs);
        this.fs = fs;
        this.setTarEntry(entry);
        if (!tarExists) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setTarEntry(TarEntry entry) {
        if (this.entry != null) {
            return;
        }
        this.type = entry == null || entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = entry;
    }

    protected void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    @Override
    protected FileType doGetType() {
        return this.type;
    }

    @Override
    protected String[] doListChildren() {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected long doGetContentSize() {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getSize();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getModTime().getTime();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
        }
        return this.fs.getInputStream(this.entry);
    }
}

