/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class PrivilegedFileReplicator
implements FileReplicator,
VfsComponent {
    private final FileReplicator replicator;
    private final VfsComponent replicatorComponent;

    public PrivilegedFileReplicator(FileReplicator replicator) {
        this.replicator = replicator;
        this.replicatorComponent = replicator instanceof VfsComponent ? (VfsComponent)((Object)replicator) : null;
    }

    @Override
    public void setLogger(Log logger) {
        if (this.replicatorComponent != null) {
            this.replicatorComponent.setLogger(logger);
        }
    }

    @Override
    public void setContext(VfsComponentContext context) {
        if (this.replicatorComponent != null) {
            this.replicatorComponent.setContext(context);
        }
    }

    @Override
    public void init() throws FileSystemException {
        if (this.replicatorComponent != null) {
            try {
                AccessController.doPrivileged(new InitAction());
            }
            catch (PrivilegedActionException e) {
                throw new FileSystemException("vfs.impl/init-replicator.error", null, (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        if (this.replicatorComponent != null) {
            AccessController.doPrivileged(new CloseAction());
        }
    }

    @Override
    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        try {
            ReplicateAction action = new ReplicateAction(srcFile, selector);
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            throw new FileSystemException("vfs.impl/replicate-file.error", new Object[]{srcFile.getName()}, (Throwable)e);
        }
    }

    private class CloseAction
    implements PrivilegedAction<Object> {
        private CloseAction() {
        }

        @Override
        public Object run() {
            PrivilegedFileReplicator.this.replicatorComponent.close();
            return null;
        }
    }

    private class ReplicateAction
    implements PrivilegedExceptionAction<File> {
        private final FileObject srcFile;
        private final FileSelector selector;

        public ReplicateAction(FileObject srcFile, FileSelector selector) {
            this.srcFile = srcFile;
            this.selector = selector;
        }

        @Override
        public File run() throws Exception {
            return PrivilegedFileReplicator.this.replicator.replicateFile(this.srcFile, this.selector);
        }
    }

    private class InitAction
    implements PrivilegedExceptionAction<Object> {
        private InitAction() {
        }

        @Override
        public Object run() throws Exception {
            PrivilegedFileReplicator.this.replicatorComponent.init();
            return null;
        }
    }
}

