/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftps.FtpsClientFactory;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

class FtpsClientWrapper
implements FtpClient {
    private static final Log log = LogFactory.getLog(FtpsClientWrapper.class);
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private Integer connectTimeout = null;
    private FTPSClient ftpClient = null;

    FtpsClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions, Integer connectTimeout) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.connectTimeout = connectTimeout;
        this.getFtpsClient();
    }

    FtpsClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this(root, fileSystemOptions, null);
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPSClient createClient() throws FileSystemException {
        FTPSClient fTPSClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpsFileProvider.AUTHENTICATOR_TYPES);
            char[] userName = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName()));
            char[] password = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()));
            fTPSClient = FtpsClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), userName, password, rootName.getPath(), this.getFileSystemOptions(), this.connectTimeout);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPSClient;
    }

    private FTPSClient getFtpsClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
            FtpsDataChannelProtectionLevel level = FtpsFileSystemConfigBuilder.getInstance().getDataChannelProtectionLevel(this.fileSystemOptions);
            if (level != null) {
                try {
                    this.ftpClient.execPBSZ(0L);
                    this.ftpClient.execPROT(level.name());
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        return this.getFtpsClient().isConnected();
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpsClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    @Override
    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.getFtpsClient().listFiles(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().listFiles(relPath);
        }
    }

    @Override
    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpsClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().removeDirectory(relPath);
        }
    }

    @Override
    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpsClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().deleteFile(relPath);
        }
    }

    @Override
    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpsClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().rename(oldName, newName);
        }
    }

    @Override
    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpsClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().makeDirectory(relPath);
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpsClient().completePendingCommand();
        }
        return true;
    }

    @Override
    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpsClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().retrieveFileStream(relPath);
        }
    }

    @Override
    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPSClient client = this.getFtpsClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPSClient client = this.getFtpsClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    @Override
    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpsClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().appendFileStream(relPath);
        }
    }

    @Override
    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpsClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().storeFileStream(relPath);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpsClient().getReplyString();
    }
}

