/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.DefaultFileContent;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.webdav.ExceptionConverter;
import org.apache.commons.vfs2.provider.webdav.WebdavFileContentInfoFactory;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystem;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.WebdavMethodRetryHandler;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CheckinMethod;
import org.apache.jackrabbit.webdav.client.methods.CheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PropPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.UncheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.VersionControlMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Node;

public class WebdavFileObject
extends HttpFileObject
implements FileObject {
    public static final DavPropertyName RESPONSE_CHARSET = DavPropertyName.create((String)"response-charset");
    private final WebdavFileSystem fileSystem;
    private final String urlCharset;
    private final WebdavFileSystemConfigBuilder builder;

    protected WebdavFileObject(AbstractFileName name, WebdavFileSystem fileSystem) {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
        this.builder = (WebdavFileSystemConfigBuilder)WebdavFileSystemConfigBuilder.getInstance();
        this.urlCharset = this.builder.getUrlCharset(this.getFileSystem().getFileSystemOptions());
    }

    protected void configureMethod(HttpMethodBase httpMethod) {
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)WebdavMethodRetryHandler.getInstance());
    }

    @Override
    protected FileType doGetType() throws Exception {
        try {
            return this.isDirectory((URLFileName)this.getName()) ? FileType.FOLDER : FileType.FILE;
        }
        catch (FileNotFolderException fnfe) {
            return FileType.IMAGINARY;
        }
        catch (FileNotFoundException fnfe) {
            return FileType.IMAGINARY;
        }
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return null;
    }

    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        PropFindMethod method = null;
        try {
            URLFileName name = (URLFileName)this.getName();
            if (this.isDirectory(name)) {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DavPropertyName.create((String)"displayname"));
                method = new PropFindMethod(this.urlString(name), nameSet, 1);
                this.execute((DavMethod)method);
                ArrayList<WebdavFileObject> vfs = new ArrayList<WebdavFileObject>();
                if (method.succeeded()) {
                    MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
                    for (int i = 0; i < responses.length; ++i) {
                        String resourceName;
                        MultiStatusResponse response = responses[i];
                        if (this.isCurrentFile(response.getHref(), name) || (resourceName = this.resourceName(response.getHref())) == null || resourceName.length() <= 0) continue;
                        WebdavFileObject fo = (WebdavFileObject)FileObjectUtils.getAbstractFileObject(this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), resourceName, NameScope.CHILD)));
                        vfs.add(fo);
                    }
                }
                FileObject[] fileObjectArray = vfs.toArray(new WebdavFileObject[vfs.size()]);
                return fileObjectArray;
            }
            try {
                throw new FileNotFolderException(this.getName());
            }
            catch (FileNotFolderException fnfe) {
                throw fnfe;
            }
            catch (DavException e) {
                throw new FileSystemException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage(), e);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        MkColMethod method = new MkColMethod(this.urlString((URLFileName)this.getName()));
        this.setupMethod((HttpMethod)method);
        try {
            this.execute((DavMethod)method);
        }
        catch (FileSystemException fse) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", this.getName(), (Throwable)fse);
        }
    }

    @Override
    protected void doDelete() throws Exception {
        DeleteMethod method = new DeleteMethod(this.urlString((URLFileName)this.getName()));
        this.setupMethod((HttpMethod)method);
        this.execute((DavMethod)method);
    }

    @Override
    protected void doRename(FileObject newfile) throws Exception {
        String url = this.encodePath(this.urlString((URLFileName)this.getName()));
        String dest = this.urlString((URLFileName)newfile.getName(), false);
        MoveMethod method = new MoveMethod(url, dest, false);
        this.setupMethod((HttpMethod)method);
        this.execute((DavMethod)method);
    }

    @Override
    protected long doGetContentSize() throws Exception {
        DavProperty property = this.getProperty((URLFileName)this.getName(), "getcontentlength");
        if (property != null) {
            String value = (String)property.getValue();
            return Long.parseLong(value);
        }
        return 0L;
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        DavProperty property = this.getProperty((URLFileName)this.getName(), "getlastmodified");
        if (property != null) {
            String value = (String)property.getValue();
            return DateUtil.parseDate((String)value).getTime();
        }
        return 0L;
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            URLFileName fileName = (URLFileName)this.getName();
            DavPropertySet properties = this.getProperties(fileName, 1, new DavPropertyNameSet(), false);
            for (DavProperty property : properties) {
                attributes.put(property.getName().toString(), property.getValue());
            }
            properties = this.getPropertyNames(fileName);
            for (DavProperty property : properties) {
                if (attributes.containsKey(property.getName()) || (property = this.getProperty(fileName, property.getName())) == null) continue;
                DavPropertyName name = property.getName();
                Object value = property.getValue();
                if (name == null || value == null) continue;
                attributes.put(name.toString(), value);
            }
            return attributes;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)e);
        }
    }

    @Override
    protected void doSetAttribute(String attrName, Object value) throws Exception {
        try {
            URLFileName fileName = (URLFileName)this.getName();
            String urlStr = this.urlString(fileName);
            DavPropertySet properties = new DavPropertySet();
            DavPropertyNameSet propertyNameSet = new DavPropertyNameSet();
            DefaultDavProperty property = new DefaultDavProperty(attrName, value, Namespace.EMPTY_NAMESPACE);
            if (value != null) {
                properties.add((DavProperty)property);
            } else {
                propertyNameSet.add(property.getName());
            }
            PropPatchMethod method = new PropPatchMethod(urlStr, properties, propertyNameSet);
            this.setupMethod((HttpMethod)method);
            this.execute((DavMethod)method);
            if (!method.succeeded()) {
                throw new FileSystemException("Property '" + attrName + "' could not be set.");
            }
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)e);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new WebdavOutputStream(this);
    }

    @Override
    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new WebdavFileContentInfoFactory();
    }

    @Override
    protected void setupMethod(HttpMethod method) throws FileSystemException, URIException {
        String pathEncoded = ((URLFileName)this.getName()).getPathQueryEncoded(this.urlCharset);
        method.setPath(pathEncoded);
        method.setFollowRedirects(false);
        method.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
        method.addRequestHeader("Cache-control", "no-cache");
        method.addRequestHeader("Cache-store", "no-store");
        method.addRequestHeader("Pragma", "no-cache");
        method.addRequestHeader("Expires", "0");
    }

    private void execute(DavMethod method) throws FileSystemException {
        try {
            int status = this.fileSystem.getClient().executeMethod((HttpMethod)method);
            if (status == 404 || status == 410) {
                throw new FileNotFoundException(method.getURI());
            }
            method.checkSuccess();
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private boolean isDirectory(URLFileName name) throws IOException {
        try {
            Node node;
            DavProperty property = this.getProperty(name, "resourcetype");
            if (property != null && (node = (Node)property.getValue()) != null) {
                return node.getLocalName().equals("collection");
            }
            return false;
        }
        catch (FileNotFoundException fse) {
            throw new FileNotFolderException(name);
        }
    }

    DavProperty getProperty(URLFileName fileName, String property) throws FileSystemException {
        return this.getProperty(fileName, DavPropertyName.create((String)property));
    }

    DavProperty getProperty(URLFileName fileName, DavPropertyName name) throws FileSystemException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(name);
        DavPropertySet propertySet = this.getProperties(fileName, nameSet, false);
        return propertySet.get(name);
    }

    DavPropertySet getProperties(URLFileName name, DavPropertyNameSet nameSet, boolean addEncoding) throws FileSystemException {
        return this.getProperties(name, 0, nameSet, addEncoding);
    }

    DavPropertySet getProperties(URLFileName name) throws FileSystemException {
        return this.getProperties(name, 1, new DavPropertyNameSet(), false);
    }

    DavPropertySet getPropertyNames(URLFileName name) throws FileSystemException {
        return this.getProperties(name, 2, new DavPropertyNameSet(), false);
    }

    DavPropertySet getProperties(URLFileName name, int type, DavPropertyNameSet nameSet, boolean addEncoding) throws FileSystemException {
        try {
            String urlStr = this.urlString(name);
            PropFindMethod method = new PropFindMethod(urlStr, type, nameSet, 0);
            this.setupMethod((HttpMethod)method);
            this.execute((DavMethod)method);
            if (method.succeeded()) {
                MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
                MultiStatusResponse response = multiStatus.getResponses()[0];
                DavPropertySet props = response.getProperties(200);
                if (addEncoding) {
                    DefaultDavProperty prop = new DefaultDavProperty(RESPONSE_CHARSET, (Object)method.getResponseCharSet());
                    props.add((DavProperty)prop);
                }
                return props;
            }
            return new DavPropertySet();
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)e);
        }
    }

    private String resourceName(String path) {
        int i;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (i = path.lastIndexOf("/")) >= 0 ? path.substring(i + 1) : path;
    }

    private String urlString(URLFileName name) {
        return this.urlString(name, true);
    }

    private String urlString(URLFileName name, boolean includeUserInfo) {
        String user = null;
        String password = null;
        if (includeUserInfo) {
            user = name.getUserName();
            password = name.getPassword();
        }
        URLFileName newFile = new URLFileName("http", name.getHostName(), name.getPort(), name.getDefaultPort(), user, password, name.getPath(), name.getType(), name.getQueryString());
        try {
            return newFile.getURIEncoded(this.urlCharset);
        }
        catch (Exception e) {
            return name.getURI();
        }
    }

    private boolean isCurrentFile(String href, URLFileName fileName) {
        String name = this.hrefString(fileName);
        if (href.endsWith("/") && !name.endsWith("/")) {
            name = name + "/";
        }
        return href.equals(name);
    }

    private String hrefString(URLFileName name) {
        URLFileName newFile = new URLFileName("http", name.getHostName(), name.getPort(), name.getDefaultPort(), null, null, name.getPath(), name.getType(), name.getQueryString());
        try {
            return newFile.getURIEncoded(this.urlCharset);
        }
        catch (Exception e) {
            return name.getURI();
        }
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        private WebdavFileObject file;

        public WebdavOutputStream(WebdavFileObject file) {
            super(new ByteArrayOutputStream());
            this.file = file;
        }

        @Override
        protected void onClose() throws IOException {
            ByteArrayRequestEntity entity = new ByteArrayRequestEntity(((ByteArrayOutputStream)this.out).toByteArray());
            URLFileName fileName = (URLFileName)WebdavFileObject.this.getName();
            String urlStr = WebdavFileObject.this.urlString(fileName);
            if (WebdavFileObject.this.builder.isVersioning(WebdavFileObject.this.getFileSystem().getFileSystemOptions())) {
                boolean isCheckedIn;
                boolean fileExists;
                block21: {
                    DavPropertySet set = null;
                    fileExists = true;
                    isCheckedIn = true;
                    try {
                        set = WebdavFileObject.this.getPropertyNames(fileName);
                    }
                    catch (FileNotFoundException fnfe) {
                        fileExists = false;
                    }
                    if (fileExists && set != null) {
                        DavProperty prop;
                        if (set.contains(VersionControlledResource.CHECKED_OUT)) {
                            isCheckedIn = false;
                        } else if (!set.contains(VersionControlledResource.CHECKED_IN) && (prop = set.get(VersionControlledResource.AUTO_VERSION)) != null && "checkout-checkin".equals((prop = WebdavFileObject.this.getProperty(fileName, VersionControlledResource.AUTO_VERSION)).getValue())) {
                            this.createVersion(urlStr);
                        }
                    }
                    if (fileExists && isCheckedIn) {
                        try {
                            CheckoutMethod checkout = new CheckoutMethod(urlStr);
                            WebdavFileObject.this.setupMethod((HttpMethod)checkout);
                            WebdavFileObject.this.execute((DavMethod)checkout);
                            isCheckedIn = false;
                        }
                        catch (FileSystemException checkout) {
                            // empty catch block
                        }
                    }
                    try {
                        PutMethod method = new PutMethod(urlStr);
                        method.setRequestEntity((RequestEntity)entity);
                        WebdavFileObject.this.setupMethod((HttpMethod)method);
                        WebdavFileObject.this.execute((DavMethod)method);
                        this.setUserName(fileName, urlStr);
                    }
                    catch (FileSystemException ex) {
                        if (isCheckedIn) break block21;
                        try {
                            UncheckoutMethod method = new UncheckoutMethod(urlStr);
                            WebdavFileObject.this.setupMethod((HttpMethod)method);
                            WebdavFileObject.this.execute((DavMethod)method);
                            isCheckedIn = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ex;
                    }
                }
                if (!fileExists) {
                    this.createVersion(urlStr);
                    try {
                        DavPropertySet props = WebdavFileObject.this.getPropertyNames(fileName);
                        isCheckedIn = !props.contains(VersionControlledResource.CHECKED_OUT);
                    }
                    catch (FileNotFoundException props) {
                        // empty catch block
                    }
                }
                if (!isCheckedIn) {
                    CheckinMethod checkin = new CheckinMethod(urlStr);
                    WebdavFileObject.this.setupMethod((HttpMethod)checkin);
                    WebdavFileObject.this.execute((DavMethod)checkin);
                }
            } else {
                PutMethod method = new PutMethod(urlStr);
                method.setRequestEntity((RequestEntity)entity);
                WebdavFileObject.this.setupMethod((HttpMethod)method);
                WebdavFileObject.this.execute((DavMethod)method);
                try {
                    this.setUserName(fileName, urlStr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((DefaultFileContent)this.file.getContent()).resetAttributes();
        }

        private void setUserName(URLFileName fileName, String urlStr) throws IOException {
            ArrayList<DefaultDavProperty> list = new ArrayList<DefaultDavProperty>();
            String name = WebdavFileObject.this.builder.getCreatorName(WebdavFileObject.this.getFileSystem().getFileSystemOptions());
            String userName = fileName.getUserName();
            if (name == null) {
                name = userName;
            } else if (userName != null) {
                String comment = "Modified by user " + userName;
                list.add(new DefaultDavProperty(DeltaVConstants.COMMENT, (Object)comment));
            }
            list.add(new DefaultDavProperty(DeltaVConstants.CREATOR_DISPLAYNAME, (Object)name));
            PropPatchMethod method = new PropPatchMethod(urlStr, list);
            WebdavFileObject.this.setupMethod((HttpMethod)method);
            WebdavFileObject.this.execute((DavMethod)method);
        }

        private boolean createVersion(String urlStr) {
            try {
                VersionControlMethod method = new VersionControlMethod(urlStr);
                WebdavFileObject.this.setupMethod((HttpMethod)method);
                WebdavFileObject.this.execute((DavMethod)method);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

