/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystem;

public final class WebdavFileSystemConfigBuilder
extends HttpFileSystemConfigBuilder {
    private static final WebdavFileSystemConfigBuilder BUILDER = new WebdavFileSystemConfigBuilder();

    private WebdavFileSystemConfigBuilder() {
        super("webdav.");
    }

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setCreatorName(FileSystemOptions opts, String creatorName) {
        this.setParam(opts, "creatorName", creatorName);
    }

    public String getCreatorName(FileSystemOptions opts) {
        return this.getString(opts, "creatorName");
    }

    public void setVersioning(FileSystemOptions opts, boolean versioning) {
        this.setParam(opts, "versioning", versioning);
    }

    public boolean isVersioning(FileSystemOptions opts) {
        return this.getBoolean(opts, "versioning", false);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return WebdavFileSystem.class;
    }
}

